/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.cmdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.md.cmdi.CMDIServiceProvider;
import mpi.eudico.client.annotator.md.imdi.MDTree;
import mpi.eudico.client.annotator.md.imdi.MDTreeCellRenderer;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;

public class CMDIViewerPanel
extends JPanel
implements MDViewerComponent,
ComponentListener,
ActionListener,
MouseListener {
    private CMDIServiceProvider provider;
    protected JTree tree;
    protected JScrollPane scrollPane;
    private boolean allRowsExpanded = true;
    private boolean allTopNodesExpanded = false;
    private JPopupMenu popup;
    private JMenuItem expandAllMI;
    private JMenuItem collapseAllMI;
    private JMenuItem expandTopMI;
    private JMenuItem collapseTopMI;

    public CMDIViewerPanel() {
    }

    public CMDIViewerPanel(MDServiceProvider provider) {
        if (provider instanceof CMDIServiceProvider) {
            this.provider = (CMDIServiceProvider)provider;
        }
        this.initComponents();
    }

    @Override
    public void setProvider(MDServiceProvider provider) {
        if (provider instanceof CMDIServiceProvider) {
            this.provider = (CMDIServiceProvider)provider;
        }
    }

    protected void initComponents() {
        DefaultMutableTreeNode tNode;
        this.readPreferences();
        this.setLayout(new GridBagLayout());
        this.tree = new MDTree(new DefaultMutableTreeNode("Session"));
        this.scrollPane = new JScrollPane(this.tree);
        this.tree.setCellRenderer(new MDTreeCellRenderer());
        this.tree.setRowHeight(-1);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.scrollPane, gbc);
        JScrollBar vBar = this.scrollPane.getVerticalScrollBar();
        vBar.setUnitIncrement(this.tree.getFont().getSize());
        int barWidth = vBar.getWidth();
        ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth() - barWidth);
        ((MDTree)this.tree).forceUIUpdate();
        if (this.provider != null && (tNode = this.provider.getAsTree()) != null) {
            ((DefaultTreeModel)this.tree.getModel()).setRoot(tNode);
            if (this.allRowsExpanded) {
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    this.tree.expandRow(i);
                }
            } else if (this.allTopNodesExpanded) {
                for (int i = 0; i < this.tree.getRowCount(); ++i) {
                    TreePath tp = this.tree.getPathForRow(i);
                    if (tp == null || tp.getPathCount() != 2) continue;
                    this.tree.expandRow(i);
                }
            }
        }
        this.addComponentListener(this);
        this.tree.addMouseListener(this);
        this.scrollPane.addMouseListener(this);
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu("CMDI");
        this.expandAllMI = new JMenuItem("Expand All");
        this.expandAllMI.addActionListener(this);
        this.popup.add(this.expandAllMI);
        this.collapseAllMI = new JMenuItem("Collapse All");
        this.collapseAllMI.addActionListener(this);
        this.popup.add(this.collapseAllMI);
        this.expandTopMI = new JMenuItem("Expand Top Nodes");
        this.expandTopMI.addActionListener(this);
        this.popup.add(this.expandTopMI);
        this.collapseTopMI = new JMenuItem("Collapse Top Nodes");
        this.collapseTopMI.addActionListener(this);
        this.popup.add(this.collapseTopMI);
    }

    private void updateAllTreeNodes(boolean expand) {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                if (expand) {
                    this.tree.expandRow(i);
                    continue;
                }
                this.tree.collapseRow(i);
            }
        }
    }

    private void updateTopTreeNodes(boolean expand) {
        if (this.tree != null) {
            for (int i = 0; i < this.tree.getRowCount(); ++i) {
                TreePath tp = this.tree.getPathForRow(i);
                if (tp == null || tp.getPathCount() != 2) continue;
                if (expand) {
                    this.tree.expandRow(i);
                    continue;
                }
                this.tree.collapseRow(i);
            }
        }
    }

    private void readPreferences() {
        Boolean boolPref = Preferences.getBool("Metadata.CMDI.AllTreeNodesExpanded", null);
        if (boolPref != null) {
            this.allRowsExpanded = boolPref;
        }
        if ((boolPref = Preferences.getBool("Metadata.CMDI.AllTopNodesExpanded", null)) != null) {
            this.allTopNodesExpanded = boolPref;
        }
    }

    @Override
    public void setSelectedKeysAndValues(Map<String, String> keysAndValuesMap) {
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
    }

    public void dataModelUpdated() {
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    public void reinitializeTree() {
        if (this.provider != null) {
            DefaultMutableTreeNode tNode = this.provider.getAsTree();
            if (tNode != null) {
                int i;
                ((DefaultTreeModel)this.tree.getModel()).setRoot(tNode);
                if (this.allRowsExpanded) {
                    for (i = 0; i < this.tree.getRowCount(); ++i) {
                        this.tree.expandRow(i);
                    }
                } else if (this.allTopNodesExpanded) {
                    for (i = 0; i < this.tree.getRowCount(); ++i) {
                        TreePath tp = this.tree.getPathForRow(i);
                        if (tp == null || tp.getPathCount() != 2) continue;
                        this.tree.expandRow(i);
                    }
                }
                this.provider.updateTreeForLanguage();
                int barWidth = this.scrollPane.getVerticalScrollBar().getWidth();
                ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth() - barWidth);
                ((MDTree)this.tree).forceUIUpdate();
            } else {
                ((DefaultTreeModel)this.tree.getModel()).setRoot(new DefaultMutableTreeNode(ElanLocale.getString("MetadataViewer.NoMetadataLoaded")));
            }
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.tree != null) {
            int barWidth = this.scrollPane.getVerticalScrollBar().getWidth();
            ((MDTree)this.tree).setDisplayWidth(this.scrollPane.getViewport().getWidth() - barWidth);
            ((MDTree)this.tree).forceUIUpdate();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.tree != null) {
            ((MDTree)this.tree).forceUIUpdate();
        }
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.tree == null) {
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
            if (this.popup == null) {
                this.createPopupMenu();
            }
            Point pp = e.getPoint();
            pp.move(pp.x, pp.y - this.scrollPane.getVerticalScrollBar().getValue());
            if (this.popup.getWidth() == 0 || this.popup.getHeight() == 0) {
                this.popup.show(this, pp.x, pp.y);
            } else {
                this.popup.show(this, pp.x, pp.y);
                SwingUtilities.convertPointToScreen(pp, this);
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                Window w = SwingUtilities.windowForComponent(this);
                if (pp.x + this.popup.getWidth() > d.width) {
                    pp.x -= this.popup.getWidth();
                }
                if (pp.y + this.popup.getHeight() > d.height) {
                    pp.y -= this.popup.getHeight();
                }
                if (pp.y + this.popup.getHeight() > w.getLocationOnScreen().y + w.getHeight()) {
                    pp.y -= this.popup.getHeight();
                }
                this.popup.setLocation(pp);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.expandAllMI) {
            this.updateAllTreeNodes(true);
            this.allRowsExpanded = true;
            Preferences.set("Metadata.CMDI.AllTreeNodesExpanded", this.allRowsExpanded, null);
        } else if (ae.getSource() == this.collapseAllMI) {
            this.updateAllTreeNodes(false);
            this.allRowsExpanded = false;
            Preferences.set("Metadata.CMDI.AllTreeNodesExpanded", this.allRowsExpanded, null);
        } else if (ae.getSource() == this.expandTopMI) {
            this.updateTopTreeNodes(true);
            this.allTopNodesExpanded = true;
            Preferences.set("Metadata.CMDI.AllTopNodesExpanded", this.allTopNodesExpanded, null);
        } else if (ae.getSource() == this.collapseTopMI) {
            this.updateTopTreeNodes(false);
            this.allTopNodesExpanded = false;
            Preferences.set("Metadata.CMDI.AllTopNodesExpanded", this.allTopNodesExpanded, null);
        }
    }
}

