/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import mpi.eudico.client.annotator.md.imdi.ImdiCheckHandler;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ImdiSaxCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSessionFile(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        FileInputStream fis = null;
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/validation", false);
            ImdiCheckHandler handler = new ImdiCheckHandler();
            reader.setContentHandler(handler);
            fis = new FileInputStream(file);
            InputSource source = new InputSource(fis);
            try {
                reader.parse(source);
            }
            catch (SAXException sax) {
                ClientLogger.LOG.info("Is CMDI/IMDI Session file: " + handler.isSessionFile());
                boolean bl = handler.isSessionFile();
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException ioe) {
                try {
                    ClientLogger.LOG.warning("Cannot read file: " + ioe.getMessage());
                }
                catch (SAXException sex) {
                    ClientLogger.LOG.warning("Cannot parse file: " + sex.getMessage());
                }
                catch (FileNotFoundException fnfe) {
                    ClientLogger.LOG.warning("Cannot find file: " + fnfe.getMessage());
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException sex) {}
        }
        return false;
    }
}

