/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.md.imdi.ImdiKeyRenderer;
import mpi.eudico.client.annotator.md.imdi.MultiLineValueRenderer;

public class MDTable
extends JTable
implements ComponentListener {
    private int defaultRowHeight;
    private ImdiKeyRenderer keyRenderer;
    private MultiLineValueRenderer valRenderer;

    public MDTable(TableModel dm) {
        super(dm);
        if (dm.getRowCount() > 0) {
            this.calculateRowHeights();
        }
        this.addComponentListener(this);
    }

    @Override
    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.keyRenderer = new ImdiKeyRenderer();
        this.getColumn(this.dataModel.getColumnName(0)).setCellRenderer(this.keyRenderer);
        this.valRenderer = new MultiLineValueRenderer(true);
        this.getColumn(this.dataModel.getColumnName(1)).setCellRenderer(this.valRenderer);
        this.setAutoCreateColumnsFromModel(false);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        super.columnMarginChanged(e);
        this.calculateRowHeights();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.keyRenderer != null) {
            this.keyRenderer.updateUI();
        }
        if (this.valRenderer != null) {
            this.valRenderer.updateUI();
        }
    }

    @Override
    public int getRowHeight() {
        if (this.defaultRowHeight > 0) {
            return this.defaultRowHeight;
        }
        return super.getRowHeight();
    }

    @Override
    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        this.calculateRowHeights();
    }

    @Override
    public int getRowHeight(int row) {
        return super.getRowHeight(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.calculateRowHeights();
        this.revalidate();
    }

    public void calculateRowHeights() {
        int numRows = this.dataModel.getRowCount();
        Font f = this.getFont();
        if (f == null) {
            return;
        }
        FontMetrics metrics = this.getFontMetrics(f);
        if (metrics == null) {
            return;
        }
        this.defaultRowHeight = metrics.getHeight() + 2;
        int columnWidth = this.getCellRect((int)0, (int)1, (boolean)false).width - 4;
        for (int i = 0; i < numRows; ++i) {
            String val = (String)this.dataModel.getValueAt(i, 1);
            if (val == null || val.length() == 0) continue;
            int numLines = this.calculateNumLines(metrics, this.getGraphics(), columnWidth, val);
            int h = numLines * this.defaultRowHeight;
            if (this.getRowHeight(i) == h) continue;
            this.setRowHeight(i, h);
        }
    }

    private int calculateNumLines(FontMetrics fm, Graphics g, int width, String text) {
        int totalWidth = (int)fm.getStringBounds(text, g).getWidth();
        if (totalWidth <= width) {
            return 1;
        }
        int numLines = 0;
        StringBuilder builder = new StringBuilder(text);
        int beginIndex = 0;
        int endIndex = -1;
        int lastTestedEndIndex = 0;
        for (int i = 0; i < builder.length(); ++i) {
            char[] seq;
            if (Character.isWhitespace(builder.charAt(i)) && ++endIndex > beginIndex) {
                seq = new char[endIndex - 1 - beginIndex];
                builder.getChars(beginIndex, endIndex - 1, seq, 0);
                if (fm.getStringBounds(seq, 0, seq.length, g).getWidth() > (double)width) {
                    ++numLines;
                    beginIndex = lastTestedEndIndex > beginIndex ? lastTestedEndIndex + 1 : endIndex + 1;
                } else {
                    lastTestedEndIndex = endIndex;
                    if (builder.charAt(i) != '\n') continue;
                    ++numLines;
                    beginIndex = endIndex + 1;
                    continue;
                }
            }
            if (i != builder.length() - 1 || endIndex <= beginIndex) continue;
            seq = new char[endIndex - beginIndex];
            builder.getChars(beginIndex, endIndex, seq, 0);
            int w = (int)fm.getStringBounds(seq, 0, seq.length, g).getWidth();
            if (w > width) {
                numLines += w / width + 1;
                continue;
            }
            ++numLines;
        }
        return numLines == 0 ? 1 : numLines;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.calculateRowHeights();
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

