/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.multiplefilesedit.MFEFrame;
import mpi.eudico.client.annotator.util.FileExtension;

public class DomainPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 7647117764716393078L;
    private List<String> searchDirs;
    private List<String> searchPaths;
    private File[] searchFiles;
    private JButton domainButton;
    private JButton startStopButton;
    private MFEFrame mfeParent;

    public DomainPane(MFEFrame mfeParent) {
        this.mfeParent = mfeParent;
        this.initComponents();
    }

    private void initComponents() {
        BorderLayout lm = new BorderLayout();
        this.setLayout(lm);
        this.domainButton = new JButton();
        this.domainButton.setActionCommand("OpenDomainDialog");
        this.domainButton.addActionListener(this);
        this.add((Component)this.domainButton, "Before");
        this.startStopButton = new JButton(ElanLocale.getString("MFE.Apply"));
        this.startStopButton.setActionCommand("ApplyMultiFiles");
        this.startStopButton.addActionListener(this);
        this.add((Component)this.startStopButton, "After");
        this.startStopButton.setEnabled(false);
    }

    public void updateLocale() {
        this.setBorder(new TitledBorder(ElanLocale.getString("MFE.Domain")));
        this.domainButton.setText(ElanLocale.getString("MFE.DomainDefKey"));
    }

    private boolean updateFileList() {
        List<File> files = this.getMultipleFiles(null, ElanLocale.getString("MultipleFileSearch.DomainDialogTitle"));
        if (files != null && files.size() > 0) {
            this.searchFiles = files.toArray(new File[files.size()]);
            return true;
        }
        return false;
    }

    protected List<File> getMultipleFiles(JFrame parent, String title) {
        File f;
        String name;
        int i;
        ArrayList<File> files = new ArrayList<File>();
        if (this.searchDirs == null) {
            this.searchDirs = new ArrayList<String>();
        }
        if (this.searchPaths == null) {
            this.searchPaths = new ArrayList<String>();
        }
        MFDomainDialog mfDialog = new MFDomainDialog(parent, title, true);
        mfDialog.setSearchDirs(this.searchDirs);
        mfDialog.setSearchPaths(this.searchPaths);
        mfDialog.setVisible(true);
        this.searchDirs = mfDialog.getSearchDirs();
        this.searchPaths = mfDialog.getSearchPaths();
        if (this.searchPaths.size() > 0) {
            for (i = 0; i < this.searchPaths.size(); ++i) {
                name = this.searchPaths.get(i);
                f = new File(name);
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
        }
        if (this.searchDirs.size() > 0) {
            for (i = 0; i < this.searchDirs.size(); ++i) {
                name = this.searchDirs.get(i);
                f = new File(name);
                if (f.isFile() && f.canRead()) {
                    files.add(f);
                    continue;
                }
                if (!f.isDirectory() || !f.canRead()) continue;
                this.addFiles(f, files);
            }
        }
        return files;
    }

    protected void addFiles(File dir, List<File> files) {
        File[] allSubs;
        if (dir == null && files == null) {
            return;
        }
        for (File allSub : allSubs = dir.listFiles()) {
            if (allSub.isDirectory() && allSub.canRead()) {
                this.addFiles(allSub, files);
                continue;
            }
            if (!allSub.canRead() || !allSub.getName().toLowerCase().endsWith(FileExtension.EAF_EXT[0])) continue;
            files.add(allSub);
        }
    }

    public File[] getSearchFiles() {
        return this.searchFiles;
    }

    public void clearSearchFiles() {
        this.searchFiles = new File[0];
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            if (e.getActionCommand().equals("OpenDomainDialog") && this.updateFileList()) {
                this.mfeParent.loadFiles();
            }
            if (e.getActionCommand().equals("ApplyMultiFiles")) {
                Object[] options = new Object[]{ElanLocale.getString("Button.No"), ElanLocale.getString("Button.Yes")};
                int n = JOptionPane.showOptionDialog(this, ElanLocale.getString("MFE.SaveMessage"), ElanLocale.getString("MFE.SaveMessageTitle"), 0, 2, null, options, options[0]);
                if (n == 1) {
                    this.mfeParent.writeChanges();
                }
            }
        }
    }

    public void enableUI(boolean b) {
        this.domainButton.setEnabled(b);
        this.startStopButton.setEnabled(b && this.searchFiles.length > 0);
        if (b) {
            this.startStopButton.setText(ElanLocale.getString("MFE.Apply"));
        } else {
            this.startStopButton.setText(ElanLocale.getString("MFE.Busy"));
        }
    }
}

