/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.EscCloseAction;
import mpi.eudico.client.annotator.multiplefilesedit.DomainPane;
import mpi.eudico.client.annotator.multiplefilesedit.InconsistentChildrenException;
import mpi.eudico.client.annotator.multiplefilesedit.InconsistentTypeException;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTierPanel;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTypePanel;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;
import mpi.eudico.util.multilangcv.RecentLanguages;

public class MFEFrame
extends JFrame
implements ActionListener,
ProgressListener {
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private MFEModel model;
    private DomainPane domainPanel;
    private TableByTierPanel tableByTierPanel;
    private TableByTypePanel tableByTypePanel;
    Set<String> parseErrorSet = new HashSet<String>();
    private JProgressBar progressBar;
    private JButton closeButton;

    public MFEFrame(String name) {
        this.model = new MFEModel();
        this.setSize(640, 480);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.ensureMultipleLanguagesKnown();
        this.initComponents();
        this.updateLocale();
        this.pack();
        this.postInit();
    }

    private void initComponents() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.insets = insets;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.fill = 1;
        this.domainPanel = new DomainPane(this);
        this.add((Component)this.domainPanel, c);
        c.gridy = 1;
        c.weighty = 0.9;
        c.fill = 1;
        JTabbedPane tabbedPane = new JTabbedPane();
        this.tableByTierPanel = new TableByTierPanel(this.model);
        tabbedPane.addTab(ElanLocale.getString("MFE.TierTab.Title"), null, this.tableByTierPanel, ElanLocale.getString("MFE.TierTab.TitleMO"));
        this.tableByTypePanel = new TableByTypePanel(this.model, this);
        tabbedPane.addTab(ElanLocale.getString("MFE.TypeTab.Title"), null, this.tableByTypePanel, ElanLocale.getString("MFE.TypeTab.TitleMO"));
        this.add((Component)tabbedPane, c);
        c.gridy = 2;
        c.weighty = 0.0;
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        this.add((Component)this.progressBar, c);
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.5;
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.closeButton.setActionCommand("CloseMultiFiles");
        this.closeButton.addActionListener(this);
        this.add((Component)this.closeButton, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent we) {
                Preferences.set("MFE.FrameBounds", MFEFrame.this.getBounds(), null, false, false);
            }
        });
    }

    private void postInit() {
        Rectangle bounds = Preferences.getRect("MFE.FrameBounds", null);
        if (bounds != null) {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            if (bounds.width > dim.width) {
                bounds.width = dim.width;
            }
            if (bounds.height > dim.height) {
                bounds.height = dim.height;
            }
            this.setBounds(bounds);
        }
    }

    private void ensureMultipleLanguagesKnown() {
        RecentLanguages rl = RecentLanguages.getInstance();
        LangInfo info = rl.getLanguageInfo("mul");
        if (info == null && (info = LanguageCollection.getLanguageInfo("mul")) != null) {
            rl.addRecentLanguage(info);
        }
    }

    public void initCombobox() {
        this.tableByTierPanel.initCombobox();
    }

    public void loadFiles() {
        this.enableUI(false);
        EAFLoadThread elt = new EAFLoadThread();
        try {
            elt.start();
        }
        catch (IllegalThreadStateException ie) {
            ie.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void writeChanges() {
        this.enableUI(false);
        int saveAsType = SaveAs27Preferences.saveAsType(null);
        EAFWriteThread ewt = new EAFWriteThread(saveAsType);
        try {
            ewt.start();
        }
        catch (IllegalThreadStateException ie) {
            ie.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateLocale() {
        this.domainPanel.updateLocale();
        this.tableByTierPanel.updateLocale();
        this.tableByTypePanel.updateLocale();
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.setTitle(ElanLocale.getString("MFE.FrameTitle"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton && e.getActionCommand().equals("CloseMultiFiles")) {
            this.dispose();
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (source instanceof EAFLoadThread) {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
            this.enableUI(true);
        } else {
            this.progressBar.setValue(100);
            this.progressBar.setString(message);
            this.enableUI(true);
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }
    }

    private void threadProgressCompleted(final Object source, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MFEFrame.this.progressCompleted(source, message);
            }
        });
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (source instanceof EAFLoadThread) {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        } else if (source instanceof EAFWriteThread) {
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        } else {
            this.progressBar.setString(message);
            this.showWarningDialog(ElanLocale.getString("MultipleFileSearch.FindReplace.Warn5"));
            this.progressBar.setValue(0);
            this.progressBar.setString("");
        }
        this.enableUI(true);
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (percent == this.progressBar.getMaximum()) {
            this.progressCompleted(source, message);
        } else {
            this.progressBar.setValue(percent);
            this.progressBar.setString(message);
        }
    }

    private void threadProgressUpdated(final Object source, final int percent, final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MFEFrame.this.progressUpdated(source, percent, message);
            }
        });
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void enableUI(boolean b) {
        boolean enableEdit = b && this.domainPanel.getSearchFiles().length > 0;
        this.domainPanel.enableUI(b);
        this.tableByTierPanel.enableUI(enableEdit);
        this.tableByTypePanel.enableUI(enableEdit);
        this.closeButton.setEnabled(b);
        if (b) {
            this.setDefaultCloseOperation(2);
        } else {
            this.setDefaultCloseOperation(0);
        }
    }

    protected void addCloseActions() {
        EscCloseAction escAction = new EscCloseAction(this);
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            String esc = "esc";
            inputMap.put((KeyStroke)escAction.getValue("AcceleratorKey"), esc);
            actionMap.put(esc, escAction);
            String wcl = "cw";
            inputMap.put((KeyStroke)wAction.getValue("AcceleratorKey"), wcl);
            actionMap.put(wcl, wAction);
        }
    }

    private class EAFLoadThread
    extends Thread {
        private boolean continue_without_dialog = false;
        private boolean continue_loading = true;

        @Override
        public void run() {
            if (MFEFrame.this.domainPanel.getSearchFiles() != null && MFEFrame.this.domainPanel.getSearchFiles().length != 0) {
                Object message;
                String fileName = null;
                float perFile = 100.0f / (float)MFEFrame.this.domainPanel.getSearchFiles().length;
                int count = 0;
                MFEFrame.this.model.clear();
                this.continue_without_dialog = false;
                ArrayList<String> parseErrorList = new ArrayList<String>();
                for (File file : MFEFrame.this.domainPanel.getSearchFiles()) {
                    if (file == null) {
                        MFEFrame.this.threadProgressUpdated(this, (int)((float)(++count) * perFile), ElanLocale.getString("MFE.LoadingFiles"));
                        continue;
                    }
                    if (!this.continue_loading) break;
                    fileName = file.getAbsolutePath();
                    fileName = FileUtility.pathToURLString(fileName).substring(5);
                    try {
                        EAFSkeletonParser parser = new EAFSkeletonParser(fileName, true);
                        parser.parse();
                        List<LinguisticType> types = parser.getLinguisticTypes();
                        for (LinguisticType type : types) {
                            if (type == null) continue;
                            try {
                                int row_nr = MFEFrame.this.model.addOriginalType(type);
                                this.fireTypeRowAdded(row_nr);
                            }
                            catch (InconsistentTypeException ite) {
                                final String fileName1 = fileName;
                                this.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        JOptionPane.showMessageDialog(MFEFrame.this.domainPanel, ElanLocale.getString("MFE.Loader.InconsistentType.Warning1") + " " + fileName1 + " " + ElanLocale.getString("MFE.Loader.InconsistentType.Warning2") + " " + ite.getInconsistentType().getLinguisticTypeName() + " " + ElanLocale.getString("MFE.Loader.InconsistentType.Warning3"), ElanLocale.getString("MFE.Loader.InconsistentType.Title"), 2);
                                    }
                                });
                            }
                        }
                        List<LanguageRecord> langs = parser.getLanguageRecords();
                        if (langs != null) {
                            RecentLanguages recent = RecentLanguages.getInstance();
                            for (LanguageRecord l : langs) {
                                recent.addRecentLanguage(new LangInfo(l.getId(), l.getDef(), l.getLabel()));
                            }
                        }
                        List<TierImpl> tiers = parser.getTiers();
                        for (TierImpl tier : tiers) {
                            if (tier == null) continue;
                            String name = tier.getName();
                            String type = tier.getLinguisticType().getLinguisticTypeName();
                            String annotator = tier.getAnnotator();
                            String participant = tier.getParticipant();
                            String parent = tier.getParentTier() == null ? null : tier.getParentTier().getName();
                            String langRef = tier.getLangRef();
                            if (langRef == null) {
                                langRef = "";
                            }
                            int row_nr = -1;
                            try {
                                row_nr = MFEFrame.this.model.addOriginalTier(name, type, annotator, participant, parent, langRef);
                            }
                            catch (InconsistentChildrenException e) {
                                final String fileName1 = fileName;
                                this.invokeAndWait(new Runnable(){

                                    @Override
                                    public void run() {
                                        int n;
                                        if (!EAFLoadThread.this.continue_without_dialog) {
                                            Object[] options = new Object[]{ElanLocale.getString("MFE.Loader.InconsistentChild.YesDontAsk"), ElanLocale.getString("MFE.Loader.InconsistentChild.YesCont"), ElanLocale.getString("MFE.Loader.InconsistentChild.NoStop")};
                                            String message0 = ElanLocale.getString("MFE.Loader.InconsistentChild.Warning1") + "\n " + fileName1 + ".\n";
                                            message0 = e.getLoadedParents() == null ? message0 + ElanLocale.getString("MFE.Loader.InconsistentChild.Warning3") + " `" + e.getChild() + "' " + ElanLocale.getString("MFE.Loader.InconsistentChild.Warning3a") : message0 + ElanLocale.getString("MFE.Loader.InconsistentChild.Warning3") + " `" + e.getChild() + "' " + ElanLocale.getString("MFE.Loader.InconsistentChild.Warning3b") + " `" + e.getLoadedParents() + "'.";
                                            String title = ElanLocale.getString("MFE.Loader.InconsistentChild.Title");
                                            String message = message0;
                                            n = JOptionPane.showOptionDialog(MFEFrame.this.domainPanel, message, title, 1, 2, null, options, options[2]);
                                        } else {
                                            n = 1;
                                        }
                                        if (n == 0) {
                                            MFEFrame.this.model.setRemovableTiers(false);
                                            EAFLoadThread.this.continue_without_dialog = true;
                                        } else if (n == 1) {
                                            MFEFrame.this.model.setRemovableTiers(false);
                                        } else {
                                            MFEFrame.this.model.clear();
                                            EAFLoadThread.this.fireTierRowAdded(0);
                                            EAFLoadThread.this.continue_loading = false;
                                            MFEFrame.this.domainPanel.clearSearchFiles();
                                        }
                                    }
                                });
                            }
                            if (!this.continue_loading) break;
                            this.fireTierRowAdded(row_nr);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MFEFrame.this.tableByTierPanel.initCombobox();
                            }
                        });
                    }
                    catch (ParseException pe) {
                        MFEFrame.this.parseErrorSet.add(fileName);
                        parseErrorList.add(fileName);
                    }
                    MFEFrame.this.threadProgressUpdated(this, (int)((float)(++count) * perFile), ElanLocale.getString("MFE.LoadingFiles") + " (" + file.getName() + ")");
                }
                if (!parseErrorList.isEmpty()) {
                    message = ElanLocale.getString("MFE.Loader.ParseErrorMessage") + "\n";
                    for (String file : parseErrorList) {
                        message = (String)message + file + "\n";
                    }
                    String title = ElanLocale.getString("MFE.Loader.ParseErrorTitle");
                    this.showMessageDialog((String)message, title);
                }
                if (!MFEFrame.this.model.areTiersRemovable()) {
                    message = ElanLocale.getString("MFE.Loader.TierRemovalDisabled.Warning");
                    String title = ElanLocale.getString("MFE.Loader.TierRemovalDisabled.Title");
                    this.showMessageDialog((String)message, title);
                }
                MFEFrame.this.threadProgressCompleted(this, null);
            }
        }

        private void invokeAndWait(Runnable runnable) {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
        }

        private void showMessageDialog(final String message, final String title) {
            this.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MFEFrame.this.domainPanel, message, title, 2);
                }
            });
        }

        private void fireTypeRowAdded(final int row_nr) {
            if (row_nr >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MFEFrame.this.tableByTypePanel.rowAdded(row_nr);
                    }
                });
            }
        }

        private void fireTierRowAdded(final int row_nr) {
            if (row_nr >= 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MFEFrame.this.tableByTierPanel.rowAdded(row_nr);
                    }
                });
            }
        }
    }

    private class EAFWriteThread
    extends Thread {
        private File[] domain_files;
        int saveAsType;

        public EAFWriteThread(int saveAsType) {
            this.saveAsType = saveAsType;
            this.domain_files = MFEFrame.this.domainPanel.getSearchFiles();
        }

        @Override
        public void run() {
            if (this.domain_files != null && this.domain_files.length > 0) {
                float perFile = 100.0f / (float)MFEFrame.this.domainPanel.getSearchFiles().length;
                int count = 0;
                for (File file : this.domain_files) {
                    if (file == null) {
                        MFEFrame.this.threadProgressUpdated(this, (int)((float)(++count) * perFile), ElanLocale.getString("MFE.SavingChanges"));
                        continue;
                    }
                    String fileName = file.getAbsolutePath();
                    if (MFEFrame.this.parseErrorSet.contains(fileName = FileUtility.pathToURLString(fileName).substring(5))) continue;
                    System.out.println("INFO: " + file.getName());
                    TranscriptionImpl trans = new TranscriptionImpl(file.getAbsolutePath());
                    System.out.println("DEBUG: Linguistic types");
                    List<LinguisticType> types = trans.getLinguisticTypes();
                    for (LinguisticType linguisticType : types) {
                        MFEModel.Changes change = MFEFrame.this.model.getTypeChangeByOriginalName(linguisticType.getLinguisticTypeName());
                        System.err.println("DEBUG: " + linguisticType.getLinguisticTypeName() + "." + change);
                        if (change == null) continue;
                        switch (change) {
                            case NEW: 
                            case NEW_MODIFIED: {
                                LinguisticType new_type = MFEFrame.this.model.getTypeByOriginalName(linguisticType.getLinguisticTypeName());
                                trans.addLinguisticType(new_type);
                                break;
                            }
                            case MODIFIED: {
                                LinguisticType linguisticType2 = MFEFrame.this.model.getTypeByOriginalName(linguisticType.getLinguisticTypeName());
                                linguisticType.setLinguisticTypeName(linguisticType2.getLinguisticTypeName());
                                break;
                            }
                            case REMOVED: {
                                break;
                            }
                        }
                    }
                    int type_index = 0;
                    for (LinguisticType type3 : MFEFrame.this.model.getTypes()) {
                        if (MFEFrame.this.model.getTypeChange(type_index) == MFEModel.Changes.NEW || MFEFrame.this.model.getTypeChange(type_index) == MFEModel.Changes.NEW_MODIFIED) {
                            System.err.println("DEBUG: New type " + type3.getLinguisticTypeName());
                            if (trans.getLinguisticTypeByName(type3.getLinguisticTypeName()) == null) {
                                trans.addLinguisticType(type3);
                                System.err.println("DEBUG: Unknown type " + type3.getLinguisticTypeName());
                            }
                        }
                        ++type_index;
                    }
                    System.out.println("DEBUG: Tiers");
                    List<TierImpl> list = trans.getTiers();
                    ArrayList<TierImpl> toBeRemoved = new ArrayList<TierImpl>();
                    block14: for (TierImpl tierImpl : list) {
                        MFEModel.Changes change = MFEFrame.this.model.getTierChangeByOriginalName(tierImpl.getName());
                        System.err.println("DEBUG: " + tierImpl.getName() + "." + change);
                        switch (change) {
                            case MODIFIED: {
                                String new_lang;
                                LinguisticType new_type;
                                String participant;
                                TierImpl new_tier = MFEFrame.this.model.getTierByOriginalName(tierImpl.getName());
                                if (new_tier == null) break;
                                tierImpl.setName(new_tier.getName());
                                String annotator = new_tier.getAnnotator();
                                if (!annotator.contains(",")) {
                                    tierImpl.setAnnotator(annotator);
                                }
                                if (!(participant = new_tier.getParticipant()).contains(",")) {
                                    tierImpl.setParticipant(participant);
                                }
                                if (!(new_type = new_tier.getLinguisticType()).getLinguisticTypeName().equals(ElanLocale.getString("MFE.Multiple"))) {
                                    if (trans.getLinguisticTypeByName(new_type.getLinguisticTypeName()) == null) {
                                        trans.addLinguisticType(new_type);
                                    }
                                    tierImpl.setLinguisticType(new_type);
                                }
                                if ((new_lang = new_tier.getLangRef()) == null) {
                                    tierImpl.setLangRef(null);
                                    break;
                                }
                                if (new_lang.contains(",")) continue block14;
                                tierImpl.setLangRef(new_lang);
                                break;
                            }
                            case REMOVED: {
                                toBeRemoved.add(tierImpl);
                                break;
                            }
                        }
                    }
                    for (TierImpl tierImpl : toBeRemoved) {
                        trans.removeTier(tierImpl);
                    }
                    int tier_index = 0;
                    for (TierImpl tier : MFEFrame.this.model.getTiers()) {
                        if ((MFEFrame.this.model.getTierChange(tier_index) == MFEModel.Changes.NEW || MFEFrame.this.model.getTierChange(tier_index) == MFEModel.Changes.NEW_MODIFIED) && trans.getTierWithId(tier.getName()) == null) {
                            LinguisticType type4 = tier.getLinguisticType();
                            System.err.println("DEBUG: New tier " + tier.getName());
                            if (trans.getLinguisticTypeByName(type4.getLinguisticTypeName()) == null) {
                                trans.addLinguisticType(type4);
                                System.err.println("DEBUG: Unknown type, adding type " + type4.getLinguisticTypeName());
                            } else {
                                Constraint transType = trans.getLinguisticTypeByName(type4.getLinguisticTypeName()).getConstraints();
                                Constraint tierType = type4.getConstraints();
                                int transStereotype = -1;
                                int tierStereotype = -1;
                                if (transType != null) {
                                    transStereotype = transType.getStereoType();
                                }
                                if (tierType != null) {
                                    tierStereotype = tierType.getStereoType();
                                }
                                if (transStereotype != tierStereotype) {
                                    System.err.println("DEBUG: Incompatible (stereo) types " + type4.getLinguisticTypeName() + " skipping tier");
                                    ++tier_index;
                                    continue;
                                }
                            }
                            trans.addTier(tier);
                        }
                        ++tier_index;
                    }
                    try {
                        ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscription(trans, null, new ArrayList<TierImpl>(0), this.saveAsType);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    System.out.println("::::::::::::::::::::::::::::::::::::::::::::::::::::");
                    System.out.println("::::: Closing file :::::::::::::::::::::::::::::::::");
                    System.out.println("::::::::::::::::::::::::::::::::::::::::::::::::::::");
                    MFEFrame.this.threadProgressUpdated(this, (int)((float)(++count) * perFile), ElanLocale.getString("MFE.SavingChanges") + " (" + file.getName() + ")");
                }
            }
            MFEFrame.this.threadProgressCompleted(this, null);
        }
    }
}

