/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.multiplefilesedit.MFEModel;
import mpi.eudico.client.annotator.multiplefilesedit.MFETable;
import mpi.eudico.client.annotator.multiplefilesedit.RowModel;
import mpi.eudico.client.annotator.multiplefilesedit.TableByTierModel;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;

public class MFETierTable
extends MFETable {
    private RowModel rm;
    MyRecentLanguagesEditor langEditor;
    MyRecentLanguagesRenderer langRenderer;

    public MFETierTable(MFEModel model) {
        super(model);
        this.setModel(new TableByTierModel(model));
        this.setRowEditorModel(new RowModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCombobox() {
        MFEModel mFEModel = this.model;
        synchronized (mFEModel) {
            int row_count = this.model.getTierRowCount();
            for (int i = 0; i < row_count; ++i) {
                String[] linguistic_types = this.model.getLinguisticTypeNamesByTier(i);
                this.rm.addEditorForRow(i, new MyComboBoxEditor(linguistic_types));
                this.rm.addRendererForRow(i, new MyComboBoxRenderer(linguistic_types));
            }
            this.repaint();
        }
    }

    public void newRow(int new_row) {
        String[] linguistic_types = this.model.getLinguisticTypeNamesByTier(new_row);
        this.rm.addEditorForRow(new_row, new MyComboBoxEditor(linguistic_types));
        this.rm.addRendererForRow(new_row, new MyComboBoxRenderer(linguistic_types));
    }

    public void setRowEditorModel(RowModel rm) {
        this.rm = rm;
    }

    public RowModel getRowEditorModel() {
        return this.rm;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int col) {
        row = this.convertRowIndexToModel(row);
        if (col == 1) {
            TableCellEditor tmpEditor = null;
            if (this.rm != null) {
                tmpEditor = this.rm.getEditor(row);
            }
            if (tmpEditor != null) {
                return tmpEditor;
            }
        }
        if (col == 4) {
            if (this.langEditor == null) {
                this.langEditor = new MyRecentLanguagesEditor();
            }
            return this.langEditor;
        }
        return super.getCellEditor(row, col);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int col) {
        row = this.convertRowIndexToModel(row);
        if (col == 1) {
            TableCellRenderer tmpRenderer = null;
            if (this.rm != null) {
                tmpRenderer = this.rm.getRenderer(row);
            }
            if (tmpRenderer != null) {
                return tmpRenderer;
            }
        }
        if (col == 4) {
            if (this.langRenderer == null) {
                this.langRenderer = new MyRecentLanguagesRenderer();
            }
            return this.langRenderer;
        }
        return super.getCellRenderer(row, col);
    }

    private class MyRecentLanguagesRenderer
    extends RecentLanguagesBox
    implements TableCellRenderer {
        public MyRecentLanguagesRenderer() {
            super((String)null);
            this.addNoLanguageItem();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem((String)value);
            this.setEnabled(true);
            return this;
        }
    }

    private class MyRecentLanguagesEditor
    extends DefaultCellEditor {
        private RecentLanguagesBox languagebox;

        public MyRecentLanguagesEditor() {
            super(new RecentLanguagesBox(null));
            this.languagebox = (RecentLanguagesBox)super.getComponent();
            this.languagebox.addNoLanguageItem();
        }
    }

    private class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    private class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(String[] items) {
            super(items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            if (!MFETierTable.this.model.isTypeConsistentTier(row)) {
                this.setSelectedItem(ElanLocale.getString("MFE.Multiple"));
                this.setEnabled(false);
            } else {
                this.setSelectedItem(value);
                this.setEnabled(true);
            }
            return this;
        }
    }
}

