/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.UpdateTranscriptionsWithTemplateCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.MFDomainDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.search.viewer.EAFMultipleFileUtilities;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;

public class UpdateTranscriptionsWithTemplateDialog
extends ClosableDialog
implements ActionListener,
ProgressListener {
    private JButton loadDomainButton;
    private JButton selectTemplateButton;
    private JCheckBox checkOnlyCB;
    private JCheckBox replaceCVCB;
    private JButton startStopButton;
    private JButton closeButton;
    private JList fileList;
    private DefaultListModel fileListModel;
    private JTextField templatePathTF;
    private JProgressBar progressBar;
    private UpdateTranscriptionsWithTemplateCommand command;
    private File templateFile;
    private List<File> files;
    private boolean inProgress = false;

    public UpdateTranscriptionsWithTemplateDialog(Frame owner) throws HeadlessException {
        this(owner, true);
    }

    public UpdateTranscriptionsWithTemplateDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
        this.posiInit();
    }

    private void posiInit() {
        this.pack();
        if (this.getParent() != null) {
            Dimension parentSize = this.getParent().getSize();
            Dimension curSize = this.getSize();
            int w = Math.max(curSize.width, parentSize.width / 2);
            int h = Math.max(curSize.height, parentSize.height / 3 * 2);
            this.setSize(w, h);
        }
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("Menu.File.MultipleFileUpdateWithTemplate"));
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new GridBagLayout());
        optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        JPanel progressPanel = new JPanel(new GridBagLayout());
        progressPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.FindReplace.Progress")));
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1));
        Insets insets = new Insets(4, 6, 0, 6);
        Insets vertIndent = new Insets(12, 6, 0, 6);
        this.loadDomainButton = new JButton(ElanLocale.getString("MFE.DomainDefKey"));
        this.fileListModel = new DefaultListModel();
        this.fileListModel.addElement(ElanLocale.getString("MultiFileImport.Step1.NoFiles"));
        this.fileList = new JList(this.fileListModel);
        this.fileList.setEnabled(false);
        JScrollPane fileListScrollPane = new JScrollPane(this.fileList);
        fileListScrollPane.setPreferredSize(new Dimension(400, 60));
        this.selectTemplateButton = new JButton(ElanLocale.getString("UpdateMultipleTranscriptionsWithTemplate.SelectTemplate"));
        this.templatePathTF = new JTextField(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoTemplate"));
        this.templatePathTF.setEnabled(false);
        this.templatePathTF.setEditable(false);
        this.checkOnlyCB = new JCheckBox(ElanLocale.getString("UpdateMultipleTranscriptionsWithTemplate.CheckAndReport"));
        this.replaceCVCB = new JCheckBox(ElanLocale.getString("UpdateMultipleTranscriptionsWithTemplate.ReplaceCV"));
        this.startStopButton = new JButton(ElanLocale.getString("Button.Start"));
        this.startStopButton.setActionCommand("start");
        this.startStopButton.setEnabled(false);
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = insets;
        optionsPanel.add((Component)this.loadDomainButton, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        optionsPanel.add((Component)fileListScrollPane, gbc);
        gbc.gridy = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = vertIndent;
        optionsPanel.add((Component)this.selectTemplateButton, gbc);
        gbc.gridy = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        optionsPanel.add((Component)this.templatePathTF, gbc);
        gbc.gridy = 4;
        gbc.insets = vertIndent;
        optionsPanel.add((Component)this.checkOnlyCB, gbc);
        gbc.gridy = 5;
        gbc.insets = insets;
        optionsPanel.add((Component)this.replaceCVCB, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        progressPanel.add((Component)this.progressBar, gbc);
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        progressPanel.add((Component)this.startStopButton, gbc);
        buttonPanel.add(this.closeButton);
        GridBagConstraints cbc = new GridBagConstraints();
        cbc.anchor = 18;
        cbc.fill = 1;
        cbc.weightx = 1.0;
        cbc.weighty = 1.0;
        cbc.insets = insets;
        this.getContentPane().add((Component)optionsPanel, cbc);
        cbc.gridy = 1;
        cbc.fill = 2;
        cbc.weighty = 0.0;
        this.getContentPane().add((Component)progressPanel, cbc);
        cbc.gridy = 2;
        cbc.insets = new Insets(4, 6, 4, 6);
        cbc.anchor = 10;
        cbc.fill = 0;
        cbc.weightx = 0.0;
        this.getContentPane().add((Component)buttonPanel, cbc);
        this.loadDomainButton.addActionListener(this);
        this.selectTemplateButton.addActionListener(this);
        this.startStopButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.loadPreferences();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.startStopButton) {
            if ("start".equals(e.getActionCommand())) {
                if (!this.inProgress) {
                    this.start();
                }
            } else if (this.inProgress) {
                this.stop();
            }
        } else if (e.getSource() == this.loadDomainButton) {
            this.loadDomain();
            if (this.templateFile != null && this.files != null && !this.files.isEmpty()) {
                this.startStopButton.setEnabled(true);
            }
        } else if (e.getSource() == this.selectTemplateButton) {
            this.getTemplate();
            if (this.templateFile != null && this.files != null && !this.files.isEmpty()) {
                this.startStopButton.setEnabled(true);
            }
        } else if (e.getSource() == this.closeButton && !this.inProgress) {
            this.savePreferences();
            this.setVisible(false);
            this.dispose();
        }
    }

    private void start() {
        if (this.templateFile != null && this.files != null && !this.files.isEmpty()) {
            this.closeButton.setEnabled(false);
            this.startStopButton.setText(ElanLocale.getString("Button.Stop"));
            this.startStopButton.setActionCommand("stop");
            this.command = new UpdateTranscriptionsWithTemplateCommand("Menu.File.MultipleFileUpdateWithTemplate");
            this.command.setProcessReport(new SimpleReport());
            this.command.setProgressListener(this);
            this.command.execute(null, new Object[]{this.files, this.templateFile, this.checkOnlyCB.isSelected(), this.replaceCVCB.isSelected()});
            this.inProgress = true;
        }
    }

    private void stop() {
        if (this.command != null) {
            this.command.setCancelled(true);
            this.inProgress = false;
        }
    }

    private void finished() {
        this.showReport();
        this.closeButton.setEnabled(true);
        this.startStopButton.setText(ElanLocale.getString("Button.Start"));
        this.startStopButton.setActionCommand("start");
        this.progressBar.setValue(this.progressBar.getMinimum());
        this.progressBar.setString("");
        this.inProgress = false;
    }

    private void getTemplate() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectTemplate"), 0, FileExtension.TEMPLATE_EXT, "TemplateDir");
        File selFile = chooser.getSelectedFile();
        if (selFile != null && selFile.exists()) {
            this.templateFile = selFile;
            String path = selFile.getAbsolutePath();
            try {
                String name = path.substring(path.lastIndexOf(File.separatorChar) + 1);
                this.templatePathTF.setText(String.format("%s  [%s]", name, path.substring(0, path.lastIndexOf(File.separatorChar))));
            }
            catch (Throwable t) {
                this.templatePathTF.setText(path);
            }
            this.templatePathTF.setEnabled(true);
        }
    }

    private void loadDomain() {
        MFDomainDialog mfDialog = new MFDomainDialog(this, ElanLocale.getString("MultipleFileSearch.SearchDomain"), true);
        mfDialog.setVisible(true);
        List<String> searchDirs = mfDialog.getSearchDirs();
        List<String> searchPaths = mfDialog.getSearchPaths();
        File[] uniqueFiles = EAFMultipleFileUtilities.getUniqueEAFFilesIn(searchDirs, searchPaths);
        if (this.files != null) {
            this.files.clear();
        } else {
            this.files = new ArrayList<File>();
        }
        this.fileListModel.clear();
        for (File f : uniqueFiles) {
            this.files.add(f);
            this.fileListModel.addElement(String.format("<html><b>%s</b> - %s</html>", f.getName(), f.getAbsolutePath()));
        }
    }

    private void showReport() {
        SimpleReport report;
        if (this.command != null && (report = (SimpleReport)this.command.getProcessReport()) != null) {
            new ReportDialog((Dialog)this, (ProcessReport)report).setVisible(true);
        }
    }

    private void loadPreferences() {
        Boolean replaceCVFlag;
        Boolean dryRunFlag;
        String tempPath = Preferences.getString("UpdateTranscriptionsWithTemplate.TemplatePath", null);
        if (tempPath != null && !tempPath.isEmpty()) {
            this.templateFile = new File(tempPath);
            if (this.templateFile.exists()) {
                try {
                    String name = tempPath.substring(tempPath.lastIndexOf(File.separatorChar) + 1);
                    this.templatePathTF.setText(String.format("%s  [%s]", name, tempPath.substring(0, tempPath.lastIndexOf(File.separatorChar))));
                }
                catch (Throwable t) {
                    this.templatePathTF.setText(tempPath);
                }
                this.templatePathTF.setEnabled(true);
            }
        }
        if ((dryRunFlag = Preferences.getBool("UpdateTranscriptionsWithTemplate.DryRun", null)) != null) {
            this.checkOnlyCB.setSelected(dryRunFlag);
        }
        if ((replaceCVFlag = Preferences.getBool("UpdateTranscriptionsWithTemplate.ForceReplaceCVs", null)) != null) {
            this.replaceCVCB.setSelected(replaceCVFlag);
        }
    }

    private void savePreferences() {
        if (this.templateFile != null) {
            String tp = this.templateFile.getAbsolutePath();
            Preferences.set("UpdateTranscriptionsWithTemplate.TemplatePath", tp, null, false, false);
        }
        Preferences.set("UpdateTranscriptionsWithTemplate.DryRun", this.checkOnlyCB.isSelected(), null, false, false);
        Preferences.set("UpdateTranscriptionsWithTemplate.ForceReplaceCVs", this.replaceCVCB.isSelected(), null, false, false);
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        this.progressBar.setValue(percent);
        this.progressBar.setString(message);
    }

    @Override
    public void progressCompleted(Object source, String message) {
        this.progressBar.setValue(this.progressBar.getMaximum());
        this.progressBar.setString(message);
        this.finished();
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        this.progressBar.setString(message);
        this.finished();
    }
}

