/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.create;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.CreateTranscriptionsCommand;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;

public class CreateTranscriptionsDialog
extends ClosableDialog
implements ActionListener,
ChangeListener {
    private JButton sourceButton;
    private JButton templateButton;
    private JRadioButton sameFolderRB;
    private JRadioButton otherFolderRB;
    private JButton destFolderButton;
    private JCheckBox combineVideoCB;
    private JRadioButton suffixRB;
    private JRadioButton prefixRB;
    private JButton startButton;
    private JButton closeButton;
    private JTextField sourceTF;
    private JTextField templateTF;
    private JTextField destFolderTF;
    private JCheckBox recursiveCB;
    private JCheckBox templateCB;
    private JCheckBox separatorCB;
    private JTextField separatorTF;
    private Command command;

    public CreateTranscriptionsDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.initComponents();
    }

    public CreateTranscriptionsDialog(Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setSize(this.getWidth() + 60, this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("Menu.File.MultiEAFCreationToolTip"));
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        Insets insets = new Insets(4, 6, 0, 6);
        Insets indent = new Insets(4, 26, 0, 6);
        JLabel sourceLabel = new JLabel(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectSourceFolder"));
        this.sourceTF = new JTextField();
        this.sourceTF.setEnabled(false);
        this.sourceButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.recursiveCB = new JCheckBox(ElanLocale.getString("CreateMultiEAFDialog.Button.Recursive"));
        this.templateCB = new JCheckBox(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectTemplate"));
        this.templateCB.setSelected(true);
        this.templateTF = new JTextField();
        this.templateTF.setEnabled(false);
        this.templateButton = new JButton(ElanLocale.getString("Button.Browse"));
        JLabel transLocationLabel = new JLabel(ElanLocale.getString("CreateMultiEAFDialog.Label.EAFLocation"));
        this.sameFolderRB = new JRadioButton(ElanLocale.getString("CreateMultiEAFDialog.Button.SameFolder"));
        this.sameFolderRB.setSelected(true);
        this.otherFolderRB = new JRadioButton(ElanLocale.getString("CreateMultiEAFDialog.Button.OtherFolder"));
        ButtonGroup fGroup = new ButtonGroup();
        fGroup.add(this.sameFolderRB);
        fGroup.add(this.otherFolderRB);
        this.destFolderButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.destFolderButton.setEnabled(false);
        this.destFolderTF = new JTextField();
        this.destFolderTF.setEnabled(false);
        this.combineVideoCB = new JCheckBox(ElanLocale.getString("CreateMultiEAFDialog.Button.CombineVideos"));
        this.suffixRB = new JRadioButton(ElanLocale.getString("CreateMultiEAFDialog.Label.Suffix"));
        this.suffixRB.setSelected(true);
        this.suffixRB.setEnabled(false);
        this.prefixRB = new JRadioButton(ElanLocale.getString("CreateMultiEAFDialog.Label.Prefix"));
        this.prefixRB.setEnabled(false);
        ButtonGroup combGroup = new ButtonGroup();
        combGroup.add(this.suffixRB);
        combGroup.add(this.prefixRB);
        this.separatorCB = new JCheckBox(ElanLocale.getString("CreateMultiEAFDialog.Button.Separator"));
        this.separatorCB.setEnabled(false);
        this.separatorTF = new JTextField(4);
        this.separatorTF.setEnabled(false);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        this.startButton = new JButton(ElanLocale.getString("Button.Start"));
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        buttonPanel.add(this.startButton);
        buttonPanel.add(this.closeButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        pane.add((Component)sourceLabel, gbc);
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        pane.add((Component)this.sourceTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        pane.add((Component)this.sourceButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 26, 6, 6);
        pane.add((Component)this.recursiveCB, gbc);
        gbc.insets = insets;
        gbc.gridy = 3;
        pane.add((Component)this.templateCB, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 6, 6, 6);
        pane.add((Component)this.templateTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        pane.add((Component)this.templateButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pane.add((Component)transLocationLabel, gbc);
        gbc.gridy = 6;
        gbc.insets = indent;
        pane.add((Component)this.sameFolderRB, gbc);
        gbc.gridy = 7;
        pane.add((Component)this.otherFolderRB, gbc);
        gbc.gridy = 8;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(4, 26, 6, 6);
        pane.add((Component)this.destFolderTF, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(4, 6, 6, 6);
        pane.add((Component)this.destFolderButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 9;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        pane.add((Component)this.combineVideoCB, gbc);
        gbc.gridy = 10;
        gbc.insets = indent;
        pane.add((Component)this.suffixRB, gbc);
        gbc.gridy = 11;
        pane.add((Component)this.prefixRB, gbc);
        gbc.gridy = 12;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        pane.add((Component)this.separatorCB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 17;
        pane.add((Component)this.separatorTF, gbc);
        gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)pane, gbc);
        gbc.gridy = 1;
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.loadPreferences();
        this.sourceButton.addActionListener(this);
        this.templateButton.addActionListener(this);
        this.destFolderButton.addActionListener(this);
        this.startButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.combineVideoCB.addChangeListener(this);
        this.sameFolderRB.addChangeListener(this);
        this.otherFolderRB.addChangeListener(this);
        this.templateCB.addChangeListener(this);
        this.separatorCB.addChangeListener(this);
    }

    private void loadPreferences() {
        Boolean boolPref;
        String stringPref = Preferences.getString("CreateMultipleEAF.SourcePath", null);
        if (stringPref != null) {
            this.sourceTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.Recursive", null)) != null) {
            this.recursiveCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.UseTemplate", null)) != null) {
            this.templateCB.setSelected(boolPref);
            this.templateButton.setEnabled(this.templateCB.isSelected());
        }
        if ((stringPref = Preferences.getString("CreateMultipleEAF.TemplatePath", null)) != null) {
            this.templateTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.OtherDestination", null)) != null) {
            this.otherFolderRB.setSelected(boolPref);
            this.destFolderButton.setEnabled(this.otherFolderRB.isSelected());
        }
        if ((stringPref = Preferences.getString("CreateMultipleEAF.DestinationPath", null)) != null) {
            this.destFolderTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.CombineVideos", null)) != null) {
            this.combineVideoCB.setSelected(boolPref);
            this.suffixRB.setEnabled(this.combineVideoCB.isSelected());
            this.prefixRB.setEnabled(this.combineVideoCB.isSelected());
            this.separatorCB.setEnabled(this.combineVideoCB.isSelected());
            this.separatorTF.setEnabled(this.separatorCB.isEnabled() && this.separatorCB.isSelected());
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.PrefixBased", null)) != null) {
            if (boolPref.booleanValue()) {
                this.prefixRB.setSelected(true);
            } else {
                this.suffixRB.setSelected(true);
            }
        }
        if ((boolPref = Preferences.getBool("CreateMultipleEAF.AffixSeparatorSpecified", null)) != null) {
            this.separatorCB.setSelected(boolPref);
            this.separatorTF.setEnabled(this.separatorCB.isEnabled() && this.separatorCB.isSelected());
        }
        if ((stringPref = Preferences.getString("CreateMultipleEAF.AffixSeparator", null)) != null) {
            this.separatorTF.setText(stringPref);
        }
    }

    private void savePreferences() {
        String sourcePath = this.sourceTF.getText();
        if (sourcePath != null && sourcePath.length() > 0) {
            Preferences.set("CreateMultipleEAF.SourcePath", sourcePath, null, false, false);
        }
        Preferences.set("CreateMultipleEAF.Recursive", this.recursiveCB.isSelected(), null, false, false);
        boolean useTemplate = this.templateCB.isSelected();
        Preferences.set("CreateMultipleEAF.UseTemplate", useTemplate, null, false, false);
        String tempPath = this.templateTF.getText();
        if (tempPath != null && tempPath.length() > 0) {
            Preferences.set("CreateMultipleEAF.TemplatePath", tempPath, null, false, false);
        }
        boolean otherDest = this.otherFolderRB.isSelected();
        Preferences.set("CreateMultipleEAF.OtherDestination", otherDest, null, false, false);
        String destPath = this.destFolderTF.getText();
        if (destPath != null && destPath.length() > 0) {
            Preferences.set("CreateMultipleEAF.DestinationPath", destPath, null, false, false);
        }
        boolean combine = this.combineVideoCB.isSelected();
        Preferences.set("CreateMultipleEAF.CombineVideos", combine, null, false, false);
        Preferences.set("CreateMultipleEAF.PrefixBased", this.prefixRB.isSelected(), null, false, false);
        String sep = this.separatorTF.getText();
        if (sep != null && sep.length() > 0) {
            Preferences.set("CreateMultipleEAF.AffixSeparator", sep, null, false, false);
        }
        Preferences.set("CreateMultipleEAF.AffixSeparatorSpecified", this.separatorCB.isSelected(), null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sourceButton) {
            this.getSourceFolder();
        } else if (e.getSource() == this.templateButton) {
            this.getTemplate();
        } else if (e.getSource() == this.destFolderButton) {
            this.getDestinationFolder();
        } else if (e.getSource() == this.startButton) {
            if (this.create()) {
                this.savePreferences();
                if (this.command instanceof ProcessReporter) {
                    ProcessReport report = ((ProcessReporter)((Object)this.command)).getProcessReport();
                    if (report != null) {
                        ReportDialog rd = new ReportDialog((Dialog)this, report);
                        rd.setVisible(true);
                    }
                } else {
                    this.setVisible(false);
                    this.dispose();
                }
            }
        } else if (e.getSource() == this.closeButton) {
            this.savePreferences();
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.combineVideoCB) {
            boolean enable = this.combineVideoCB.isSelected();
            this.suffixRB.setEnabled(enable);
            this.prefixRB.setEnabled(enable);
            this.separatorCB.setEnabled(enable);
            this.separatorTF.setEnabled(enable && this.separatorCB.isSelected());
        } else if (e.getSource() == this.sameFolderRB) {
            this.destFolderButton.setEnabled(false);
        } else if (e.getSource() == this.otherFolderRB) {
            this.destFolderButton.setEnabled(true);
        } else if (e.getSource() == this.templateCB) {
            this.templateButton.setEnabled(this.templateCB.isSelected());
        } else if (e.getSource() == this.separatorCB) {
            this.separatorTF.setEnabled(this.separatorCB.isSelected());
        }
    }

    private void getSourceFolder() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectSourceFolder"), 0, ElanLocale.getString("Button.Select"), null, null, true, "MediaDir", 1, null);
        File selDir = chooser.getSelectedFile();
        if (selDir != null) {
            this.sourceTF.setText(selDir.getAbsolutePath());
        }
    }

    private void getTemplate() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.SelectTemplate"), 0, FileExtension.TEMPLATE_EXT, "TemplateDir");
        File selFile = chooser.getSelectedFile();
        if (selFile != null) {
            this.templateTF.setText(selFile.getAbsolutePath());
        }
    }

    private void getDestinationFolder() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("CreateMultiEAFDialog.Label.EAFLocation"), 0, ElanLocale.getString("Button.Select"), null, null, true, "LastUsedEAFDir", 1, null);
        File selDir = chooser.getSelectedFile();
        if (selDir != null) {
            this.destFolderTF.setText(selDir.getAbsolutePath());
        }
    }

    private boolean create() {
        String templateFile;
        String sourceFol;
        block18: {
            sourceFol = this.sourceTF.getText();
            if (sourceFol == null || sourceFol.length() == 0) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoSource"));
                this.sourceButton.requestFocus();
                return false;
            }
            File f = new File(sourceFol);
            try {
                if (!f.exists() || !f.isDirectory()) {
                    this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NonExistSource"));
                    this.sourceButton.requestFocus();
                    return false;
                }
            }
            catch (SecurityException ex) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoAccessSource"));
                return false;
            }
            templateFile = this.templateTF.getText();
            if (this.templateCB.isSelected()) {
                if (templateFile == null || templateFile.length() == 0) {
                    this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoTemplate"));
                    this.templateButton.requestFocus();
                    return false;
                }
                File f2 = new File(templateFile);
                try {
                    if (!f2.exists() || f2.isDirectory()) {
                        this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NonExistTemplate"));
                        this.templateButton.requestFocus();
                        return false;
                    }
                    break block18;
                }
                catch (SecurityException ex) {
                    this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoAccessTemplate"));
                    return false;
                }
            }
            templateFile = null;
        }
        String destFol = null;
        if (this.otherFolderRB.isSelected()) {
            destFol = this.destFolderTF.getText();
            if (destFol == null || destFol.length() == 0) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoDestination"));
                this.destFolderButton.requestFocus();
                return false;
            }
            File f = new File(destFol);
            try {
                if (!f.exists() || !f.isDirectory()) {
                    this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NonExistDestination"));
                    this.destFolderButton.requestFocus();
                    return false;
                }
            }
            catch (SecurityException se) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoAccessDestination"));
                return false;
            }
        }
        String separator = this.separatorTF.getText();
        if (this.combineVideoCB.isSelected() && this.separatorCB.isSelected()) {
            if (separator == null || separator.length() == 0) {
                this.showWarning(ElanLocale.getString("CreateMultiEAFDialog.Warning.NoSeparator"));
                this.separatorTF.requestFocus();
                return false;
            }
        } else {
            separator = null;
        }
        boolean recursive = this.recursiveCB.isSelected();
        boolean combineVideos = this.combineVideoCB.isSelected();
        boolean prefixBased = this.prefixRB.isSelected();
        this.command = new CreateTranscriptionsCommand("Menu.File.MultiEAFCreation");
        if (this.command instanceof ProcessReporter) {
            ((ProcessReporter)((Object)this.command)).setProcessReport(new SimpleReport(ElanLocale.getString("Menu.File.MultiEAFCreationToolTip")));
        }
        this.command.execute(null, new Object[]{sourceFol, templateFile, destFol, recursive, combineVideos, prefixBased, separator});
        return true;
    }

    private void showWarning(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }
}

