/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.statistics;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.StatisticsAnnotationsMF;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.TierAttributeBasedStats;
import mpi.eudico.client.annotator.multiplefilesedit.statistics.TierStats;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class StatisticsCollectionMF {
    public static final String UNSPECIFIED = "unspecified";
    public static final int NUM_TIER_COL = 9;
    public static final int NUM_TYPE_COL = 10;
    public static final int NUM_PART_COL = 10;
    private DecimalFormat format2 = new DecimalFormat("#0.0##", new DecimalFormatSymbols(Locale.US));
    private List<TierStats> tierStatsMF = new ArrayList<TierStats>();
    private List<TierAttributeBasedStats> typeStatsMF = new ArrayList<TierAttributeBasedStats>();
    private List<TierAttributeBasedStats> partStatsMF = new ArrayList<TierAttributeBasedStats>();
    private List<TierAttributeBasedStats> annotatorStatsMF = new ArrayList<TierAttributeBasedStats>();
    private List<TierAttributeBasedStats> languageStatsMF = new ArrayList<TierAttributeBasedStats>();
    private Map<String, StatisticsAnnotationsMF> annotationsStatsMF = new TreeMap<String, StatisticsAnnotationsMF>();

    public void addTier(String file, TierImpl tier, int numAnnotations, long minDur, long maxDur, long totalDur, long latency, List<Long> curDurations) {
        if (tier == null) {
            return;
        }
        boolean tierFound = false;
        for (TierStats ts : this.tierStatsMF) {
            if (!ts.getTierName().equals(tier.getName())) continue;
            tierFound = true;
            ++ts.numFiles;
            ts.numAnnotations += numAnnotations;
            ts.durations.addAll(curDurations);
            ts.totalDur += totalDur;
            if (minDur < ts.minDur) {
                ts.minDur = minDur;
            }
            if (maxDur > ts.maxDur) {
                ts.maxDur = maxDur;
            }
            if (latency >= ts.latency) break;
            ts.latency = latency;
            break;
        }
        if (!tierFound) {
            TierStats ts = new TierStats(tier.getName());
            ts.numFiles = 1;
            ts.numAnnotations = numAnnotations;
            ts.durations.addAll(curDurations);
            ts.minDur = minDur;
            ts.maxDur = maxDur;
            ts.totalDur = totalDur;
            ts.latency = latency;
            this.tierStatsMF.add(ts);
        }
        boolean typeFound = false;
        String typeName = tier.getLinguisticType().getLinguisticTypeName();
        for (TierAttributeBasedStats tys : this.typeStatsMF) {
            if (!tys.getAttributeValue().equals(typeName)) continue;
            typeFound = true;
            ++tys.numTiers;
            tys.addFileName(file);
            tys.addTierName(tier.getName());
            tys.numAnnotations += numAnnotations;
            tys.durations.addAll(curDurations);
            tys.totalDur += totalDur;
            if (minDur < tys.minDur) {
                tys.minDur = minDur;
            }
            if (maxDur > tys.maxDur) {
                tys.maxDur = maxDur;
            }
            if (latency >= tys.latency) break;
            tys.latency = latency;
            break;
        }
        if (!typeFound) {
            TierAttributeBasedStats tys = new TierAttributeBasedStats(typeName);
            tys.numTiers = 1;
            tys.addFileName(file);
            tys.addTierName(tier.getName());
            tys.numAnnotations = numAnnotations;
            tys.durations.addAll(curDurations);
            tys.minDur = minDur;
            tys.maxDur = maxDur;
            tys.totalDur = totalDur;
            tys.latency = latency;
            this.typeStatsMF.add(tys);
        }
        boolean partFound = false;
        String partName = tier.getParticipant();
        if (partName == null || partName.length() == 0) {
            partName = UNSPECIFIED;
        }
        for (TierAttributeBasedStats ps : this.partStatsMF) {
            if (!ps.getAttributeValue().equals(partName)) continue;
            partFound = true;
            ++ps.numTiers;
            ps.addFileName(file);
            ps.addTierName(tier.getName());
            ps.numAnnotations += numAnnotations;
            ps.durations.addAll(curDurations);
            ps.totalDur += totalDur;
            if (minDur < ps.minDur) {
                ps.minDur = minDur;
            }
            if (maxDur > ps.maxDur) {
                ps.maxDur = maxDur;
            }
            if (latency >= ps.latency) break;
            ps.latency = latency;
            break;
        }
        if (!partFound) {
            TierAttributeBasedStats ps = new TierAttributeBasedStats(partName);
            ps.numTiers = 1;
            ps.addFileName(file);
            ps.addTierName(tier.getName());
            ps.numAnnotations = numAnnotations;
            ps.durations.addAll(curDurations);
            ps.minDur = minDur;
            ps.maxDur = maxDur;
            ps.totalDur = totalDur;
            ps.latency = latency;
            this.partStatsMF.add(ps);
        }
        boolean annotFound = false;
        String annotName = tier.getAnnotator();
        if (annotName == null || annotName.length() == 0) {
            annotName = UNSPECIFIED;
        }
        for (TierAttributeBasedStats as : this.annotatorStatsMF) {
            if (!as.getAttributeValue().equals(annotName)) continue;
            annotFound = true;
            ++as.numTiers;
            as.addFileName(file);
            as.addTierName(tier.getName());
            as.numAnnotations += numAnnotations;
            as.durations.addAll(curDurations);
            as.totalDur += totalDur;
            if (minDur < as.minDur) {
                as.minDur = minDur;
            }
            if (maxDur > as.maxDur) {
                as.maxDur = maxDur;
            }
            if (latency >= as.latency) break;
            as.latency = latency;
            break;
        }
        if (!annotFound) {
            TierAttributeBasedStats as = new TierAttributeBasedStats(annotName);
            as.numTiers = 1;
            as.addFileName(file);
            as.addTierName(tier.getName());
            as.numAnnotations = numAnnotations;
            as.durations.addAll(curDurations);
            as.minDur = minDur;
            as.maxDur = maxDur;
            as.totalDur = totalDur;
            as.latency = latency;
            this.annotatorStatsMF.add(as);
        }
        boolean langFound = false;
        String langName = tier.getLangRef();
        if (langName == null || langName.length() == 0) {
            langName = UNSPECIFIED;
        }
        for (TierAttributeBasedStats tas : this.languageStatsMF) {
            if (!tas.getAttributeValue().equals(langName)) continue;
            langFound = true;
            ++tas.numTiers;
            tas.addFileName(file);
            tas.addTierName(tier.getName());
            tas.numAnnotations += numAnnotations;
            tas.durations.addAll(curDurations);
            tas.totalDur += totalDur;
            if (minDur < tas.minDur) {
                tas.minDur = minDur;
            }
            if (maxDur > tas.maxDur) {
                tas.maxDur = maxDur;
            }
            if (latency >= tas.latency) break;
            tas.latency = latency;
            break;
        }
        if (!langFound) {
            TierAttributeBasedStats tas = new TierAttributeBasedStats(langName);
            tas.numTiers = 1;
            tas.addFileName(file);
            tas.addTierName(tier.getName());
            tas.numAnnotations = numAnnotations;
            tas.durations.addAll(curDurations);
            tas.minDur = minDur;
            tas.maxDur = maxDur;
            tas.totalDur = totalDur;
            tas.latency = latency;
            this.languageStatsMF.add(tas);
        }
    }

    public void addEmptyLinguisticType(String file, String typeName) {
        if (typeName == null) {
            return;
        }
        boolean typeFound = false;
        for (TierAttributeBasedStats tys : this.typeStatsMF) {
            if (!tys.getAttributeValue().equals(typeName)) continue;
            typeFound = true;
            tys.addFileName(file);
            break;
        }
        if (!typeFound) {
            TierAttributeBasedStats tys = new TierAttributeBasedStats(typeName);
            tys.numTiers = 0;
            tys.addFileName(file);
            tys.numAnnotations = 0;
            tys.minDur = 0L;
            tys.maxDur = 0L;
            tys.totalDur = 0L;
            tys.latency = 0L;
            this.typeStatsMF.add(tys);
        }
    }

    public void addAnnotations(String file, String tierName, StatisticsAnnotationsMF annotationStatistics) {
        if (!this.annotationsStatsMF.containsKey(tierName)) {
            this.annotationsStatsMF.put(tierName, annotationStatistics);
        }
    }

    public StatisticsAnnotationsMF getAnnotationStats(String tierName) {
        return this.annotationsStatsMF.get(tierName);
    }

    public List<String[]> getAllAnnotationStatistics() {
        if (this.annotationsStatsMF.size() == 0) {
            String[] row = new String[9];
            for (int i = 0; i < row.length; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> ansList = new ArrayList<String[]>(1);
            ansList.add(row);
            return ansList;
        }
        ArrayList<String[]> annsList = new ArrayList<String[]>();
        Iterator<String> keyIt = this.annotationsStatsMF.keySet().iterator();
        while (keyIt.hasNext()) {
            StatisticsAnnotationsMF stats = this.annotationsStatsMF.get(keyIt.next());
            annsList.addAll(stats.getAnnotationStastitics());
        }
        return annsList;
    }

    public List<String[]> getTierStatistics() {
        if (this.tierStatsMF.size() == 0) {
            String[] row = new String[9];
            for (int i = 0; i < 9; ++i) {
                row[i] = "-";
            }
            ArrayList<String[]> tsList = new ArrayList<String[]>(1);
            tsList.add(row);
            return tsList;
        }
        ArrayList<String[]> tierList = new ArrayList<String[]>(this.tierStatsMF.size());
        float mill = 1000.0f;
        for (TierStats stats : this.tierStatsMF) {
            String[] row = new String[9];
            block13: for (int i = 0; i < 9; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getTierName();
                        continue block13;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.numFiles);
                        continue block13;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block13;
                    }
                    case 3: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block13;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block13;
                    }
                    case 4: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block13;
                    }
                    case 5: {
                        if (stats.numAnnotations == 0) {
                            row[i] = this.format2.format(0L);
                            continue block13;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block13;
                    }
                    case 6: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 0) {
                            median = 0.0f;
                        } else if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block13;
                    }
                    case 7: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block13;
                    }
                    case 8: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block13;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block13;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            tierList.add(row);
        }
        return tierList;
    }

    public List<String[]> getTypeStatistics() {
        return this.getTierAttributeBasedStatistics(this.typeStatsMF);
    }

    public List<String[]> getPartStatistics() {
        return this.getTierAttributeBasedStatistics(this.partStatsMF);
    }

    public List<String[]> getAnnotatorStatistics() {
        return this.getTierAttributeBasedStatistics(this.annotatorStatsMF);
    }

    public List<String[]> getLanguageStatistics() {
        return this.getTierAttributeBasedStatistics(this.languageStatsMF);
    }

    private List<String[]> getTierAttributeBasedStatistics(List<TierAttributeBasedStats> attribStatsMF) {
        if (attribStatsMF == null || attribStatsMF.size() == 0) {
            ArrayList<String[]> attribList = new ArrayList<String[]>(1);
            String[] row = new String[10];
            for (int i = 0; i < 10; ++i) {
                row[i] = "-";
            }
            attribList.add(row);
            return attribList;
        }
        ArrayList<String[]> attribList = new ArrayList<String[]>(attribStatsMF.size());
        float mill = 1000.0f;
        for (TierAttributeBasedStats stats : attribStatsMF) {
            String[] row = new String[10];
            block14: for (int i = 0; i < 10; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = stats.getAttributeValue();
                        continue block14;
                    }
                    case 1: {
                        row[i] = String.valueOf(stats.getNumFiles());
                        continue block14;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numTiers);
                        continue block14;
                    }
                    case 3: {
                        row[i] = String.valueOf(stats.numAnnotations);
                        continue block14;
                    }
                    case 4: {
                        if (stats.minDur == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block14;
                    }
                    case 5: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block14;
                    }
                    case 6: {
                        if (stats.numAnnotations == 0) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        float avg = (float)stats.totalDur / (float)stats.numAnnotations;
                        row[i] = this.format2.format(avg / mill);
                        continue block14;
                    }
                    case 7: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 0) {
                            median = 0.0f;
                        } else if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block14;
                    }
                    case 8: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block14;
                    }
                    case 9: {
                        if (stats.latency == Long.MAX_VALUE) {
                            row[i] = this.format2.format(0L);
                            continue block14;
                        }
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block14;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            attribList.add(row);
        }
        return attribList;
    }
}

