/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.ngramstats;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.ngramstats.Ngram;
import mpi.eudico.client.annotator.ngramstats.NgramAnnotation;
import mpi.eudico.client.annotator.ngramstats.NgramCollection;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

public class NgramStatsResult {
    private final String domain;
    private final String tier;
    private final int ngramSize;
    private int numFiles = 0;
    private int numAnnotations = 0;
    private List<NgramAnnotation> currentAnnotations = new ArrayList<NgramAnnotation>();
    private String curFile;
    private int ngramPos;
    private long startTime = System.currentTimeMillis();
    private long endTime;
    private final List<Ngram> seen_ngrams = new ArrayList<Ngram>();
    private final List<NgramCollection> ngrams = new ArrayList<NgramCollection>();
    private final DecimalFormat timeFormat = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));

    public NgramStatsResult(String dom, String selected_tier, int size) {
        this.domain = dom;
        this.tier = selected_tier;
        this.ngramSize = size;
    }

    public int getNgramSize() {
        return this.ngramSize;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getTier() {
        return this.tier;
    }

    public String getSearchTime() {
        return this.timeFormat.format((float)(this.endTime - this.startTime) / 1000.0f);
    }

    public NgramCollection getCollectedNgramAt(int row) {
        return this.ngrams.get(row);
    }

    public Ngram getNgramAt(int row) {
        return this.seen_ngrams.get(row);
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public int getNumAnnotations() {
        return this.numAnnotations;
    }

    public int getNumCollectedNgrams() {
        return this.ngrams.size();
    }

    public int getNumNgrams() {
        return this.seen_ngrams.size();
    }

    public void addAnnotation(AbstractAnnotation aa) throws Exception {
        if (this.curFile == null) {
            throw new Exception("Call startFile(path) first");
        }
        this.currentAnnotations.add(new NgramAnnotation(aa));
        ++this.numAnnotations;
    }

    public void startFile(String path) throws Exception {
        if (this.curFile != null) {
            throw new Exception("Call endFile() first");
        }
        this.curFile = path;
        ++this.numFiles;
        this.ngramPos = 1;
    }

    public void endFile() throws Exception {
        if (this.curFile == null) {
            throw new Exception("Call startFile(path) first");
        }
        if (this.currentAnnotations.size() >= this.ngramSize) {
            long tempTimeStamp = 0L;
            for (NgramAnnotation ann : this.currentAnnotations) {
                if (ann.beginTime < tempTimeStamp) {
                    ann.beginTime = tempTimeStamp;
                }
                tempTimeStamp = ann.endTime;
            }
            for (int i = 0; i < this.currentAnnotations.size(); ++i) {
                NgramAnnotation ann;
                ann = this.currentAnnotations.get(i);
                if (i != 0) {
                    ann.hasBeforeInterval = true;
                    ann.beforeInterval = ann.beginTime - this.currentAnnotations.get((int)(i - 1)).endTime;
                }
                if (i == this.currentAnnotations.size() - 1) continue;
                ann.hasAfterInterval = true;
                ann.afterInterval = this.currentAnnotations.get((int)(i + 1)).beginTime - ann.endTime;
            }
            for (int i = 0; i < this.currentAnnotations.size() && this.currentAnnotations.size() - i >= this.ngramSize; ++i) {
                Ngram newNgram = new Ngram(this.curFile, this.ngramSize);
                for (int j = i; j < this.currentAnnotations.size() && j - i < this.ngramSize; ++j) {
                    newNgram.annotations.add(this.currentAnnotations.get(j));
                }
                ++this.ngramPos;
                newNgram.position = newNgram.position;
                newNgram.calculateStatistics();
                this.seen_ngrams.add(newNgram);
            }
        }
        this.currentAnnotations.clear();
        this.curFile = null;
    }

    public void calculateStatistics() throws Exception {
        for (Ngram n : this.seen_ngrams) {
            String searchName = n.annotationsAsString();
            boolean found = false;
            for (NgramCollection nc : this.ngrams) {
                if (!nc.getName().equals(searchName)) continue;
                nc.ngrams.add(n);
                found = true;
                break;
            }
            if (found) continue;
            NgramCollection nc = new NgramCollection(this.ngramSize);
            nc.ngrams.add(n);
            this.ngrams.add(nc);
        }
        for (NgramCollection nc : this.ngrams) {
            nc.calculateStatistics(this);
        }
        Collections.sort(this.ngrams, new Comparator<NgramCollection>(){

            @Override
            public int compare(NgramCollection o1, NgramCollection o2) {
                if (o1.getOccurrences() > o2.getOccurrences()) {
                    return -1;
                }
                if (o1.getOccurrences() < o2.getOccurrences()) {
                    return 1;
                }
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        this.endTime = System.currentTimeMillis();
    }

    protected List<Ngram> findNgramsWithAnnotation(String search) {
        ArrayList<Ngram> rv = new ArrayList<Ngram>();
        block0: for (NgramCollection nc : this.ngrams) {
            for (NgramAnnotation ann : nc.ngrams.get((int)0).annotations) {
                if (!ann.value.equals(search)) continue;
                for (Ngram n : nc.ngrams) {
                    rv.add(n);
                }
                continue block0;
            }
        }
        return rv;
    }
}

