/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;

public class EmptyMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener {
    private long mediaTime;
    private long offset;
    private float rate;
    private float volume;
    private float curSubVolume;
    private boolean mute;
    private boolean playing;
    private double milliSecondsPerSample;
    private long duration;
    private long startTimeMillis;
    private boolean playingInterval;
    private PeriodicUpdateController periodicController;
    private long intervalStopTime;
    private boolean frameStepsToFrameBegin = false;
    private final long MIN_DURATION = 300000L;

    public EmptyMediaPlayer(long duration) {
        this.duration = Math.max(300000L, duration);
        this.offset = 0L;
        this.volume = 1.0f;
        this.rate = 1.0f;
        this.milliSecondsPerSample = 40.0;
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return null;
    }

    @Override
    public String getFrameworkDescription() {
        return "Empty Media Player";
    }

    @Override
    public synchronized void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent && this.periodicController != null && this.getMediaTime() >= this.intervalStopTime) {
            this.stop();
        }
    }

    @Override
    public synchronized void playInterval(long startTime, long stopTime) {
        if (this.playingInterval || stopTime <= startTime) {
            return;
        }
        this.periodicController = new PeriodicUpdateController(25L);
        this.periodicController.addControllerListener(this);
        this.addController(this.periodicController);
        this.intervalStopTime = stopTime;
        this.setMediaTime(startTime);
        this.playingInterval = true;
        this.start();
    }

    @Override
    public void setStopTime(long stopTime) {
    }

    private void stopPlayingInterval() {
        if (this.periodicController != null) {
            this.periodicController.removeControllerListener(this);
            this.removeController(this.periodicController);
            this.periodicController = null;
        }
        this.playingInterval = false;
    }

    @Override
    public Component getVisualComponent() {
        return null;
    }

    @Override
    public int getSourceHeight() {
        return 0;
    }

    @Override
    public int getSourceWidth() {
        return 0;
    }

    @Override
    public float getAspectRatio() {
        return 1.0f;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
    }

    @Override
    public synchronized void start() {
        this.playing = true;
        this.startTimeMillis = System.currentTimeMillis();
        this.startControllers();
    }

    @Override
    public synchronized void stop() {
        if (this.playing) {
            if (this.rate == 1.0f) {
                this.mediaTime += System.currentTimeMillis() - this.startTimeMillis;
            } else {
                float advance = (float)(System.currentTimeMillis() - this.startTimeMillis) * this.rate;
                this.mediaTime += (long)advance;
            }
        }
        this.playing = false;
        this.stopControllers();
        if (this.playingInterval) {
            this.stopPlayingInterval();
        }
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public double getMilliSecondsPerSample() {
        return this.milliSecondsPerSample;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        this.milliSecondsPerSample = milliSeconds;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getMediaTime() {
        if (this.playing) {
            if (this.rate == 1.0f) {
                return this.mediaTime + System.currentTimeMillis() - this.startTimeMillis;
            }
            float advance = (float)(System.currentTimeMillis() - this.startTimeMillis) * this.rate;
            return this.mediaTime + (long)advance;
        }
        return this.mediaTime - this.offset;
    }

    @Override
    public void setMediaTime(long time) {
        this.mediaTime = time + this.offset;
        this.setControllersMediaTime(time);
    }

    @Override
    public void nextFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = (long)((double)this.getMediaTime() / this.milliSecondsPerSample);
            this.setMediaTime((long)Math.ceil((double)(curFrame + 1L) * this.milliSecondsPerSample));
        } else {
            this.setMediaTime((long)Math.ceil((double)this.getMediaTime() + this.milliSecondsPerSample));
        }
    }

    @Override
    public void previousFrame() {
        if (this.frameStepsToFrameBegin) {
            long curFrame = (long)((double)this.getMediaTime() / this.milliSecondsPerSample);
            if (curFrame > 0L) {
                this.setMediaTime((long)Math.ceil((double)(curFrame - 1L) * this.milliSecondsPerSample));
            } else {
                this.setMediaTime(0L);
            }
        } else {
            this.setMediaTime((long)Math.ceil((double)this.getMediaTime() - this.milliSecondsPerSample));
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public float getRate() {
        return this.rate;
    }

    @Override
    public synchronized void setRate(float rate) {
        this.rate = rate;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return false;
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float level) {
        this.volume = level;
    }

    @Override
    public void setSubVolume(float level) {
        this.curSubVolume = level;
    }

    @Override
    public float getSubVolume() {
        return this.curSubVolume;
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public long getMediaDuration() {
        return this.duration;
    }

    public void setMediaDuration(long dur) {
        this.duration = Math.max(300000L, dur);
    }

    @Override
    public void cleanUpOnClose() {
    }

    @Override
    public void preferencesChanged() {
    }
}

