/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.UnsupportedAudioFileException;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import nl.mpi.jsound.NavigableAudioPlayer;
import nl.mpi.jsound.StreamingPlayer;

public class JavaSoundPlayer
extends ControllerManager
implements ElanMediaPlayer,
ControllerListener {
    private Clip playerClip;
    private AudioInputStream audioInStream;
    private FloatControl gainControl;
    private FloatControl rateControl;
    private BooleanControl muteControl;
    private LineListener jspLineListener;
    private PeriodicUpdateController intervalEndController;
    private MediaDescriptor mediaDescriptor;
    private long offset = 0L;
    private boolean playing;
    private boolean playingInterval;
    private float curVolume = 1.0f;
    private float curSubVolume = 1.0f;
    private float curRate = 1.0f;
    private boolean muted = false;
    private final long MIC_TO_MIL = 1000L;
    private double milliSecondsPerSample = 0.0;
    private double microsecondsPerFrame;
    private long stopTime = 0L;
    private boolean streamFile = true;
    private boolean localFile = true;

    public JavaSoundPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        if (mediaDescriptor == null) {
            throw new NoPlayerException(ElanLocale.getString("MediaPlayer.Message.NoMediaDescriptor"));
        }
        this.mediaDescriptor = mediaDescriptor;
        this.offset = mediaDescriptor.timeOrigin;
        String mediaPath = mediaDescriptor.mediaURL;
        if (mediaPath.startsWith("file:")) {
            mediaPath = mediaPath.substring(5);
        }
        if (System.getProperty("JavaSoundUseDefaultClip") != null) {
            this.streamFile = false;
        }
        try {
            File f = new File(mediaPath);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            this.audioInStream = AudioSystem.getAudioInputStream(is);
            AudioFormat format = this.audioInStream.getFormat();
            if (!this.streamFile) {
                this.playerClip = AudioSystem.getClip();
                this.playerClip.open(this.audioInStream);
                try {
                    this.audioInStream.close();
                }
                catch (Throwable throwable) {}
            } else if (!this.localFile) {
                this.playerClip = new StreamingPlayer(this.audioInStream);
            } else {
                this.playerClip = new NavigableAudioPlayer(this.audioInStream, f);
                try {
                    this.audioInStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.printClip(this.playerClip);
            this.printFormat(format);
            this.detectControls(this.playerClip);
            this.microsecondsPerFrame = (double)this.playerClip.getMicrosecondLength() / (double)this.playerClip.getFrameLength();
            this.jspLineListener = new JSPLineListener();
            this.playerClip.addLineListener(this.jspLineListener);
        }
        catch (IOException ioe) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Cannot create sound player, IO error: " + ioe.getMessage());
            }
            throw new NoPlayerException(String.format(ElanLocale.getString("MediaPlayer.Message.CannotPlay"), "JavaSound") + String.format(": %s\n", ioe.getMessage()));
        }
        catch (UnsupportedAudioFileException uafe) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Cannot create sound player, unsupported file: " + uafe.getMessage());
            }
            throw new NoPlayerException(String.format(ElanLocale.getString("MediaPlayer.Message.UnsupportedFile"), "JavaSound") + String.format(": %s\n", uafe.getMessage()));
        }
        catch (Throwable t) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Cannot create sound player, error: " + t.getMessage());
            }
            throw new NoPlayerException(String.format(ElanLocale.getString("MediaPlayer.Message.CannotPlay"), "JavaSound") + String.format(": %s\n", t.getMessage()));
        }
    }

    private void printClip(Clip clip) {
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("Java Sound Player:\n");
            sb.append(String.format("\tFile: %s\n", this.mediaDescriptor.mediaURL));
            sb.append(String.format("\tDuration in microseconds: %d\n", clip.getMicrosecondLength()));
            sb.append(String.format("\tDuration in seconds: %f\n", Float.valueOf((float)clip.getMicrosecondLength() / 1000.0f / 1000.0f)));
            sb.append(String.format("\tDuration in frames: %d\n", clip.getFrameLength()));
            sb.append(String.format("\tMicroseconds per frame: %d\n", clip.getMicrosecondLength() / (long)clip.getFrameLength()));
            sb.append(String.format("\tBuffer Size (bytes): %d", clip.getBufferSize()));
            ClientLogger.LOG.info(sb.toString());
        }
    }

    private void printFormat(AudioFormat format) {
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder("Audio Format:\n");
            sb.append(String.format("\tNumber of channels: %d\n", format.getChannels()));
            sb.append(String.format("\tSample rate: %f\n", Float.valueOf(format.getSampleRate())));
            sb.append(String.format("\tFrame rate: %f\n", Float.valueOf(format.getFrameRate())));
            sb.append(String.format("\tFrame size: %d\n", format.getFrameSize()));
            sb.append(String.format("\tSample size in bits: %d\n", format.getSampleSizeInBits()));
            sb.append(String.format("\tEncoding: %s\n", format.getEncoding().toString()));
            sb.append(String.format("\tProperties: %s", format.properties().toString()));
            ClientLogger.LOG.info(sb.toString());
        }
    }

    private void detectControls(Clip clip) {
        Control[] controls = clip.getControls();
        StringBuilder sb = new StringBuilder("Sound Controls:\n");
        for (Control c : controls) {
            if (c instanceof BooleanControl) {
                BooleanControl bc = (BooleanControl)c;
                if (!bc.getType().equals(BooleanControl.Type.MUTE)) continue;
                this.muteControl = bc;
                sb.append("Mute Control found\n");
                continue;
            }
            if (!(c instanceof FloatControl)) continue;
            FloatControl fc = (FloatControl)c;
            if (fc.getType().equals(FloatControl.Type.MASTER_GAIN)) {
                this.gainControl = fc;
                sb.append("Gain Control found:\n");
                sb.append(String.format("\tMin-Max: %f - %f, Precision: %f, Units: %s\n", Float.valueOf(fc.getMinimum()), Float.valueOf(fc.getMaximum()), Float.valueOf(fc.getPrecision()), fc.getUnits()));
                continue;
            }
            if (fc.getType().equals(FloatControl.Type.SAMPLE_RATE)) {
                this.rateControl = fc;
                sb.append("Sample Rate Control found:\n");
                sb.append(String.format("\tMin-Max: %f - %f, Precision: %f, Units: %s\n", Float.valueOf(fc.getMinimum()), Float.valueOf(fc.getMaximum()), Float.valueOf(fc.getPrecision()), fc.getUnits()));
                continue;
            }
            if (fc.getType().equals(FloatControl.Type.BALANCE)) {
                sb.append("Balance Control found, not used\n");
                continue;
            }
            if (!fc.getType().equals(FloatControl.Type.PAN)) continue;
            sb.append("Pan Control found, not used\n");
        }
        if (ClientLogger.LOG.isLoggable(Level.INFO)) {
            ClientLogger.LOG.info(sb.toString());
        }
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public void start() {
        if (this.playerClip != null) {
            if (this.playing) {
                return;
            }
            if (this.getMediaDuration() - this.getMediaTime() < 40L) {
                this.setMediaTime(0L);
            }
            this.playing = true;
            this.playerClip.start();
            this.startControllers();
        }
    }

    @Override
    public void stop() {
        if (this.playerClip != null) {
            this.playerClip.stop();
            this.stopControllers();
            this.playing = false;
            if (this.playingInterval) {
                this.stopPlayingInterval();
            }
            this.setControllersMediaTime(this.getMediaTime());
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.playerClip != null) {
            return this.playerClip.isRunning();
        }
        return false;
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (this.playerClip != null) {
            if (this.playerClip.isRunning()) {
                this.stop();
            }
            if (this.intervalEndController != null) {
                this.stopPlayingInterval();
            }
            this.intervalEndController = new PeriodicUpdateController(25L);
            this.intervalEndController.addControllerListener(this);
            this.setMediaTime(startTime);
            this.setStopTime(stopTime);
            this.playing = true;
            this.playingInterval = true;
            this.playerClip.start();
            this.startControllers();
            this.intervalEndController.start();
        }
    }

    private void stopPlayingInterval() {
        if (this.intervalEndController != null) {
            this.intervalEndController.removeControllerListener(this);
            this.intervalEndController.stop();
            this.intervalEndController = null;
        }
        this.playingInterval = false;
    }

    @Override
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
        this.setControllersStopTime(this.stopTime);
    }

    @Override
    public void setOffset(long offset) {
        long curTime = this.getMediaTime();
        long diff = this.offset - offset;
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        this.setMediaTime((curTime += diff) < 0L ? 0L : curTime);
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public void nextFrame() {
        if (this.playerClip != null) {
            if (this.playerClip.isRunning()) {
                this.stop();
            }
            long curTime = this.getMediaTime();
            if (this.milliSecondsPerSample > 0.0) {
                this.setMediaTime(curTime + (long)this.milliSecondsPerSample);
            } else {
                this.setMediaTime(curTime + (long)this.microsecondsPerFrame);
            }
        }
    }

    @Override
    public void previousFrame() {
        if (this.playerClip != null) {
            if (this.playerClip.isRunning()) {
                this.stop();
            }
            long curTime = this.getMediaTime();
            if (this.milliSecondsPerSample > 0.0) {
                this.setMediaTime(Math.max(0L, curTime - (long)this.milliSecondsPerSample));
            } else {
                this.setMediaTime(Math.max(0L, curTime - (long)this.microsecondsPerFrame));
            }
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
    }

    @Override
    public void setMediaTime(long time) {
        if (this.playerClip != null) {
            if (this.playerClip.isRunning()) {
                this.stop();
            }
            if (time < 0L) {
                time = 0L;
            }
            if (time > this.getMediaDuration()) {
                time = this.getMediaDuration();
            }
            this.playerClip.setMicrosecondPosition((time + this.offset) * 1000L);
            this.setControllersMediaTime(time);
        }
    }

    @Override
    public long getMediaTime() {
        if (this.playerClip != null) {
            return this.playerClip.getMicrosecondPosition() / 1000L - this.offset;
        }
        return 0L;
    }

    @Override
    public void setRate(float rate) {
        this.curRate = rate;
        if (this.rateControl != null) {
            this.rateControl.setValue(rate);
        }
    }

    @Override
    public float getRate() {
        return this.curRate;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return true;
    }

    @Override
    public long getMediaDuration() {
        if (this.playerClip != null) {
            return this.playerClip.getMicrosecondLength() / 1000L - this.offset;
        }
        return 0L;
    }

    @Override
    public float getVolume() {
        return this.curVolume;
    }

    @Override
    public void setVolume(float level) {
        this.curVolume = level;
        if (this.gainControl != null) {
            if ((double)level == 0.0) {
                this.gainControl.setValue(this.gainControl.getMinimum());
            } else {
                float extend = this.gainControl.getMaximum() - this.gainControl.getMinimum();
                float nValue = (float)((double)(extend / 2.0f) * Math.log10(level));
                nValue = this.gainControl.getMaximum() + nValue;
                nValue = Math.min(nValue, this.gainControl.getMaximum());
                nValue = Math.max(nValue, this.gainControl.getMinimum());
                this.gainControl.setValue(nValue);
            }
        }
    }

    @Override
    public void setSubVolume(float level) {
        this.curSubVolume = level;
    }

    @Override
    public float getSubVolume() {
        return this.curSubVolume;
    }

    @Override
    public void setMute(boolean mute) {
        this.muted = mute;
        if (this.muteControl != null) {
            this.muteControl.setValue(mute);
            if (!mute) {
                this.playerClip.flush();
            }
        }
    }

    @Override
    public boolean getMute() {
        return this.muted;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
    }

    @Override
    public Component getVisualComponent() {
        return null;
    }

    @Override
    public int getSourceWidth() {
        return 0;
    }

    @Override
    public int getSourceHeight() {
        return 0;
    }

    @Override
    public float getAspectRatio() {
        return 0.0f;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
    }

    @Override
    public double getMilliSecondsPerSample() {
        if (this.milliSecondsPerSample > 0.0) {
            return this.milliSecondsPerSample;
        }
        if (this.playerClip != null) {
            return this.playerClip.getMicrosecondLength() / (long)this.playerClip.getFrameLength() / 1000L;
        }
        return 0.0;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        this.milliSecondsPerSample = milliSeconds > 0L ? (double)milliSeconds : 0.0;
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public String getFrameworkDescription() {
        return "JavaSound Media Player";
    }

    @Override
    public void cleanUpOnClose() {
        if (this.playerClip != null) {
            if (this.playerClip.isRunning()) {
                this.playerClip.stop();
            }
            this.playerClip.flush();
            this.playerClip.close();
            this.playerClip.removeLineListener(this.jspLineListener);
        }
        if (this.audioInStream != null) {
            try {
                this.audioInStream.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent && this.playingInterval && this.getMediaTime() >= this.stopTime - 25L) {
            this.stop();
            if (this.getMediaTime() - this.stopTime >= 10L) {
                this.setMediaTime(this.stopTime);
            }
        }
    }

    private class JSPLineListener
    implements LineListener {
        private JSPLineListener() {
        }

        @Override
        public void update(LineEvent event) {
            if (event.getType() == LineEvent.Type.STOP && event.getFramePosition() == (long)JavaSoundPlayer.this.playerClip.getFrameLength()) {
                JavaSoundPlayer.this.stopControllers();
                JavaSoundPlayer.this.playing = false;
            }
        }
    }
}

