/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EndOfMediaWatcher;
import mpi.eudico.client.annotator.player.NeedsCreateNewVisualComponent;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlaySelectionThread;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.player.VideoMouseAdapter;
import mpi.eudico.client.annotator.player.VideoScaleAndMove;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.media.AudioTrackInfo;
import uk.co.caprica.vlcj.media.VideoProjection;
import uk.co.caprica.vlcj.media.VideoTrackInfo;
import uk.co.caprica.vlcj.player.base.AudioApi;
import uk.co.caprica.vlcj.player.base.MediaApi;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.base.VideoApi;
import uk.co.caprica.vlcj.player.base.Viewpoint;
import uk.co.caprica.vlcj.player.component.AudioPlayerComponent;
import uk.co.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaPlayerComponent;
import uk.co.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;

public class VLCJ4MediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
NeedsCreateNewVisualComponent,
ControllerListener,
VideoScaleAndMove,
VideoFrameGrabber {
    private static final Logger logger = Logger.getLogger("VLC");
    private MediaPlayerFactory factory;
    private MediaPlayer player;
    private MediaApi media;
    private VideoTrackInfo firstVideoTrackInfo;
    private EmbeddedMediaPlayerComponent playerComponent = null;
    private AudioPlayerComponent audioPlayerComponent = null;
    private CallbackMediaPlayerComponent callbackPlayerComponent = null;
    private Component videoSurfaceComponent = null;
    private final MediaDescriptor mediaDescriptor;
    private long timeOffset;
    private final ReentrantLock modeLock = new ReentrantLock();
    private PlayMode mode = PlayMode.ToEnd;
    private AtomicBoolean playingFlag;
    private AtomicBoolean playSelectionFlag;
    private ReentrantLock playLock = new ReentrantLock();
    private Condition playCondition;
    private EndOfMediaWatcher endWatcher;
    private long startTime;
    private long stopTime;
    private long duration;
    private long origDuration;
    private Dimension videoSize;
    private static final Dimension fallbackVideoSize = new Dimension(352, 288);
    private float aspectRatio;
    private float origAspectRatio;
    private double msPerFrame = 0.0;
    private boolean frameRateAutoDetected = false;
    private boolean frameStepsToFrameBegin = false;
    private boolean isVisual;
    private ElanLayoutManager layoutManager;
    private VideoMouseAdapter mouseAdapter;
    private int savedVolume;
    private float subVolume;
    private boolean mute;
    private long lcmt;
    private BufferTimer bTimer = new BufferTimer();
    private float videoScaleFactor = 1.0f;
    private boolean isSpherical = false;
    private boolean isMpgvCodec;
    private int numVideoTracks;
    private int numAudioTracks;
    int vdx;
    int vdy;
    int vdx2;
    int vdy2;
    int svw;
    int svh;

    public VLCJ4MediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        boolean bl = this.isVisual = !mediaDescriptor.mimeType.startsWith("audio/");
        if (this.isVisual) {
            if (!SystemReporting.isMacOS()) {
                this.internalCreateNewVisualComponent(null);
            } else {
                this.internalCreateCallbackComponent(null);
            }
            this.tryHiddenPlayer(mediaDescriptor.mediaURL);
            Dimension dim = this.videoSize != null ? this.videoSize : fallbackVideoSize;
            this.aspectRatio = this.origAspectRatio = (float)dim.getWidth() / (float)dim.getHeight();
        } else {
            this.internalCreateAudioPlayer(null);
            this.origAspectRatio = -1.0f;
            this.aspectRatio = -1.0f;
        }
        if (this.numAudioTracks == 0 && this.numVideoTracks == 0 && this.origDuration <= 0L) {
            this.cleanUpOnClose();
            throw new NoPlayerException("VLC cannot play the file, no audio or video tracks found");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Native Library Path {0}", this.factory.nativeLibraryPath());
        }
        this.playingFlag = new AtomicBoolean();
        this.playSelectionFlag = new AtomicBoolean();
        this.playLock = new ReentrantLock();
        this.playCondition = this.playLock.newCondition();
        this.endWatcher = new EndOfMediaWatcher(this, this.playLock, this.playCondition, this.playingFlag, 100);
        if (this.isVisual) {
            this.endWatcher.setEndOfMediaBufferMs(200L);
        }
        this.endWatcher.start();
    }

    private void internalCreateNewVisualComponent(String[] prepareOptions) {
        this.playerComponent = new EmbeddedMediaPlayerComponent();
        this.factory = this.playerComponent.mediaPlayerFactory();
        this.player = this.playerComponent.mediaPlayer();
        this.media = this.player.media();
        this.videoSurfaceComponent = this.playerComponent.videoSurfaceComponent();
        this.videoSurfaceComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long flags = e.getChangeFlags() & 1L;
                if (flags != 0L && e.getComponent().isDisplayable()) {
                    long curTime = VLCJ4MediaPlayer.this.player.status().time();
                    VLCJ4MediaPlayer.this.player.audio().setVolume(2);
                    VLCJ4MediaPlayer.this.player.controls().play();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    VLCJ4MediaPlayer.this.player.controls().pause();
                    VLCJ4MediaPlayer.this.player.controls().setTime(curTime);
                    VLCJ4MediaPlayer.this.player.audio().setVolume(100);
                    VLCJ4MediaPlayer.this.player.video().setAdjustVideo(true);
                    if (VLCJ4MediaPlayer.this.isVisual && VLCJ4MediaPlayer.this.videoSize == null) {
                        VLCJ4MediaPlayer.this.videoSize = VLCJ4MediaPlayer.this.player.video().videoDimension();
                    }
                }
            }
        });
        this.media.prepare(this.mediaDescriptor.mediaURL, prepareOptions);
        this.media.parsing().parse();
        this.player.audio().setMute(false);
        this.player.audio().setVolume(100);
        this.setOffset(this.mediaDescriptor.timeOrigin);
        this.timeOffset = this.mediaDescriptor.timeOrigin;
        this.player.controls().setRepeat(false);
        if (this.isVisual) {
            ((EmbeddedMediaPlayer)this.player).input().enableMouseInputHandling(false);
            ((EmbeddedMediaPlayer)this.player).input().enableKeyInputHandling(false);
        }
    }

    private void internalCreateAudioPlayer(String[] prepareOptions) {
        this.audioPlayerComponent = new AudioPlayerComponent();
        this.factory = this.audioPlayerComponent.mediaPlayerFactory();
        this.player = this.audioPlayerComponent.mediaPlayer();
        this.media = this.player.media();
        this.media.prepare(this.mediaDescriptor.mediaURL, prepareOptions);
        this.media.parsing().parse();
        long startTime = System.currentTimeMillis();
        long MAX = 2000L;
        while (System.currentTimeMillis() - startTime < 2000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.media.info().duration() <= 0L) continue;
        }
        this.msPerFrame = 40.0;
        this.checkMediaInfo(this.player);
        this.player.audio().setMute(false);
        this.player.audio().setVolume(100);
        this.setOffset(this.mediaDescriptor.timeOrigin);
        this.timeOffset = this.mediaDescriptor.timeOrigin;
        this.player.controls().setRepeat(false);
    }

    private void internalCreateCallbackComponent(String[] prepareOptions) {
        this.callbackPlayerComponent = new CallbackMediaPlayerComponent();
        this.factory = this.callbackPlayerComponent.mediaPlayerFactory();
        this.player = this.callbackPlayerComponent.mediaPlayer();
        this.media = this.player.media();
        this.media.prepare(this.mediaDescriptor.mediaURL, prepareOptions);
        this.media.parsing().parse();
        this.checkMediaInfo(this.player);
        this.player.audio().setMute(false);
        this.player.audio().setVolume(100);
        this.setOffset(this.mediaDescriptor.timeOrigin);
        this.timeOffset = this.mediaDescriptor.timeOrigin;
        this.videoSurfaceComponent = this.callbackPlayerComponent.videoSurfaceComponent();
    }

    private void tryHiddenPlayer(String media) {
        CallbackMediaPlayerComponent hiddenPlayerComponent = new CallbackMediaPlayerComponent();
        hiddenPlayerComponent.mediaPlayer().audio().mute();
        hiddenPlayerComponent.mediaPlayer().audio().setVolume(0);
        hiddenPlayerComponent.mediaPlayer().media().play(this.mediaDescriptor.mediaURL, new String[]{""});
        Semaphore semaphore = new Semaphore(0);
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "tryHiddenPlayer: waiting for semaphore...");
            }
            semaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        hiddenPlayerComponent.mediaPlayer().controls().stop();
        this.checkMediaInfo((MediaPlayer)hiddenPlayerComponent.mediaPlayer());
        hiddenPlayerComponent.release();
    }

    @Override
    public Component createNewVisualComponent() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "createNewVisualComponent");
        }
        if (this.isVisual && (this.playerComponent != null || this.callbackPlayerComponent != null) && this.player != null) {
            long time = this.player.status().time();
            int volume = this.player.audio().volume();
            float rate = this.player.status().rate();
            float ar = this.getAspectRatio();
            float zoom = this.getVideoScaleFactor();
            String opt1 = ":start-time=" + Float.toString((float)time / 1000.0f);
            String[] opts = new String[]{opt1};
            if (this.playerComponent != null) {
                this.playerComponent.release();
                this.playerComponent = null;
                this.internalCreateNewVisualComponent(opts);
                this.videoSurfaceComponent = this.playerComponent.videoSurfaceComponent();
                if (this.mouseAdapter != null) {
                    this.mouseAdapter.updateVisualComponent(this.videoSurfaceComponent);
                }
            } else if (this.callbackPlayerComponent != null) {
                this.callbackPlayerComponent.release();
                this.callbackPlayerComponent = null;
                this.internalCreateCallbackComponent(opts);
                this.videoSurfaceComponent = this.callbackPlayerComponent.videoSurfaceComponent();
                if (this.mouseAdapter != null) {
                    this.mouseAdapter.updateVisualComponent(this.videoSurfaceComponent);
                }
            }
            this.player.controls().setRate(rate);
            this.player.audio().setVolume(volume);
            this.player.controls().setTime(time);
            this.setAspectRatio(ar);
            this.setVideoScaleFactor(zoom);
            this.stopControllers();
            if (this.playerComponent != null) {
                return this.videoSurfaceComponent;
            }
            if (this.callbackPlayerComponent != null) {
                return this.videoSurfaceComponent;
            }
            return null;
        }
        return null;
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public String getFrameworkDescription() {
        String suffix = "";
        if (this.callbackPlayerComponent != null) {
            suffix = " (Direct Rendering)";
        }
        return "VLCJMediaPlayer-" + this.factory.application().version() + suffix;
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        logger.log(Level.FINER, "controller update {0}", event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void playInterval(long startTime, long stopTime) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "play interval {0}-{1}", new Object[]{startTime, stopTime});
        }
        this.modeLock.lock();
        try {
            this.startTime = Math.max(0L, startTime);
            this.stopTime = Math.min(stopTime + this.timeOffset, this.player.media().info().duration());
            this.internalSetMediaTime(this.startTime);
            this.playSelectionFlag.set(true);
            new PlaySelectionThread(this, this.playSelectionFlag, stopTime, 20).start();
            this.start();
        }
        finally {
            this.modeLock.unlock();
        }
    }

    @Override
    public void setStopTime(long stopTime) {
    }

    private void stopPlayingInterval() {
        this.modeLock.lock();
        try {
            this.mode = PlayMode.ToEnd;
        }
        finally {
            this.modeLock.unlock();
        }
    }

    @Override
    public Component getVisualComponent() {
        if (this.isVisual) {
            if (this.playerComponent != null) {
                return this.videoSurfaceComponent;
            }
            if (this.callbackPlayerComponent != null) {
                return this.callbackPlayerComponent.videoSurfaceComponent();
            }
        }
        return null;
    }

    @Override
    public int getSourceHeight() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getSourceHeight; height is {0}", this.videoSize == null ? "unknown" : String.valueOf(this.videoSize.height));
        }
        if (this.videoSize != null) {
            return this.videoSize.height;
        }
        return VLCJ4MediaPlayer.fallbackVideoSize.height;
    }

    @Override
    public int getSourceWidth() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getSourceWidth; width is {0}", this.videoSize == null ? "unknown" : String.valueOf(this.videoSize.width));
        }
        if (this.videoSize != null) {
            return this.videoSize.width;
        }
        return VLCJ4MediaPlayer.fallbackVideoSize.width;
    }

    public Component getControlPanelComponent() {
        return null;
    }

    @Override
    public float getAspectRatio() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getAspectRatio: {0}", Float.valueOf(this.aspectRatio));
        }
        if (this.isVisual) {
            return this.aspectRatio;
        }
        return 0.0f;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        String aspect = "";
        switch ((int)((double)(100.0f * aspectRatio) + 0.5)) {
            case 100: {
                aspect = "1:1";
                break;
            }
            case 125: {
                aspect = "5:4";
                break;
            }
            case 133: {
                aspect = "4:3";
                break;
            }
            case 160: {
                aspect = "16:10";
                break;
            }
            case 177: 
            case 178: {
                aspect = "16:9";
                break;
            }
            case 221: {
                aspect = "221:100";
                break;
            }
            case 234: 
            case 235: {
                aspect = "235:100";
                break;
            }
            case 239: {
                aspect = "239:100";
                break;
            }
            default: {
                aspect = "";
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "player.setAspectRatio({0})", aspect);
        }
        this.player.video().setAspectRatio(aspect);
        this.aspectRatio = aspectRatio;
    }

    @Override
    public void start() {
        block5: {
            this.player.controls().play();
            this.startControllers();
            this.player.audio().setVolume(this.savedVolume);
            try {
                if (!this.playLock.tryLock(300L, TimeUnit.MILLISECONDS)) break block5;
                try {
                    this.playingFlag.set(true);
                    this.playCondition.signal();
                }
                finally {
                    this.playLock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stop() {
        if (this.player.status().isPlaying()) {
            if (this.player.status().canPause()) {
                this.player.controls().pause();
            } else {
                this.player.controls().stop();
            }
        }
        this.playingFlag.set(false);
        this.playSelectionFlag.set(false);
        this.stopControllers();
        this.setControllersMediaTime(this.getMediaTime());
        this.stopPlayingInterval();
        this.bTimer.pause();
    }

    @Override
    public boolean isPlaying() {
        return this.player.status().isPlaying();
    }

    @Override
    public double getMilliSecondsPerSample() {
        if (this.msPerFrame > 0.0) {
            return this.msPerFrame;
        }
        return 40.0;
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.frameRateAutoDetected) {
            this.msPerFrame = milliSeconds;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting ms/sample to {0}", milliSeconds);
            }
        } else if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "Setting ms/sample not supported, requested {0}", milliSeconds);
        }
    }

    @Override
    public float getVolume() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getVolume {0}", Float.valueOf((float)this.player.audio().volume() / 100.0f));
        }
        return (float)this.player.audio().volume() / 100.0f;
    }

    @Override
    public void setVolume(float level) {
        int value = (int)(level * 100.0f);
        if (value > 0 && this.player.audio().isMute()) {
            this.player.audio().setMute(false);
        }
        this.player.audio().setVolume(value);
        this.savedVolume = value;
    }

    @Override
    public void setOffset(long offset) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "set offset {0}", offset);
        }
        long diff = this.timeOffset - offset;
        this.timeOffset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.player != null) {
            if (this.origDuration == 0L) {
                this.origDuration = this.player.media().info().duration();
            }
            this.duration = this.origDuration - this.timeOffset;
        }
        this.stopTime += diff;
        this.setStopTime(this.stopTime);
    }

    @Override
    public long getOffset() {
        return this.timeOffset;
    }

    @Override
    public long getMediaTime() {
        long ct;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "getMediaTime {0}", this.player.status().time() - this.timeOffset);
        }
        if ((ct = this.player.status().time()) == this.lcmt) {
            if (this.playingFlag.get()) {
                ct += this.bTimer.getTime();
            }
        } else {
            this.lcmt = ct;
            this.bTimer.reset();
        }
        return ct - this.timeOffset;
    }

    @Override
    public void setMediaTime(long time) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "set media time {0} + offset {1}", new Object[]{time, this.timeOffset});
        }
        this.internalSetMediaTime(time);
    }

    private void internalSetMediaTime(long time) {
        this.player.controls().setTime(time + this.timeOffset);
        this.setControllersMediaTime(time);
        if (this.player.status().time() == this.lcmt) {
            this.bTimer.pause();
        } else {
            this.bTimer.pauseReset();
            this.lcmt = 0L;
        }
    }

    @Override
    public void nextFrame() {
        if (this.player.status().isPlaying()) {
            this.stop();
        }
        this.player.controls().nextFrame();
        this.setControllersMediaTime(this.getMediaTime());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "time now {0}", this.player.status().time());
        }
    }

    @Override
    public void previousFrame() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Previous frame not supported natively.");
        }
        if (this.player != null) {
            if (this.player.status().isPlaying()) {
                this.stop();
            }
            double msecPerSample = this.getMilliSecondsPerSample();
            long curTime = this.getMediaTime();
            if (this.frameStepsToFrameBegin) {
                long curFrame = (long)((double)curTime / msecPerSample);
                if (curFrame > 0L) {
                    this.internalSetMediaTime((long)Math.ceil((double)(curFrame - 1L) * msecPerSample));
                } else {
                    this.internalSetMediaTime(0L);
                }
            } else {
                if ((curTime = (long)Math.ceil((double)curTime - msecPerSample)) < 0L) {
                    curTime = 0L;
                }
                this.internalSetMediaTime(curTime);
            }
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public float getRate() {
        return this.player.status().rate();
    }

    @Override
    public void setRate(float rate) {
        this.player.controls().setRate(rate);
        this.setControllersRate(rate);
        this.bTimer.setRate(rate);
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        return this.frameRateAutoDetected;
    }

    @Override
    public long getMediaDuration() {
        return this.player.media().info().duration() - this.timeOffset;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        this.layoutManager = layoutManager;
        if (this.isVisual) {
            if (this.playerComponent != null) {
                this.mouseAdapter = new VideoMouseAdapter(this, layoutManager, this.videoSurfaceComponent);
            } else if (this.callbackPlayerComponent != null) {
                this.mouseAdapter = new VideoMouseAdapter(this, layoutManager, this.callbackPlayerComponent.videoSurfaceComponent());
            }
        }
    }

    @Override
    public void updateLocale() {
        if (this.mouseAdapter != null) {
            this.mouseAdapter.updateLocale();
        }
    }

    @Override
    public void cleanUpOnClose() {
        if (this.player != null) {
            this.player.controls().stop();
        }
        if (this.playerComponent != null) {
            this.playerComponent.release();
            this.playerComponent = null;
        }
        if (this.callbackPlayerComponent != null) {
            this.callbackPlayerComponent.release();
            this.callbackPlayerComponent = null;
        }
        if (this.audioPlayerComponent != null) {
            this.audioPlayerComponent.release();
            this.audioPlayerComponent = null;
        }
    }

    @Override
    public void setSubVolume(float level) {
        this.subVolume = level;
    }

    @Override
    public float getSubVolume() {
        return this.subVolume;
    }

    @Override
    public void setMute(boolean mute) {
        this.mute = mute;
    }

    @Override
    public boolean getMute() {
        return this.mute;
    }

    @Override
    public void preferencesChanged() {
    }

    private void checkMediaInfo(MediaPlayer mediaPlayer) {
        if (mediaPlayer != null) {
            VideoApi videoApi;
            if (this.origDuration > 0L) {
                return;
            }
            if (mediaPlayer.media().info().duration() <= 0L) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("The media player is not initalized yet, duration <= 0");
                }
                return;
            }
            StringBuffer sb = new StringBuffer("=== Media player info ===\n");
            MediaApi mediaApi = mediaPlayer.media();
            sb.append(String.format("Location: %s\n", mediaApi.info().mrl()));
            sb.append(String.format("Duration: %d ms\n", mediaApi.info().duration()));
            sb.append(String.format("Type: %s\n", mediaApi.info().type()));
            this.origDuration = mediaApi.info().duration();
            List atiList = mediaApi.info().audioTracks();
            List vtiList = mediaApi.info().videoTracks();
            this.numAudioTracks = atiList == null ? 0 : atiList.size();
            this.numVideoTracks = vtiList == null ? 0 : vtiList.size();
            sb.append(String.format("No. audio tracks: %d\n", this.numAudioTracks));
            sb.append(String.format("No. video tracks: %d\n", this.numVideoTracks));
            AudioApi audioApi = mediaPlayer.audio();
            if (audioApi != null && atiList != null && !atiList.isEmpty()) {
                sb.append("** Audio **\n");
                sb.append(String.format("Volume: %d\n", audioApi.volume()));
                sb.append(String.format("Is mute: %b\n", audioApi.isMute()));
                sb.append(String.format("Audio device: %s\n", audioApi.outputDevice()));
                sb.append(String.format("Current track: %d\n", audioApi.track()));
                if (atiList != null) {
                    for (AudioTrackInfo ati : atiList) {
                        sb.append(String.format("Audio track: %d\n", ati.id()));
                        sb.append(String.format("\tCodec: %s (%s)\n", ati.codecName(), ati.codecDescription()));
                        sb.append(String.format("\tBitrate: %d\n", ati.bitRate()));
                        sb.append(String.format("\tNo. channels: %d\n", ati.channels()));
                        sb.append(String.format("\tLevel: %d\n", ati.level()));
                        sb.append(String.format("\tRate: %d\n", ati.rate()));
                    }
                }
            }
            if ((videoApi = mediaPlayer.video()) != null && vtiList != null && !vtiList.isEmpty()) {
                sb.append("** Video **\n");
                sb.append(String.format("Aspect ratio: %s\n", videoApi.aspectRatio()));
                sb.append(String.format("Scale: %f\n", Float.valueOf(videoApi.scale())));
                Dimension vidDim = videoApi.videoDimension();
                if (vidDim != null && vidDim.width > 0) {
                    sb.append(String.format("Dimension: %d, %d\n", vidDim.width, vidDim.height));
                    this.videoSize = new Dimension(vidDim);
                    this.origAspectRatio = (float)this.videoSize.width / (float)this.videoSize.height;
                }
                sb.append(String.format("Crop geom.: %s\n", videoApi.cropGeometry()));
                if (vtiList != null) {
                    for (VideoTrackInfo vti : vtiList) {
                        if (this.firstVideoTrackInfo == null) {
                            this.firstVideoTrackInfo = vti;
                            if ("mpgv".equals(vti.codecName())) {
                                this.isMpgvCodec = true;
                            }
                            this.isVisual = true;
                        }
                        sb.append(String.format("Video track: %d\n", vti.id()));
                        sb.append(String.format("\tCodec: %s (%s)\n", vti.codecName(), vti.codecDescription()));
                        sb.append(String.format("\tBitrate: %d\n", vti.bitRate()));
                        sb.append(String.format("\tFrame rate: %d\n", vti.frameRate()));
                        sb.append(String.format("\tFrame rate base: %d\n", vti.frameRateBase()));
                        sb.append(String.format("\tDimension: %d, %d\n", vti.width(), vti.height()));
                        sb.append(String.format("\tSpherical: field of view: %f, pitch: %f, roll: %f, yaw: %f\n", Float.valueOf(vti.fov()), Float.valueOf(vti.pitch()), Float.valueOf(vti.roll()), Float.valueOf(vti.yaw())));
                        VideoProjection vidProj = vti.projection();
                        if (vidProj != null) {
                            sb.append(String.format("\tProjection: %s\n", vidProj.toString()));
                            if (VideoProjection.EQUIRECTANGULAR == vidProj) {
                                this.isSpherical = true;
                            }
                        }
                        if (vti.frameRate() <= 0 || !(this.msPerFrame <= 0.0)) continue;
                        double fr = (double)vti.frameRateBase() / (double)vti.frameRate();
                        this.msPerFrame = 1.0 / fr;
                        this.frameRateAutoDetected = true;
                    }
                }
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info(sb.toString());
            }
        }
    }

    @Override
    public float getVideoScaleFactor() {
        return this.videoScaleFactor;
    }

    @Override
    public void setVideoScaleFactor(float scaleFactor) {
        this.videoScaleFactor = scaleFactor;
        if (this.isSpherical) {
            if (this.videoScaleFactor == 1.0f) {
                Viewpoint vp = this.player.video().newViewpoint();
                vp.setFov(80.0f);
                this.player.video().updateViewpoint(vp, true);
                vp.release();
            } else {
                Viewpoint vp = this.player.video().newViewpoint();
                if (this.videoScaleFactor == 1.5f) {
                    vp.setFov(5.0f);
                } else if (this.videoScaleFactor == 2.0f) {
                    vp.setFov(10.0f);
                } else if (this.videoScaleFactor == 3.0f) {
                    vp.setFov(-5.0f);
                } else if (this.videoScaleFactor == 4.0f) {
                    vp.setFov(-10.0f);
                }
                this.player.video().updateViewpoint(vp, false);
                vp.release();
            }
        } else if (this.videoScaleFactor == 1.0f) {
            this.vdy = 0;
            this.vdx = 0;
            if (this.svw == 0) {
                this.svw = this.videoSize.width;
                this.svh = this.videoSize.height;
            }
            this.vdx2 = this.svw;
            this.vdy2 = this.svh;
            this.player.video().setCropGeometry(String.format("%dx%d+%d+%d", this.vdx2, this.vdy2, this.vdx, this.vdy));
        } else {
            int cx = (this.vdx + this.vdx2) / 2;
            int cy = (this.vdy + this.vdy2) / 2;
            if (this.svw == 0) {
                this.svw = this.videoSize.width;
                this.svh = this.videoSize.height;
            }
            this.vdx = (int)(((float)this.svw - (float)this.svw / this.videoScaleFactor) / 2.0f);
            this.vdy = (int)(((float)this.svh - (float)this.svh / this.videoScaleFactor) / 2.0f);
            this.vdx2 = this.vdx + (int)((float)this.svw / this.videoScaleFactor);
            this.vdy2 = this.vdy + (int)((float)this.svh / this.videoScaleFactor);
            if (cx != 0) {
                int dx = this.svw / 2 - cx;
                int dy = this.svh / 2 - cy;
                if (this.vdx - dx < 0) {
                    this.vdx = 0;
                    this.vdx2 = (int)((float)this.svw / this.videoScaleFactor);
                } else if (this.vdx2 - dx > this.svw) {
                    this.vdx2 = this.svw;
                    this.vdx = this.vdx2 - (int)((float)this.svw / this.videoScaleFactor);
                } else {
                    this.vdx -= dx;
                    this.vdx2 -= dx;
                }
                if (this.vdy - dy < 0) {
                    this.vdy = 0;
                    this.vdy2 = (int)((float)this.svh / this.videoScaleFactor);
                } else if (this.vdy2 - dy > this.svh) {
                    this.vdy2 = this.svh;
                    this.vdy = this.vdy2 - (int)((float)this.svh / this.videoScaleFactor);
                } else {
                    this.vdy -= dy;
                    this.vdy2 -= dy;
                }
            }
            this.player.video().setCropGeometry(String.format("%dx%d+%d+%d", this.vdx2, this.vdy2, this.vdx, this.vdy));
        }
    }

    @Override
    public void repaintVideo() {
    }

    @Override
    public int[] getVideoBounds() {
        if (this.videoScaleFactor == 1.0f) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("getVideoBounds: %d, %d, %d, %d", 0, 0, this.videoSurfaceComponent.getWidth(), this.videoSurfaceComponent.getHeight()));
            }
            return new int[]{0, 0, this.videoSurfaceComponent.getWidth(), this.videoSurfaceComponent.getHeight()};
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("getVideoBounds: %d, %d, %d, %d", this.vdx, this.vdy, this.svw, this.svh));
        }
        if (this.vdx2 - this.vdx != 0) {
            int vscWidth = this.playerComponent.videoSurfaceComponent().getWidth();
            int vscHeight = this.playerComponent.videoSurfaceComponent().getHeight();
            float ratioX = (float)vscWidth / ((float)this.svw / this.videoScaleFactor);
            float ratioY = (float)vscHeight / ((float)this.svh / this.videoScaleFactor);
            int x = (int)(ratioX * (float)this.vdx);
            int y = (int)(ratioY * (float)this.vdy);
            int w = (int)(ratioX * (float)this.svw);
            int h = (int)(ratioY * (float)this.svh);
            return new int[]{-x, -y, w, h};
        }
        return new int[]{-this.vdx, -this.vdy, this.svw, this.svh};
    }

    @Override
    public void setVideoBounds(int x, int y, int w, int h) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format("setVideoBounds: %d, %d, %d, d", x, y, w, h));
        }
    }

    @Override
    public void moveVideoPos(int dx, int dy) {
        if (this.videoScaleFactor > 1.0f && !this.isSpherical) {
            if (dx == 0 && dy == 0) {
                return;
            }
            if (this.vdx - dx >= 0 && this.vdx2 - dx <= this.svw) {
                this.vdx -= dx;
                this.vdx2 -= dx;
            }
            if (this.vdy - dy >= 0 && this.vdy2 - dy <= this.svh) {
                this.vdy -= dy;
                this.vdy2 -= dy;
            }
            this.player.video().setCropGeometry(String.format("%dx%d+%d+%d", this.vdx2, this.vdy2, this.vdx, this.vdy));
        } else if (this.isSpherical) {
            Viewpoint vp = this.player.video().newViewpoint();
            vp.setYaw((float)(-dx) * 0.3f);
            vp.setPitch((float)(-dy) * 0.3f);
            this.player.video().updateViewpoint(vp, false);
        }
    }

    @Override
    public Image getCurrentFrameImage() {
        if (this.isVisual) {
            return this.player.snapshots().get();
        }
        return null;
    }

    @Override
    public Image getFrameImageForTime(long time) {
        if (this.isVisual) {
            this.setMediaTime(time);
            return this.player.snapshots().get();
        }
        return null;
    }

    static {
        String vlcPath = System.getProperty("nl.mpi.elan.vlcj");
        if (vlcPath != null && logger.isLoggable(Level.WARNING)) {
            logger.warning(String.format("Loading of native VLC libraries from custom directory (\"%s\") is not supported yet", vlcPath));
        }
    }

    private class BufferTimer {
        private long curZeroTime = 0L;
        private long curLapsedTime = 0L;
        private float tickRate = 1.0f;
        private boolean started = false;

        private BufferTimer() {
        }

        void reset() {
            this.curZeroTime = System.currentTimeMillis();
            this.curLapsedTime = 0L;
            this.started = true;
        }

        void pause() {
            this.started = false;
        }

        void pauseReset() {
            this.curLapsedTime = 0L;
            this.started = false;
        }

        void setRate(float rate) {
            this.tickRate = rate;
        }

        long getTime() {
            if (!this.started) {
                return this.curLapsedTime;
            }
            long d = System.currentTimeMillis() - this.curZeroTime;
            this.curLapsedTime = (long)(this.tickRate * (float)d);
            return this.curLapsedTime;
        }
    }

    private static enum PlayMode {
        ToEnd,
        Interval;

    }
}

