/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Locale;
import java.util.StringTokenizer;
import mpi.eudico.client.annotator.util.ClientLogger;

public class PrefObjectConverter
implements ClientLogger {
    public String objectToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Color) {
            Color col = (Color)value;
            return new String(col.getRed() + "," + col.getGreen() + "," + col.getBlue());
        }
        if (value instanceof Dimension) {
            Dimension dim = (Dimension)value;
            return new String(dim.width + "," + dim.height);
        }
        if (value instanceof Point) {
            Point p = (Point)value;
            return new String(p.x + "," + p.y);
        }
        if (value instanceof Rectangle) {
            Rectangle r = (Rectangle)value;
            return new String(r.x + "," + r.y + "," + r.width + "," + r.height);
        }
        if (value instanceof Font) {
            Font f = (Font)value;
            return new String(f.getName() + "," + f.getStyle() + "," + f.getSize());
        }
        if (value instanceof Locale) {
            Locale l = (Locale)value;
            return new String(l.getLanguage() + "," + l.getCountry());
        }
        return value.toString();
    }

    public Object stringToObject(String className, String value) {
        if (value == null) {
            return null;
        }
        try {
            Class<?> classObj = Class.forName(className);
            if (classObj == Color.class) {
                return this.stringToColor(value);
            }
            if (classObj == Dimension.class) {
                return this.stringToDim(value);
            }
            if (classObj == Point.class) {
                return this.stringToPoint(value);
            }
            if (classObj == Rectangle.class) {
                return this.stringToRect(value);
            }
            if (classObj == Font.class) {
                return this.stringToFont(value);
            }
            if (classObj == Locale.class) {
                return this.stringToLocale(value);
            }
        }
        catch (LinkageError le) {
            LOG.warning("Cannot create class: " + le.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            LOG.warning("Cannot create class: " + cnfe.getMessage());
        }
        return null;
    }

    private Color stringToColor(String value) {
        int b;
        int g;
        int r;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() < 3) {
            return null;
        }
        try {
            r = Integer.parseInt(tokenizer.nextToken());
            g = Integer.parseInt(tokenizer.nextToken());
            b = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Color(r, g, b);
    }

    private Dimension stringToDim(String value) {
        int h;
        int w;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() < 2) {
            return null;
        }
        try {
            w = Integer.parseInt(tokenizer.nextToken());
            h = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Dimension(w, h);
    }

    private Point stringToPoint(String value) {
        int y;
        int x;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() < 2) {
            return null;
        }
        try {
            x = Integer.parseInt(tokenizer.nextToken());
            y = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Point(x, y);
    }

    private Rectangle stringToRect(String value) {
        int h;
        int w;
        int y;
        int x;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() < 4) {
            return null;
        }
        try {
            x = Integer.parseInt(tokenizer.nextToken());
            y = Integer.parseInt(tokenizer.nextToken());
            w = Integer.parseInt(tokenizer.nextToken());
            h = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Rectangle(x, y, w, h);
    }

    private Font stringToFont(String value) {
        int h;
        int style;
        String name;
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() < 3) {
            return null;
        }
        try {
            name = tokenizer.nextToken();
            style = Integer.parseInt(tokenizer.nextToken());
            h = Integer.parseInt(tokenizer.nextToken());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return new Font(name, style, h);
    }

    private Locale stringToLocale(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() == 0) {
            return new Locale("");
        }
        if (tokenizer.countTokens() == 1) {
            return new Locale(tokenizer.nextToken());
        }
        if (tokenizer.countTokens() == 2) {
            String lng = tokenizer.nextToken();
            return new Locale(lng, tokenizer.nextToken());
        }
        return new Locale("");
    }
}

