/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.CVPanel;
import mpi.eudico.client.annotator.prefs.gui.EditingPanel;
import mpi.eudico.client.annotator.prefs.gui.GeneralPrefsPanel;
import mpi.eudico.client.annotator.prefs.gui.MediaNavPanel;
import mpi.eudico.client.annotator.prefs.gui.MetadataPanel;
import mpi.eudico.client.annotator.prefs.gui.PlatformPanel;
import mpi.eudico.client.annotator.prefs.gui.UIPrefsPanel;
import mpi.eudico.client.annotator.prefs.gui.ViewerPanel;

public class EditPrefsDialog
extends ClosableDialog
implements ActionListener,
TreeSelectionListener {
    private JLabel titleLabel;
    private JScrollPane treeScrollPane;
    private JPanel prefCatPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private JPanel buttonPanel;
    private JTree catTree;
    private HashMap<String, String> catKeyMap;
    private HashMap<String, JPanel> activatedPanels;
    private CardLayout cardLayout;
    private JPanel currentEditPanel = null;

    public EditPrefsDialog(Frame owner, boolean modal) throws HeadlessException {
        this(owner, "", modal);
    }

    public EditPrefsDialog(Frame owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    public EditPrefsDialog(Dialog owner, boolean modal) throws HeadlessException {
        this(owner, "", modal);
    }

    public EditPrefsDialog(Dialog owner, String title, boolean modal) throws HeadlessException {
        super(owner, title, modal);
        this.initComponents();
    }

    private void postInit() {
        this.pack();
        Rectangle b = Preferences.getRect("EditPreferencesDialog.Bounds", null);
        if (b != null) {
            GraphicsDevice[] screens;
            for (GraphicsDevice gd : screens = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
                if (!gd.getDefaultConfiguration().getBounds().intersects(b)) continue;
                this.setBounds(b);
                break;
            }
        } else {
            int w = 720;
            int h = 450;
            this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
            this.setLocationRelativeTo(this.getParent());
        }
    }

    private void initComponents() {
        this.catKeyMap = new HashMap();
        this.activatedPanels = new HashMap();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        int origFontSize = this.titleLabel.getFont().getSize();
        float titleSize = 1.2f * (float)origFontSize;
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(titleSize));
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.insets = new Insets(6, 6, 10, 6);
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        this.catTree = new JTree(new DefaultMutableTreeNode(""));
        this.catTree.getSelectionModel().setSelectionMode(1);
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.catTree.getCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.treeScrollPane = new JScrollPane(this.catTree);
        Dimension dim = new Dimension(200, 300);
        this.treeScrollPane.setPreferredSize(dim);
        this.treeScrollPane.setMinimumSize(dim);
        this.treeScrollPane.setBackground(Color.WHITE);
        gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weighty = 1.0;
        gbc.gridy = 1;
        this.getContentPane().add((Component)this.treeScrollPane, gbc);
        this.cardLayout = new CardLayout();
        this.prefCatPanel = new JPanel(this.cardLayout);
        this.prefCatPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.SelectCategory")), "Intro_xxx");
        this.cardLayout.show(this.prefCatPanel, "Intro_xxx");
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.getContentPane().add((Component)this.prefCatPanel, gbc);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.applyButton = new JButton();
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.applyButton);
        this.buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 15;
        gbc.insets = insets;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.updateLocale();
        this.postInit();
        this.catTree.addTreeSelectionListener(this);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("PreferencesDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("PreferencesDialog.Title"));
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        String val = ElanLocale.getString("PreferencesDialog.Category.Edit");
        this.catKeyMap.put(val, "PreferencesDialog.Category.Edit");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.CV");
        this.catKeyMap.put(val, "PreferencesDialog.Category.CV");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.Media");
        this.catKeyMap.put(val, "PreferencesDialog.Category.Media");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.Metadata");
        this.catKeyMap.put(val, "PreferencesDialog.Category.Metadata");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.OS");
        this.catKeyMap.put(val, "PreferencesDialog.Category.OS");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.Preferences");
        this.catKeyMap.put(val, "PreferencesDialog.Category.Preferences");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.UI");
        this.catKeyMap.put(val, "PreferencesDialog.Category.UI");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        val = ElanLocale.getString("PreferencesDialog.Category.Viewer");
        this.catKeyMap.put(val, "PreferencesDialog.Category.Viewer");
        ((DefaultMutableTreeNode)this.catTree.getModel().getRoot()).add(new DefaultMutableTreeNode(val));
        this.catTree.setEditable(false);
        this.catTree.expandRow(0);
    }

    private JPanel getPanelForKey(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("PreferencesDialog.Category.Edit")) {
            return new EditingPanel();
        }
        if (key.equals("PreferencesDialog.Category.CV")) {
            return new CVPanel();
        }
        if (key.equals("PreferencesDialog.Category.Media")) {
            return new MediaNavPanel();
        }
        if (key.equals("PreferencesDialog.Category.Metadata")) {
            return new MetadataPanel();
        }
        if (key.equals("PreferencesDialog.Category.OS")) {
            return new PlatformPanel();
        }
        if (key.equals("PreferencesDialog.Category.Preferences")) {
            return new GeneralPrefsPanel();
        }
        if (key.equals("PreferencesDialog.Category.UI")) {
            return new UIPrefsPanel();
        }
        if (key.equals("PreferencesDialog.Category.Viewer")) {
            return new ViewerPanel();
        }
        return null;
    }

    private void applyChanges() {
        if (this.activatedPanels.size() == 0) {
            return;
        }
        HashMap<String, Object> allChanges = new HashMap<String, Object>();
        for (JPanel nextObj : this.activatedPanels.values()) {
            PreferenceEditor ed;
            if (!(nextObj instanceof PreferenceEditor) || !(ed = (PreferenceEditor)((Object)nextObj)).isChanged()) continue;
            allChanges.putAll(ed.getChangedPreferences());
        }
        if (allChanges.size() > 0) {
            String key = null;
            Object val = null;
            for (Map.Entry e : allChanges.entrySet()) {
                key = (String)e.getKey();
                val = e.getValue();
                Preferences.set(key, val, null);
            }
            Preferences.set(key, val, null, true, true);
        }
    }

    private void closeDialog() {
        Preferences.set("Media.VideosCentre.Temporary", null, null);
        Preferences.set("EditPreferencesDialog.Bounds", this.getBounds(), null);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.applyButton) {
            if (this.currentEditPanel instanceof EditingPanel ? !((EditingPanel)this.currentEditPanel).validateInputs() : this.currentEditPanel instanceof CVPanel && !((CVPanel)this.currentEditPanel).validateInputs()) {
                return;
            }
            this.applyChanges();
            this.setVisible(false);
            this.closeDialog();
        } else if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.closeDialog();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        Object selNode;
        if (this.currentEditPanel instanceof EditingPanel) {
            if (!((EditingPanel)this.currentEditPanel).validateInputs()) {
                this.catTree.removeTreeSelectionListener(this);
                this.catTree.setSelectionPath(e.getOldLeadSelectionPath());
                this.catTree.addTreeSelectionListener(this);
                return;
            }
        } else if (this.currentEditPanel instanceof CVPanel && !((CVPanel)this.currentEditPanel).validateInputs()) {
            this.catTree.removeTreeSelectionListener(this);
            this.catTree.setSelectionPath(e.getOldLeadSelectionPath());
            this.catTree.addTreeSelectionListener(this);
            return;
        }
        if ((selNode = e.getPath().getLastPathComponent()) instanceof DefaultMutableTreeNode) {
            String key = (String)((DefaultMutableTreeNode)selNode).getUserObject();
            String val = this.catKeyMap.get(key);
            if (this.currentEditPanel != null && this.activatedPanels.get(val) == this.currentEditPanel) {
                return;
            }
            if (this.activatedPanels.get(val) != null) {
                Boolean value;
                if (this.activatedPanels.get(val) instanceof ViewerPanel && (value = Preferences.getBool("Media.VideosCentre.Temporary", null)) != null) {
                    ((ViewerPanel)this.activatedPanels.get(val)).updateVideoInCentre(value);
                }
                this.cardLayout.show(this.prefCatPanel, val);
                this.currentEditPanel = this.activatedPanels.get(val);
            } else {
                JPanel nextPanel = this.getPanelForKey(val);
                if (nextPanel != null) {
                    Boolean value;
                    if (nextPanel instanceof ViewerPanel && (value = Preferences.getBool("Media.VideosCentre.Temporary", null)) != null) {
                        ((ViewerPanel)nextPanel).updateVideoInCentre(value);
                    }
                    this.prefCatPanel.add((Component)nextPanel, val);
                    this.cardLayout.show(this.prefCatPanel, val);
                    this.currentEditPanel = nextPanel;
                    this.activatedPanels.put(val, nextPanel);
                }
            }
        }
    }
}

