/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.CachedDataManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.annotator.util.FileUtility;

public class GeneralPrefsPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
ActionListener {
    private String curGenPrefsLocation = "-";
    private JLabel setDirLabel;
    private JLabel curDirLabel;
    private JButton defaultDirButton;
    private JButton resetDirButton;
    private String curCacheDirectory = "-";
    private JLabel cacheDirLabel;
    private JLabel curCacheDirLabel;
    private JButton cacheDirButton;
    private JButton resetCacheDirButton;
    private JCheckBox tierSetCB;
    private String curTSPath = "-";
    private JLabel setTSFileLabel;
    private JLabel curTSFileLabel;
    private JButton defaultTSFileButton;
    private JButton resetTSFileButton;
    private JComboBox nrOfBuFilesCB;
    private Integer origNumBuFiles = 1;
    private JCheckBox checkForUpdatesCB;
    private JCheckBox saveAsOldFormatCB;
    private boolean origCheckUpdates = true;
    private boolean origSaveAsOldFormatFlag = false;
    private boolean oriWorkWithTierSetFlag = false;

    public GeneralPrefsPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.Preferences"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Boolean boolPref;
        Integer intPref;
        Boolean boolPref1;
        String stringPref = Preferences.getString("DefaultPreferencesLocation", null);
        if (stringPref != null) {
            this.curGenPrefsLocation = stringPref;
        }
        if ((stringPref = Preferences.getString("DefaultTierSetFilePath", null)) != null) {
            this.curTSPath = stringPref;
        }
        if ((boolPref1 = Preferences.getBool("WorkwithTierSets", null)) != null) {
            this.oriWorkWithTierSetFlag = boolPref1;
        }
        if ((intPref = Preferences.getInt("NumberOfBackUpFiles", null)) != null) {
            this.origNumBuFiles = intPref;
        }
        if ((boolPref = Preferences.getBool("AutomaticUpdate", null)) != null) {
            this.origCheckUpdates = boolPref;
        }
        if ((boolPref = Preferences.getBool("SaveAsOldEAF2_7", null)) != null) {
            this.origSaveAsOldFormatFlag = boolPref;
        }
        if ((stringPref = Preferences.getString("CacheLocation", null)) != null) {
            this.curCacheDirectory = stringPref;
        }
    }

    private void initComponents() {
        this.setDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.DefaultLoc"));
        Font plainFont = this.setDirLabel.getFont().deriveFont(0);
        this.setDirLabel.setFont(plainFont);
        JPanel dirPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.topInset;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        dirPanel.add((Component)this.setDirLabel, gbc);
        this.curDirLabel = new JLabel(this.curGenPrefsLocation);
        this.curDirLabel.setFont(new Font(this.curDirLabel.getFont().getFontName(), 0, 10));
        gbc.gridy = 1;
        dirPanel.add((Component)this.curDirLabel, gbc);
        this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.insets = this.leftInset;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        dirPanel.add((Component)this.defaultDirButton, gbc);
        this.defaultDirButton.addActionListener(this);
        this.resetDirButton = new JButton();
        ImageIcon resetIcon = null;
        try {
            resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.resetDirButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.resetDirButton.setText("X");
        }
        this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
        gbc.gridx = 2;
        dirPanel.add((Component)this.resetDirButton, gbc);
        this.resetDirButton.addActionListener(this);
        this.cacheDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.CacheDirectory"));
        this.cacheDirLabel.setFont(plainFont);
        JPanel cacheDirPanel = new JPanel(new GridBagLayout());
        GridBagConstraints cachePanelGbc = new GridBagConstraints();
        cachePanelGbc.anchor = 18;
        cachePanelGbc.gridx = 0;
        cachePanelGbc.gridy = 0;
        cachePanelGbc.insets = this.topInset;
        cachePanelGbc.fill = 2;
        cachePanelGbc.weightx = 1.0;
        cacheDirPanel.add((Component)this.cacheDirLabel, cachePanelGbc);
        this.curCacheDirLabel = new JLabel(this.curCacheDirectory);
        this.curCacheDirLabel.setFont(new Font(this.curCacheDirLabel.getFont().getFontName(), 0, 10));
        cachePanelGbc.gridy = 1;
        cacheDirPanel.add((Component)this.curCacheDirLabel, cachePanelGbc);
        this.cacheDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        cachePanelGbc.gridy = 0;
        cachePanelGbc.gridx = 1;
        cachePanelGbc.gridheight = 2;
        cachePanelGbc.insets = this.leftInset;
        cachePanelGbc.fill = 0;
        cachePanelGbc.weightx = 0.0;
        cacheDirPanel.add((Component)this.cacheDirButton, cachePanelGbc);
        this.cacheDirButton.addActionListener(this);
        this.resetCacheDirButton = new JButton();
        if (resetIcon != null) {
            this.resetCacheDirButton.setIcon(resetIcon);
        } else {
            this.resetCacheDirButton.setText("X");
        }
        this.resetCacheDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetCacheDirButton.setPreferredSize(new Dimension(this.resetCacheDirButton.getPreferredSize().width, this.cacheDirButton.getPreferredSize().height));
        cachePanelGbc.gridx = 2;
        cacheDirPanel.add((Component)this.resetCacheDirButton, cachePanelGbc);
        this.resetCacheDirButton.addActionListener(this);
        this.tierSetCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Edit.TierSet"), this.oriWorkWithTierSetFlag);
        this.tierSetCB.setFont(plainFont);
        this.setTSFileLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.DefaultTSFilePath"));
        this.setTSFileLabel.setFont(plainFont);
        this.curTSFileLabel = new JLabel(this.curTSPath);
        this.curTSFileLabel.setFont(this.curDirLabel.getFont());
        this.defaultTSFileButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.defaultTSFileButton.addActionListener(this);
        this.resetTSFileButton = new JButton();
        this.resetTSFileButton.addActionListener(this);
        if (resetIcon != null) {
            this.resetTSFileButton.setIcon(resetIcon);
        } else {
            this.resetTSFileButton.setText("X");
        }
        this.resetTSFileButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetTSFileButton.setPreferredSize(this.resetDirButton.getPreferredSize());
        JPanel tsFilePathPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.topInset;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        tsFilePathPanel.add((Component)this.tierSetCB, gbc);
        gbc.gridy = 1;
        tsFilePathPanel.add((Component)this.setTSFileLabel, gbc);
        gbc.gridy = 2;
        tsFilePathPanel.add((Component)this.curTSFileLabel, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.insets = this.leftInset;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        tsFilePathPanel.add((Component)this.defaultTSFileButton, gbc);
        gbc.gridx = 2;
        tsFilePathPanel.add((Component)this.resetTSFileButton, gbc);
        Integer[] nrOfBuItemsList = new Integer[]{1, 2, 3, 4, 5};
        this.nrOfBuFilesCB = new JComboBox<Integer>(nrOfBuItemsList);
        this.nrOfBuFilesCB.setSelectedItem(this.origNumBuFiles);
        this.nrOfBuFilesCB.setFont(plainFont);
        JLabel backUpLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.NumBackUp"));
        backUpLabel.setFont(plainFont);
        JPanel backupPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.topInset;
        backupPanel.add((Component)backUpLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        backupPanel.add((Component)this.nrOfBuFilesCB, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        backupPanel.add((Component)new JPanel(), gbc);
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.checkForUpdatesCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Prefs.AutoUpdate"), this.origCheckUpdates);
        this.checkForUpdatesCB.setFont(plainFont);
        this.outerPanel.add((Component)this.checkForUpdatesCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalPanelInset;
        this.outerPanel.add((Component)backupPanel, gbc);
        this.saveAsOldFormatCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Prefs.SaveAsOld"), this.origSaveAsOldFormatFlag);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.saveAsOldFormatCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.Location")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catPanelInset;
        this.outerPanel.add((Component)dirPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("MultiTierControlPanel.Menu.TierSet")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catPanelInset;
        this.outerPanel.add((Component)tsFilePathPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Prefs.CacheLocation")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catPanelInset;
        this.outerPanel.add((Component)cacheDirPanel, gbc);
        gbc.gridy = gy++;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(2);
            if (this.curDirLabel.getText() != null && !this.curDirLabel.getText().equals("-")) {
                chMap.put("DefaultPreferencesLocation", this.curDirLabel.getText());
            } else {
                chMap.put("DefaultPreferencesLocation", null);
            }
            if (this.curCacheDirLabel.getText() != null && !this.curCacheDirLabel.getText().equals("-")) {
                chMap.put("CacheLocation", this.curCacheDirLabel.getText());
            } else {
                chMap.put("CacheLocation", null);
            }
            if (this.curTSFileLabel.getText() != null && !this.curTSFileLabel.getText().equals("-")) {
                chMap.put("DefaultTierSetFilePath", this.curTSFileLabel.getText());
            } else {
                chMap.put("DefaultTierSetFilePath", null);
            }
            if (this.tierSetCB.isSelected() != this.oriWorkWithTierSetFlag) {
                chMap.put("WorkwithTierSets", this.tierSetCB.isSelected());
            }
            if (this.origNumBuFiles != this.nrOfBuFilesCB.getSelectedItem()) {
                chMap.put("NumberOfBackUpFiles", this.nrOfBuFilesCB.getSelectedItem());
            }
            if (this.origCheckUpdates != this.checkForUpdatesCB.isSelected()) {
                chMap.put("AutomaticUpdate", this.checkForUpdatesCB.isSelected());
            }
            if (this.saveAsOldFormatCB.isSelected() != this.origSaveAsOldFormatFlag) {
                chMap.put("SaveAsOldEAF2_7", this.saveAsOldFormatCB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return !this.curGenPrefsLocation.equals(this.curDirLabel.getText()) || !this.curTSPath.equals(this.curTSFileLabel.getText()) || this.origNumBuFiles != this.nrOfBuFilesCB.getSelectedItem() || this.origCheckUpdates != this.checkForUpdatesCB.isSelected() || this.tierSetCB.isSelected() != this.oriWorkWithTierSetFlag || this.origSaveAsOldFormatFlag != this.saveAsOldFormatCB.isSelected() || !this.curCacheDirectory.equals(this.curCacheDirLabel.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultDirButton) {
            File selFile = this.showDirectoryChooser(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"), this.curGenPrefsLocation);
            if (selFile != null) {
                this.curDirLabel.setText(selFile.getAbsolutePath());
                this.curDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        } else if (e.getSource() == this.resetDirButton) {
            this.curDirLabel.setText("-");
        } else if (e.getSource() == this.cacheDirButton) {
            File selFile = this.showDirectoryChooser(ElanLocale.getString("PreferencesDialog.Prefs.CacheDirectory"), this.curCacheDirectory);
            if (selFile != null && selFile.isDirectory()) {
                if (!CachedDataManager.containsCacheSubdirs(selFile).booleanValue()) {
                    this.curCacheDirLabel.setText(selFile.getAbsolutePath());
                    this.curCacheDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
                } else {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("PreferencesDialog.Prefs.NewCacheDirContainsSubdirs"), ElanLocale.getString("Message.Error"), 0);
                }
            }
        } else if (e.getSource() == this.resetCacheDirButton) {
            this.curCacheDirLabel.setText("-");
        } else if (e.getSource() == this.resetTSFileButton) {
            this.curTSFileLabel.setText("-");
        } else if (e.getSource() == this.defaultTSFileButton) {
            FileChooser chooser = new FileChooser(this);
            File startDir = new File(System.getProperty("user.home"));
            String selectedFile = null;
            if (this.curTSPath.length() > 1) {
                File dir;
                File file = new File(FileUtility.urlToAbsPath(this.curTSPath));
                if (file.exists() && file.isFile()) {
                    selectedFile = file.getAbsolutePath();
                }
                if ((dir = new File(FileUtility.urlToAbsPath(FileUtility.directoryFromPath(this.curTSPath)))).exists() && dir.isDirectory()) {
                    startDir = dir;
                }
            }
            chooser.setCurrentDirectory(startDir.getAbsolutePath());
            chooser.createAndShowFileDialog(ElanLocale.getString("PreferencesDialog.Prefs.TierSetFilePath"), 0, ElanLocale.getString("Button.Select"), null, null, true, null, 0, selectedFile);
            File selFile = chooser.getSelectedFile();
            if (selFile != null) {
                this.curTSFileLabel.setText(selFile.getAbsolutePath());
                this.curTSFileLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        }
    }

    private File showDirectoryChooser(String title, String currentDirectory) {
        File dir;
        FileChooser chooser = new FileChooser(this);
        File startDir = new File(System.getProperty("user.home"));
        if (currentDirectory.length() > 1 && (dir = new File(FileUtility.urlToAbsPath(currentDirectory))).exists() && dir.isDirectory()) {
            startDir = dir;
        }
        chooser.setCurrentDirectory(startDir.getAbsolutePath());
        chooser.createAndShowFileDialog(title, 0, ElanLocale.getString("Button.Select"), null, null, true, null, 1, null);
        return chooser.getSelectedFile();
    }
}

