/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.annotator.util.FileUtility;

public class MediaNavPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
ChangeListener,
ActionListener {
    private boolean origFrameStepToFrameBegin = false;
    private boolean origPre47FrameStepping = false;
    private String curMediaLocation = "-";
    private boolean origVideoSameSize = false;
    private boolean videoInCentre = false;
    private boolean origAltMediaLocSetsDirty = true;
    private String origTimeFormat = "ms";
    private boolean origPromptForFilename = true;
    private boolean origOnlyClipFirstMediaFile = false;
    private boolean origClipInParallel = true;
    private boolean origShowVolumeControls = true;
    private boolean origAutoPlayActivatedAnnotation = false;
    private boolean origAutoPlayKeyCreateAnnotation = false;
    private JCheckBox frameStepCB;
    private JCheckBox pre47FrameSteppingCB;
    private JCheckBox videosSameSizeCB;
    private JCheckBox videosInCentreCB;
    private JLabel setDirLabel;
    private JLabel curDirLabel;
    private JButton defaultDirButton;
    private JButton resetDirButton;
    private JCheckBox changedMediaLocCB;
    private JLabel timeFormatLabel;
    private JComboBox timeFormatComboBox;
    private JCheckBox promptForFilenameCB;
    private JCheckBox onlyClipFirstMediaFileCB;
    private JCheckBox clipInParallelCB;
    private JCheckBox showVolumeControlsCB;
    private JCheckBox autoPlayActivatedAnnotationCB;
    private JCheckBox autoPlayKeyCreateAnnotationCB;
    private String HH_MM_SS_MS = ElanLocale.getString("TimeCodeFormat.Hours");
    private String SS_MS = ElanLocale.getString("TimeCodeFormat.Seconds");
    private String MS = ElanLocale.getString("TimeCodeFormat.MilliSec");
    private String NTSC = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC");
    private String PAL = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL");
    private String PAL_50 = ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50");
    private Map<String, String> tcMap = new HashMap<String, String>(5);
    private int origTimeFormatIndex;

    public MediaNavPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.Media"));
        this.tcMap.put(this.HH_MM_SS_MS, "hh:mm:ss.ms");
        this.tcMap.put(this.SS_MS, "ss.ms");
        this.tcMap.put(this.MS, "ms");
        this.tcMap.put(this.NTSC, "NTSC");
        this.tcMap.put(this.PAL, "PAL");
        this.tcMap.put(this.PAL_50, "PAL-50fps");
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        String stringPref;
        Boolean boolPref = Preferences.getBool("MediaNavigation.FrameStepToFrameBegin", null);
        if (boolPref != null) {
            this.origFrameStepToFrameBegin = boolPref;
        }
        if ((boolPref = Preferences.getBool("MediaNavigation.Pre47FrameStepping", null)) != null) {
            this.origPre47FrameStepping = boolPref;
        }
        if ((stringPref = Preferences.getString("DefaultMediaLocation", null)) != null) {
            this.curMediaLocation = stringPref;
        }
        if ((boolPref = Preferences.getBool("Media.VideosSameSize", null)) != null) {
            this.origVideoSameSize = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.VideosCentre", null)) != null) {
            this.videoInCentre = boolPref;
        }
        if ((boolPref = Preferences.getBool("MediaLocation.AltLocationSetsChanged", null)) != null) {
            this.origAltMediaLocSetsDirty = boolPref;
        }
        if ((stringPref = Preferences.getString("CurrentTime.Copy.TimeFormat", null)) != null) {
            if (this.tcMap.containsKey(stringPref)) {
                this.origTimeFormat = this.tcMap.get(stringPref);
            } else if (this.tcMap.values().contains(stringPref)) {
                this.origTimeFormat = stringPref;
            }
        }
        if ((boolPref = Preferences.getBool("Media.PromptForFilename", null)) != null) {
            this.origPromptForFilename = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.OnlyClipFirstMediaFile", null)) != null) {
            this.origOnlyClipFirstMediaFile = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.ClipInParallel", null)) != null) {
            this.origClipInParallel = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.HaveIndividualVolumeControls", null)) != null) {
            this.origShowVolumeControls = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.Autoplay.ActivateAnnotation", null)) != null) {
            this.origAutoPlayActivatedAnnotation = boolPref;
        }
        if ((boolPref = Preferences.getBool("Media.Autoplay.KeyCreateAnnotation", null)) != null) {
            this.origAutoPlayKeyCreateAnnotation = boolPref;
        }
    }

    private void initComponents() {
        this.setDirLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"));
        Font plainFont = this.setDirLabel.getFont().deriveFont(0);
        this.setDirLabel.setFont(plainFont);
        JPanel dirPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.topInset;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        dirPanel.add((Component)this.setDirLabel, gbc);
        this.curDirLabel = new JLabel(this.curMediaLocation);
        this.curDirLabel.setFont(new Font(this.curDirLabel.getFont().getFontName(), 0, 10));
        gbc.gridy = 1;
        dirPanel.add((Component)this.curDirLabel, gbc);
        this.defaultDirButton = new JButton(ElanLocale.getString("Button.Browse"));
        gbc.gridy = 0;
        gbc.gridx = 1;
        gbc.gridheight = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.leftInset;
        dirPanel.add((Component)this.defaultDirButton, gbc);
        this.defaultDirButton.addActionListener(this);
        this.resetDirButton = new JButton();
        ImageIcon resetIcon = null;
        try {
            resetIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
            this.resetDirButton.setIcon(resetIcon);
        }
        catch (Exception ex) {
            this.resetDirButton.setText("X");
        }
        this.resetDirButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Reset"));
        this.resetDirButton.setPreferredSize(new Dimension(this.resetDirButton.getPreferredSize().width, this.defaultDirButton.getPreferredSize().height));
        gbc.gridx = 2;
        dirPanel.add((Component)this.resetDirButton, gbc);
        this.resetDirButton.addActionListener(this);
        this.timeFormatLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Media.TimeFormat"));
        this.timeFormatLabel.setFont(plainFont);
        this.timeFormatComboBox = new JComboBox();
        this.timeFormatComboBox.setFont(plainFont);
        this.timeFormatComboBox.addItem(this.HH_MM_SS_MS);
        this.timeFormatComboBox.addItem(this.SS_MS);
        this.timeFormatComboBox.addItem(this.MS);
        this.timeFormatComboBox.addItem(this.NTSC);
        this.timeFormatComboBox.addItem(this.PAL);
        this.timeFormatComboBox.addItem(this.PAL_50);
        boolean prefRestored = false;
        Iterator<String> tcIt = this.tcMap.keySet().iterator();
        String tcConst = null;
        while (tcIt.hasNext()) {
            String key = tcIt.next();
            tcConst = this.tcMap.get(key);
            if (!tcConst.equals(this.origTimeFormat)) continue;
            this.timeFormatComboBox.setSelectedItem(key);
            prefRestored = true;
            break;
        }
        if (!prefRestored) {
            this.timeFormatComboBox.setSelectedItem(this.MS);
        }
        this.origTimeFormatIndex = this.timeFormatComboBox.getSelectedIndex();
        JPanel timeFormat = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.insets = this.topInset;
        timeFormat.add((Component)this.timeFormatLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.globalInset;
        timeFormat.add((Component)this.timeFormatComboBox, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        timeFormat.add((Component)new JPanel(), gbc);
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.globalInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)timeFormat, gbc);
        this.frameStepCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.MediaNav.FrameBegin"), this.origFrameStepToFrameBegin);
        this.frameStepCB.setFont(plainFont);
        this.pre47FrameSteppingCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.MediaNav.Pre47FrameStepping"), this.origPre47FrameStepping);
        this.pre47FrameSteppingCB.setFont(plainFont);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Category.MediaNav")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.frameStepCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.pre47FrameSteppingCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.VideoDisplay")), gbc);
        this.videosSameSizeCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoSize"), this.origVideoSameSize);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.videosSameSizeCB.setFont(plainFont);
        this.outerPanel.add((Component)this.videosSameSizeCB, gbc);
        this.videosInCentreCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.VideoCentre"), this.videoInCentre);
        this.videosInCentreCB.addActionListener(this);
        gbc.gridy = gy++;
        this.videosInCentreCB.setFont(plainFont);
        this.outerPanel.add((Component)this.videosInCentreCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Location")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catPanelInset;
        this.outerPanel.add((Component)dirPanel, gbc);
        this.changedMediaLocCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.SaveAltLocation"));
        this.changedMediaLocCB.setFont(plainFont);
        this.changedMediaLocCB.setSelected(this.origAltMediaLocSetsDirty);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.changedMediaLocCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        gbc.fill = 2;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Clipping")), gbc);
        this.promptForFilenameCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.PromptForFilename"), this.origPromptForFilename);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.promptForFilenameCB.setFont(plainFont);
        this.outerPanel.add((Component)this.promptForFilenameCB, gbc);
        this.onlyClipFirstMediaFileCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.OnlyClipFirstMediaFile"), this.origOnlyClipFirstMediaFile);
        gbc.gridy = gy++;
        this.onlyClipFirstMediaFileCB.setFont(plainFont);
        this.outerPanel.add((Component)this.onlyClipFirstMediaFileCB, gbc);
        this.clipInParallelCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.ClipInParallel"), this.origClipInParallel);
        gbc.gridy = gy++;
        this.clipInParallelCB.setFont(plainFont);
        this.outerPanel.add((Component)this.clipInParallelCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.Controls")), gbc);
        this.showVolumeControlsCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.PlayerVolumeControls"), this.origShowVolumeControls);
        this.showVolumeControlsCB.addActionListener(this);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.showVolumeControlsCB.setFont(plainFont);
        this.outerPanel.add((Component)this.showVolumeControlsCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Media.AutomaticallyPlayMedia")), gbc);
        this.autoPlayActivatedAnnotationCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.AutoPlayWhenActivated"), this.origAutoPlayActivatedAnnotation);
        this.autoPlayActivatedAnnotationCB.addActionListener(this);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.autoPlayActivatedAnnotationCB.setFont(plainFont);
        this.outerPanel.add((Component)this.autoPlayActivatedAnnotationCB, gbc);
        this.autoPlayKeyCreateAnnotationCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Media.AutoPlayKeyCreate"), this.origAutoPlayKeyCreateAnnotation);
        this.autoPlayKeyCreateAnnotationCB.addActionListener(this);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.autoPlayKeyCreateAnnotationCB.setFont(plainFont);
        this.outerPanel.add((Component)this.autoPlayKeyCreateAnnotationCB, gbc);
        gbc.gridy = gy++;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(10);
            if (this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin) {
                chMap.put("MediaNavigation.FrameStepToFrameBegin", this.frameStepCB.isSelected());
            }
            if (this.pre47FrameSteppingCB.isSelected() != this.origPre47FrameStepping) {
                chMap.put("MediaNavigation.Pre47FrameStepping", this.pre47FrameSteppingCB.isSelected());
            }
            if (this.videosSameSizeCB.isSelected() != this.origVideoSameSize) {
                chMap.put("Media.VideosSameSize", this.videosSameSizeCB.isSelected());
            }
            if (this.videosInCentreCB.isSelected() != this.videoInCentre) {
                chMap.put("Media.VideosCentre", this.videosInCentreCB.isSelected());
            }
            if (this.curDirLabel.getText() != null && !this.curDirLabel.getText().equals("-")) {
                chMap.put("DefaultMediaLocation", this.curDirLabel.getText());
            } else {
                chMap.put("DefaultMediaLocation", null);
            }
            if (this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty) {
                chMap.put("MediaLocation.AltLocationSetsChanged", this.changedMediaLocCB.isSelected());
            }
            if (this.origTimeFormatIndex != this.timeFormatComboBox.getSelectedIndex()) {
                chMap.put("CurrentTime.Copy.TimeFormat", this.tcMap.get(this.timeFormatComboBox.getSelectedItem()));
            }
            if (this.promptForFilenameCB.isSelected() != this.origPromptForFilename) {
                chMap.put("Media.PromptForFilename", this.promptForFilenameCB.isSelected());
            }
            if (this.onlyClipFirstMediaFileCB.isSelected() != this.origOnlyClipFirstMediaFile) {
                chMap.put("Media.OnlyClipFirstMediaFile", this.onlyClipFirstMediaFileCB.isSelected());
            }
            if (this.clipInParallelCB.isSelected() != this.origClipInParallel) {
                chMap.put("Media.ClipInParallel", this.clipInParallelCB.isSelected());
            }
            if (this.showVolumeControlsCB.isSelected() != this.origShowVolumeControls) {
                chMap.put("Media.HaveIndividualVolumeControls", this.showVolumeControlsCB.isSelected());
            }
            if (this.autoPlayActivatedAnnotationCB.isSelected() != this.origAutoPlayActivatedAnnotation) {
                chMap.put("Media.Autoplay.ActivateAnnotation", this.autoPlayActivatedAnnotationCB.isSelected());
            }
            if (this.autoPlayKeyCreateAnnotationCB.isSelected() != this.origAutoPlayKeyCreateAnnotation) {
                chMap.put("Media.Autoplay.KeyCreateAnnotation", this.autoPlayKeyCreateAnnotationCB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.frameStepCB.isSelected() != this.origFrameStepToFrameBegin || this.pre47FrameSteppingCB.isSelected() != this.origPre47FrameStepping || !this.curMediaLocation.equals(this.curDirLabel.getText()) || this.videosSameSizeCB.isSelected() != this.origVideoSameSize || this.videosInCentreCB.isSelected() != this.videoInCentre || this.changedMediaLocCB.isSelected() != this.origAltMediaLocSetsDirty || this.origTimeFormatIndex != this.timeFormatComboBox.getSelectedIndex() || this.promptForFilenameCB.isSelected() != this.origPromptForFilename || this.onlyClipFirstMediaFileCB.isSelected() != this.origOnlyClipFirstMediaFile || this.clipInParallelCB.isSelected() != this.origClipInParallel || this.showVolumeControlsCB.isSelected() != this.origShowVolumeControls || this.autoPlayActivatedAnnotationCB.isSelected() != this.origAutoPlayActivatedAnnotation || this.autoPlayKeyCreateAnnotationCB.isSelected() != this.origAutoPlayKeyCreateAnnotation;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.defaultDirButton) {
            File dir;
            FileChooser chooser = new FileChooser(this);
            if (this.curMediaLocation.length() > 1 && (dir = new File(FileUtility.urlToAbsPath(this.curMediaLocation))).exists() && dir.isDirectory()) {
                chooser.setCurrentDirectory(dir.getAbsolutePath());
            }
            chooser.createAndShowFileDialog(ElanLocale.getString("PreferencesDialog.Media.DefaultLoc"), 0, ElanLocale.getString("Button.Select"), null, null, true, null, 1, null);
            File selFile = chooser.getSelectedFile();
            if (selFile != null) {
                this.curDirLabel.setText(selFile.getAbsolutePath());
                this.curDirLabel.setText(FileUtility.pathToURLString(selFile.getAbsolutePath()));
            }
        } else if (e.getSource() == this.resetDirButton) {
            this.curDirLabel.setText("-");
        } else if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.videosInCentreCB) {
            Preferences.set("Media.VideosCentre.Temporary", this.videosInCentreCB.isSelected(), null);
        }
    }
}

