/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;

public class UIPrefsPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor {
    private JComboBox nrOfRecentItemsCBox;
    private Integer origNrRecentItems = 5;
    private JCheckBox tooltipCB;
    private boolean origToolTipEnabled = true;
    private JCheckBox showAnnotationCountCB;
    private boolean origShowAnnotationCount = false;
    private JRadioButton useBufferedPaintingRB;
    private JRadioButton useDirectPaintingRB;
    private boolean origUseBufferedPainting = false;
    private JSlider fontScaleSlider;
    private int origFontScaleInt = 100;

    public UIPrefsPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.UI"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        Float scalePref;
        Boolean boolPref;
        Integer intPref = Preferences.getInt("UI.RecentItems", null);
        if (intPref != null) {
            this.origNrRecentItems = intPref;
        }
        if ((boolPref = Preferences.getBool("UI.ToolTips.Enabled", null)) != null) {
            this.origToolTipEnabled = boolPref;
        }
        if ((boolPref = Preferences.getBool("UI.MenuItems.ShowAnnotationCount", null)) != null) {
            this.origShowAnnotationCount = boolPref;
        }
        if ((boolPref = Preferences.getBool("UI.UseBufferedPainting", null)) != null) {
            this.origUseBufferedPainting = boolPref;
        }
        if ((scalePref = Preferences.getFloat("UI.FontScaleFactor", null)) != null) {
            float origFontScale = scalePref.floatValue();
            if (origFontScale < 1.0f) {
                origFontScale = 1.0f;
            } else if (origFontScale > 2.0f) {
                origFontScale = 2.0f;
            }
            this.origFontScaleInt = (int)(100.0f * origFontScale);
        }
    }

    private void initComponents() {
        Integer[] nrOfRecentItemsList = new Integer[]{5, 10, 15, 20, 25, 30};
        this.nrOfRecentItemsCBox = new JComboBox<Integer>(nrOfRecentItemsList);
        this.nrOfRecentItemsCBox.setSelectedItem(this.origNrRecentItems);
        Font plainFont = this.nrOfRecentItemsCBox.getFont().deriveFont(0);
        this.nrOfRecentItemsCBox.setFont(plainFont);
        this.nrOfRecentItemsCBox.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
        JLabel recentItemsLabel = new JLabel(ElanLocale.getString("PreferencesDialog.UI.RecentItems"));
        recentItemsLabel.setFont(plainFont);
        JPanel recentItemsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.topInset;
        recentItemsPanel.add((Component)recentItemsLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        recentItemsPanel.add((Component)this.nrOfRecentItemsCBox, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        recentItemsPanel.add((Component)new JPanel(), gbc);
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.catInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)recentItemsPanel, gbc);
        JLabel uiFontScaleLabel = new JLabel(ElanLocale.getString("PreferencesDialog.UI.FontScaling"));
        this.fontScaleSlider = new JSlider(0, 100, 200, this.origFontScaleInt);
        this.fontScaleSlider.setMajorTickSpacing(20);
        this.fontScaleSlider.setPaintLabels(true);
        this.fontScaleSlider.setPaintTicks(true);
        JPanel fontScalePanel = new JPanel(new GridBagLayout());
        GridBagConstraints fbc = new GridBagConstraints();
        fbc.anchor = 18;
        fbc.insets = this.topInset;
        fbc.fill = 2;
        fbc.weightx = 0.1;
        fbc.gridwidth = 1;
        fbc.gridheight = 1;
        fontScalePanel.add((Component)uiFontScaleLabel, fbc);
        fbc.gridy = 1;
        gbc.insets = this.globalInset;
        fontScalePanel.add((Component)this.fontScaleSlider, fbc);
        JLabel relaunchLabel = new JLabel();
        ImageIcon relaunchIcon = null;
        try {
            relaunchIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
            relaunchLabel.setIcon(relaunchIcon);
        }
        catch (Exception ex) {
            relaunchLabel.setText(ElanLocale.getString("PreferencesDialog.Relaunch"));
        }
        relaunchLabel.setToolTipText(ElanLocale.getString("PreferencesDialog.Relaunch.Tooltip"));
        fbc.gridx = 1;
        fbc.gridy = 0;
        fbc.gridheight = 2;
        fbc.fill = 0;
        fbc.anchor = 10;
        fbc.weightx = 0.0;
        fontScalePanel.add((Component)relaunchLabel, fbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)fontScalePanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        gbc.fill = 2;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.ToolTip")), gbc);
        this.tooltipCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.UI.ToolTip.Enabled"));
        this.tooltipCB.setSelected(this.origToolTipEnabled);
        this.tooltipCB.setFont(this.tooltipCB.getFont().deriveFont(0));
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.tooltipCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.MenuOptions")), gbc);
        this.showAnnotationCountCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.UI.MenuOptions.ShowAnnotationCount"));
        this.showAnnotationCountCB.setSelected(this.origShowAnnotationCount);
        this.showAnnotationCountCB.setFont(this.showAnnotationCountCB.getFont().deriveFont(0));
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.showAnnotationCountCB, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.UI.PaintingStrategy")), gbc);
        ButtonGroup bGroup = new ButtonGroup();
        this.useBufferedPaintingRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.UI.UseBufferedPainting"));
        this.useBufferedPaintingRB.setSelected(this.origUseBufferedPainting);
        this.useBufferedPaintingRB.setFont(this.tooltipCB.getFont().deriveFont(0));
        this.useDirectPaintingRB = new JRadioButton(ElanLocale.getString("PreferencesDialog.UI.UseDirectPainting"));
        this.useDirectPaintingRB.setSelected(!this.origUseBufferedPainting);
        this.useDirectPaintingRB.setFont(this.tooltipCB.getFont().deriveFont(0));
        bGroup.add(this.useBufferedPaintingRB);
        bGroup.add(this.useDirectPaintingRB);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.useBufferedPaintingRB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.useDirectPaintingRB, gbc);
        gbc.gridy = gy++;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.outerPanel.add((Component)new JPanel(), gbc);
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            HashMap<String, Object> chMap = new HashMap<String, Object>(6);
            if (this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems) {
                chMap.put("UI.RecentItems", this.nrOfRecentItemsCBox.getSelectedItem());
            }
            if (this.fontScaleSlider.getValue() != this.origFontScaleInt) {
                if (this.fontScaleSlider.getValue() == 100) {
                    chMap.put("UI.FontScaleFactor", null);
                } else {
                    chMap.put("UI.FontScaleFactor", Float.valueOf((float)this.fontScaleSlider.getValue() / 100.0f));
                }
            }
            if (this.tooltipCB.isSelected() != this.origToolTipEnabled) {
                chMap.put("UI.ToolTips.Enabled", this.tooltipCB.isSelected());
            }
            if (this.showAnnotationCountCB.isSelected() != this.origShowAnnotationCount) {
                chMap.put("UI.MenuItems.ShowAnnotationCount", this.showAnnotationCountCB.isSelected());
            }
            if (this.useBufferedPaintingRB.isSelected() != this.origUseBufferedPainting) {
                chMap.put("UI.UseBufferedPainting", this.useBufferedPaintingRB.isSelected());
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        return this.nrOfRecentItemsCBox.getSelectedItem() != this.origNrRecentItems || this.tooltipCB.isSelected() != this.origToolTipEnabled || this.showAnnotationCountCB.isSelected() != this.origShowAnnotationCount || this.origUseBufferedPainting != this.useBufferedPaintingRB.isSelected() || this.origFontScaleInt != this.fontScaleSlider.getValue();
    }
}

