/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.prefs.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ColorDialog;
import mpi.eudico.client.annotator.prefs.PreferenceEditor;
import mpi.eudico.client.annotator.prefs.gui.AbstractEditPrefsPanel;
import mpi.eudico.client.util.ButtonCellEditor;
import mpi.eudico.client.util.ButtonTableCellRenderer;
import mpi.eudico.client.util.RadioButtonCellEditor;
import mpi.eudico.client.util.RadioButtonTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;

public class ViewerPanel
extends AbstractEditPrefsPanel
implements PreferenceEditor,
MouseListener,
ActionListener {
    private int origNumSubtitles = 4;
    private boolean origActiveAnnBold = false;
    private boolean origReducedTierHeight = false;
    private boolean videoInCentre = false;
    private JComboBox numSubCB;
    private JCheckBox aaBoldCB;
    private JCheckBox redTierHeightCB;
    private JCheckBox tierOrderInDropdownCB;
    private boolean origTierOrderInDropdownCB;
    private Color origSymAnnColor;
    private Color symAnnColor = this.origSymAnnColor = Constants.SHAREDCOLOR1;
    private JPanel colorPreviewPanel;
    private JButton colorButton;
    private JButton resetColorButton;
    private JLabel colorTextLabel;
    public ColorDialog dialog;
    private JButton downButton;
    private JButton upButton;
    private JTable viewerTable;
    private boolean sortOrderChanged = false;
    private final String GRID_VIEWER = ElanLocale.getString("Menu.View.Viewers.Grid");
    private final String TEXT_VIEWER = ElanLocale.getString("Menu.View.Viewers.Text");
    private final String SUBTITLE_VIEWER = ElanLocale.getString("Menu.View.Viewers.Subtitles");
    private final String LEXICON_VIEWER = ElanLocale.getString("LexiconEntryViewer.Lexicon");
    private final String COMMENT_VIEWER = ElanLocale.getString("CommentViewer.Comment");
    private final String RECOGNIZER = ElanLocale.getString("Menu.View.Viewers.Recognizer");
    private final String METADATA_VIEWER = ElanLocale.getString("Menu.View.Viewers.MetaData");
    private final List<String> viewersList = new ArrayList<String>(Arrays.asList(this.GRID_VIEWER, this.TEXT_VIEWER, this.SUBTITLE_VIEWER, this.LEXICON_VIEWER, this.COMMENT_VIEWER, this.RECOGNIZER, this.METADATA_VIEWER));
    private List<String> viewerSortOrder;
    private JSpinner scrollSpeedSpinner;
    private int origScrollSpeed = 10;
    private final int MIN_SCROLL = 5;
    private final int MAX_SCROLL = 50;

    public ViewerPanel() {
        super(ElanLocale.getString("PreferencesDialog.Category.Viewer"));
        this.readPrefs();
        this.initComponents();
    }

    private void readPrefs() {
        List<String> order;
        Integer intPref;
        Boolean boolPref = Preferences.getBool("Media.VideosCentre", null);
        if (boolPref != null) {
            this.videoInCentre = boolPref;
        }
        if ((intPref = Preferences.getInt("NumberOfSubtitleViewers", null)) != null) {
            this.origNumSubtitles = intPref;
        }
        if ((boolPref = Preferences.getBool("TimeLineViewer.ActiveAnnotationBold", null)) instanceof Boolean) {
            this.origActiveAnnBold = boolPref;
        }
        if ((boolPref = Preferences.getBool("TimeLineViewer.ReducedTierHeight", null)) instanceof Boolean) {
            this.origReducedTierHeight = boolPref;
        }
        if ((boolPref = Preferences.getBool("SingleTierViewer.TierOrderInDropdown", null)) instanceof Boolean) {
            this.origTierOrderInDropdownCB = boolPref;
        }
        this.viewerSortOrder = (order = Preferences.getListOfString("PreferencesDialog.Viewer.SortOrder", null)) != null ? order : this.viewersList;
        Color colorPref = Preferences.getColor("Preferences.SymAnnColor", null);
        if (colorPref != null) {
            this.origSymAnnColor = new Color(colorPref.getRed(), colorPref.getGreen(), colorPref.getBlue());
        }
        if ((intPref = Preferences.getInt("Preferences.TimeLine.HorScrollSpeed", null)) != null) {
            this.origScrollSpeed = intPref;
            if (this.origScrollSpeed < 5) {
                this.origScrollSpeed = 5;
            } else if (this.origScrollSpeed > 50) {
                this.origScrollSpeed = 50;
            }
        }
    }

    private void readViewerPref() {
        for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
            if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
            SelectEnableObject seo = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
            boolean bool = this.getPrefValue((String)seo.getValue());
            seo.setSelected(bool);
            ((SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 0)).setSelected(!bool);
        }
    }

    private String getRefValue(String viewer) {
        String val = null;
        if (viewer.equals(this.GRID_VIEWER)) {
            val = "PreferencesDialog.Viewer.Grid.Right";
        } else if (viewer.equals(this.TEXT_VIEWER)) {
            val = "PreferencesDialog.Viewer.Text.Right";
        } else if (viewer.equals(this.SUBTITLE_VIEWER)) {
            val = "PreferencesDialog.Viewer.Subtitle.Right";
        } else if (viewer.equals(this.LEXICON_VIEWER)) {
            val = "PreferencesDialog.Viewer.Lexicon.Right";
        } else if (viewer.equals(this.COMMENT_VIEWER)) {
            val = "PreferencesDialog.Viewer.Comment.Right";
        } else if (viewer.equals(this.RECOGNIZER)) {
            val = "PreferencesDialog.Viewer.Audio.Right";
        } else if (viewer.equals(this.METADATA_VIEWER)) {
            val = "PreferencesDialog.Viewer.MetaData.Right";
        }
        return val;
    }

    private boolean getPrefValue(String viewer) {
        boolean bool = true;
        Boolean val = Preferences.getBool(this.getRefValue(viewer), null);
        if (val != null) {
            bool = val;
        }
        return bool;
    }

    private void initComponents() {
        JPanel subtitlePanel = new JPanel(new GridBagLayout());
        JLabel numLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.NumSubtitles"));
        Font plainFont = numLabel.getFont().deriveFont(0);
        numLabel.setFont(plainFont);
        this.numSubCB = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
        this.numSubCB.setFont(plainFont);
        this.numSubCB.setSelectedItem(this.origNumSubtitles);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.topInset;
        subtitlePanel.add((Component)numLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        subtitlePanel.add((Component)this.numSubCB, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        subtitlePanel.add((Component)new JPanel(), gbc);
        this.tierOrderInDropdownCB = new JCheckBox(ElanLocale.getString("PreferencesDialog.Viewer.OrderAlphabetically"));
        this.tierOrderInDropdownCB.setFont(this.tierOrderInDropdownCB.getFont().deriveFont(0));
        this.tierOrderInDropdownCB.setSelected(this.origTierOrderInDropdownCB);
        this.aaBoldCB = new JCheckBox(ElanLocale.getString("TimeLineViewer.ActiveAnnotationBold"));
        this.aaBoldCB.setFont(this.aaBoldCB.getFont().deriveFont(0));
        this.aaBoldCB.setSelected(this.origActiveAnnBold);
        this.redTierHeightCB = new JCheckBox(ElanLocale.getString("TimeLineViewer.ReducedTierHeight"));
        this.redTierHeightCB.setFont(plainFont);
        this.redTierHeightCB.setSelected(this.origReducedTierHeight);
        SpinnerNumberModel spinModel = new SpinnerNumberModel(this.origScrollSpeed, 5, 50, 5);
        this.scrollSpeedSpinner = new JSpinner(spinModel);
        JLabel scrollLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.HorizontalScrollSpeed"));
        scrollLabel.setFont(plainFont);
        JPanel scrollSpeedPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.topInset;
        scrollSpeedPanel.add((Component)scrollLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        scrollSpeedPanel.add((Component)this.scrollSpeedSpinner, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        scrollSpeedPanel.add((Component)new JPanel(), gbc);
        this.colorTextLabel = new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.ColorTextLabel"));
        this.colorTextLabel.setFont(plainFont);
        this.colorButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.colorButton.addActionListener(this);
        this.resetColorButton = new JButton(ElanLocale.getString("Button.Default"));
        this.resetColorButton.addActionListener(this);
        this.colorPreviewPanel = new JPanel();
        this.colorPreviewPanel.setBorder(new LineBorder(Color.GRAY, 1));
        this.colorPreviewPanel.setPreferredSize(new Dimension(this.colorButton.getPreferredSize().height - 5, this.colorButton.getPreferredSize().height - 5));
        this.colorPreviewPanel.setMinimumSize(new Dimension(this.colorButton.getPreferredSize().height - 5, this.colorButton.getPreferredSize().height - 5));
        this.colorPreviewPanel.setBackground(this.origSymAnnColor);
        JPanel colorPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.topInset;
        colorPanel.add((Component)this.colorTextLabel, gbc);
        gbc.gridx = 1;
        gbc.insets = this.leftInset;
        colorPanel.add((Component)this.colorPreviewPanel, gbc);
        gbc.gridx = 2;
        colorPanel.add((Component)this.colorButton, gbc);
        gbc.gridx = 3;
        colorPanel.add((Component)this.resetColorButton, gbc);
        gbc.gridx = 4;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        colorPanel.add((Component)new JPanel(), gbc);
        String columnHeader1 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.LeftofVideo");
        String columnHeader2 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.RightofVideo");
        String columnHeader3 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.MoveUp");
        String columnHeader4 = ElanLocale.getString("PreferencesDialog.Viewer.ColumnHeader.MoveDown");
        DefaultTableModel dm = new DefaultTableModel();
        dm.setColumnIdentifiers(new String[]{columnHeader1, columnHeader2, columnHeader3, columnHeader4});
        this.viewerTable = new JTable(dm);
        this.viewerTable.setFont(this.viewerTable.getFont().deriveFont(0));
        this.viewerTable.getColumn(columnHeader1).setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(columnHeader1).setCellRenderer(new RadioButtonTableCellRenderer());
        this.viewerTable.getColumn(columnHeader2).setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(columnHeader2).setCellRenderer(new RadioButtonTableCellRenderer());
        this.viewerTable.getColumn(columnHeader3).setCellRenderer(new ButtonTableCellRenderer());
        this.viewerTable.getColumn(columnHeader3).setCellEditor(new ButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(columnHeader3).setMaxWidth(70);
        this.viewerTable.getColumn(columnHeader4).setCellRenderer(new ButtonTableCellRenderer());
        this.viewerTable.getColumn(columnHeader4).setCellEditor(new ButtonCellEditor(new JCheckBox()));
        this.viewerTable.getColumn(columnHeader4).setMaxWidth(70);
        this.viewerTable.setGridColor(Color.BLACK);
        this.viewerTable.setRowHeight(20);
        this.viewerTable.addMouseListener(this);
        ImageIcon upIcon = null;
        ImageIcon downIcon = null;
        String upButtonLabel = null;
        String downButtonLabel = null;
        try {
            upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        }
        catch (Exception ex) {
            upButtonLabel = "Up";
            downButtonLabel = "Down";
        }
        for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
            SelectEnableObject<String> leftObj = new SelectEnableObject<String>(this.viewerSortOrder.get(i), false, false);
            SelectEnableObject<String> rightObj = new SelectEnableObject<String>(this.viewerSortOrder.get(i), true, true);
            this.upButton = new JButton();
            this.downButton = new JButton();
            this.upButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Viewer.SortButtonToolTip"));
            this.downButton.setToolTipText(ElanLocale.getString("PreferencesDialog.Viewer.SortButtonToolTip"));
            if (upIcon != null && downIcon != null) {
                this.upButton.setIcon(upIcon);
                this.downButton.setIcon(downIcon);
            } else {
                this.upButton.setText(upButtonLabel);
                this.downButton.setText(downButtonLabel);
            }
            dm.addRow(new Object[]{leftObj, rightObj, this.upButton, this.downButton});
        }
        int gy = 0;
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridy = gy++;
        gbc.insets = this.globalPanelInset;
        this.outerPanel.add((Component)scrollSpeedPanel, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)colorPanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("TimeLineViewer.Name")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.aaBoldCB, gbc);
        gbc.gridy = gy++;
        this.outerPanel.add((Component)this.redTierHeightCB, gbc);
        gbc.insets = this.catInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.TierOrderInDropdowns")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        this.outerPanel.add((Component)this.tierOrderInDropdownCB, gbc);
        gbc.insets = this.catInset;
        gbc.gridy = gy++;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("Tab.Subtitles")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catPanelInset;
        this.outerPanel.add((Component)subtitlePanel, gbc);
        gbc.gridy = gy++;
        gbc.insets = this.catInset;
        this.outerPanel.add((Component)new JLabel(ElanLocale.getString("PreferencesDialog.Viewer.Label.Video")), gbc);
        gbc.gridy = gy++;
        gbc.insets = this.globalInset;
        JScrollPane scrollPane = new JScrollPane(this.viewerTable);
        scrollPane.setPreferredSize(new Dimension(scrollPane.getPreferredSize().width, this.viewerTable.getPreferredSize().height + 20));
        this.outerPanel.add((Component)scrollPane, gbc);
        gbc.gridy = gy++;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.outerPanel.add((Component)new JPanel(), gbc);
        this.updateViewerSelectionInTable();
    }

    @Override
    public Map<String, Object> getChangedPreferences() {
        if (this.isChanged()) {
            int curScrollSpeed;
            HashMap<String, Object> chMap = new HashMap<String, Object>(1);
            if (this.origNumSubtitles != (Integer)this.numSubCB.getSelectedItem()) {
                chMap.put("NumberOfSubtitleViewers", this.numSubCB.getSelectedItem());
            }
            if (this.origActiveAnnBold != this.aaBoldCB.isSelected()) {
                chMap.put("TimeLineViewer.ActiveAnnotationBold", this.aaBoldCB.isSelected());
            }
            if (this.origTierOrderInDropdownCB != this.tierOrderInDropdownCB.isSelected()) {
                chMap.put("SingleTierViewer.TierOrderInDropdown", this.tierOrderInDropdownCB.isSelected());
            }
            if (this.origReducedTierHeight != this.redTierHeightCB.isSelected()) {
                chMap.put("TimeLineViewer.ReducedTierHeight", this.redTierHeightCB.isSelected());
            }
            if (this.videoInCentre) {
                for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                    if (!(this.viewerTable.getModel().getValueAt(x, 0) instanceof SelectEnableObject)) continue;
                    SelectEnableObject seo = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
                    String refValue = this.getRefValue((String)seo.getValue());
                    chMap.put(refValue, seo.isSelected());
                }
            }
            if (this.symAnnColor != this.origSymAnnColor) {
                chMap.put("Preferences.SymAnnColor", new Color(this.symAnnColor.getRed(), this.symAnnColor.getGreen(), this.symAnnColor.getBlue()));
            }
            if (this.sortOrderChanged) {
                chMap.put("PreferencesDialog.Viewer.SortOrder", this.getNewViewerSortOrder());
            }
            if ((curScrollSpeed = ((Integer)this.scrollSpeedSpinner.getValue()).intValue()) != this.origScrollSpeed) {
                chMap.put("Preferences.TimeLine.HorScrollSpeed", curScrollSpeed);
            }
            return chMap;
        }
        return null;
    }

    @Override
    public boolean isChanged() {
        int count = (Integer)this.numSubCB.getSelectedItem();
        List<String> newSortOrder = this.getNewViewerSortOrder();
        for (int i = 0; i < this.viewerSortOrder.size(); ++i) {
            if (this.viewerSortOrder.get(i).equals(newSortOrder.get(i))) continue;
            this.sortOrderChanged = true;
            return true;
        }
        if (count != this.origNumSubtitles) {
            return true;
        }
        if (this.origActiveAnnBold != this.aaBoldCB.isSelected()) {
            return true;
        }
        if (this.origTierOrderInDropdownCB != this.tierOrderInDropdownCB.isSelected()) {
            return true;
        }
        if (this.origReducedTierHeight != this.redTierHeightCB.isSelected()) {
            return true;
        }
        if (this.videoInCentre) {
            return true;
        }
        if (this.origSymAnnColor != this.symAnnColor) {
            return true;
        }
        int curScrollSpeed = (Integer)this.scrollSpeedSpinner.getValue();
        return curScrollSpeed != this.origScrollSpeed && curScrollSpeed >= 5 && curScrollSpeed <= 50;
    }

    private List<String> getNewViewerSortOrder() {
        ArrayList<String> newSortOrder = new ArrayList<String>();
        for (int row = 0; row < this.viewerTable.getRowCount(); ++row) {
            newSortOrder.add((String)((SelectEnableObject)this.viewerTable.getModel().getValueAt(row, 0)).getValue());
        }
        return newSortOrder;
    }

    public void updateVideoInCentre(Boolean val) {
        if (val != this.videoInCentre) {
            this.videoInCentre = val;
            this.updateViewerSelectionInTable();
        }
    }

    private void updateViewerSelectionInTable() {
        if (!this.videoInCentre) {
            for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                Object value = this.viewerTable.getModel().getValueAt(x, 0);
                if (!(value instanceof SelectEnableObject)) continue;
                SelectEnableObject leftRB = (SelectEnableObject)value;
                SelectEnableObject rightRB = (SelectEnableObject)this.viewerTable.getModel().getValueAt(x, 1);
                leftRB.setEnabled(false);
                leftRB.setSelected(false);
                rightRB.setEnabled(true);
                rightRB.setSelected(true);
            }
        } else {
            this.readViewerPref();
            for (int x = 0; x < this.viewerTable.getRowCount(); ++x) {
                Object value = this.viewerTable.getModel().getValueAt(x, 0);
                if (!(value instanceof SelectEnableObject)) continue;
                SelectEnableObject rb = (SelectEnableObject)value;
                rb.setEnabled(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.viewerTable.getSelectedRow();
        if (this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex = this.viewerTable.getSelectedColumn()) instanceof JButton) {
            TableModel model = this.viewerTable.getModel();
            if (selectedColumnIndex == 2) {
                Object row1 = model.getValueAt(selectedRowIndex, 0);
                Object row11 = model.getValueAt(selectedRowIndex, 1);
                if (selectedRowIndex > 0) {
                    Object row2 = model.getValueAt(selectedRowIndex - 1, 0);
                    Object row21 = model.getValueAt(selectedRowIndex - 1, 1);
                    model.setValueAt(row1, selectedRowIndex - 1, 0);
                    model.setValueAt(row11, selectedRowIndex - 1, 1);
                    model.setValueAt(row2, selectedRowIndex, 0);
                    model.setValueAt(row21, selectedRowIndex, 1);
                }
            } else if (selectedColumnIndex == 3) {
                Object row1 = model.getValueAt(selectedRowIndex, 0);
                Object row11 = model.getValueAt(selectedRowIndex, 1);
                if (selectedRowIndex < this.viewerTable.getRowCount() - 1) {
                    Object row2 = model.getValueAt(selectedRowIndex + 1, 0);
                    Object row21 = model.getValueAt(selectedRowIndex + 1, 1);
                    model.setValueAt(row1, selectedRowIndex + 1, 0);
                    model.setValueAt(row11, selectedRowIndex + 1, 1);
                    model.setValueAt(row2, selectedRowIndex, 0);
                    model.setValueAt(row21, selectedRowIndex, 1);
                }
            }
        }
        this.viewerTable.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int selectedColumnIndex;
        int selectedRowIndex = this.viewerTable.getSelectedRow();
        if (this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex = this.viewerTable.getSelectedColumn()) instanceof SelectEnableObject) {
            SelectEnableObject seo1 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, selectedColumnIndex);
            if (seo1.isSelected()) {
                SelectEnableObject seo2 = null;
                if (selectedColumnIndex == 0) {
                    seo2 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, 1);
                } else if (selectedColumnIndex == 1) {
                    seo2 = (SelectEnableObject)this.viewerTable.getValueAt(selectedRowIndex, 0);
                }
                if (seo2 != null && seo2.isEnabled()) {
                    seo2.setSelected(false);
                }
            } else {
                seo1.setSelected(true);
            }
        }
        this.viewerTable.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color newColor = null;
        if (e.getSource() == this.colorButton) {
            this.dialog = new ColorDialog(this, this.origSymAnnColor);
            newColor = this.dialog.chooseColor();
            if (newColor != null) {
                this.symAnnColor = newColor;
                this.colorPreviewPanel.setBackground(this.symAnnColor);
            }
        } else if (e.getSource() == this.resetColorButton) {
            this.colorPreviewPanel.setBackground(Constants.SHAREDCOLOR1);
        }
    }
}

