/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.api.RecognizerHost;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.XMLEscape;

public class LocalRecognizer
implements Recognizer {
    protected RecognizerHost host;
    protected String runCommand;
    protected List<Param> paramList;
    protected List<String> mediaPaths;
    protected String name;
    protected String id;
    protected int recognizerType;
    protected File baseDir;
    protected Process process;
    protected OutputStream outStream;
    protected InputStream inStream;
    protected BufferedReader reader;
    protected boolean isRunning = false;
    protected long lastStartTime = 0L;
    protected volatile long lastReadSucces = 0L;

    public LocalRecognizer() {
    }

    public LocalRecognizer(String runCommand) {
        this.runCommand = runCommand;
    }

    public void setParamList(List<Param> paramList) {
        this.paramList = paramList;
    }

    @Override
    public boolean canCombineMultipleFiles() {
        if (this.paramList == null || this.paramList.isEmpty()) {
            return false;
        }
        int numAudio = 0;
        int numVideo = 0;
        for (Param p : this.paramList) {
            if (!(p instanceof FileParam)) continue;
            FileParam fp = (FileParam)p;
            if (fp.ioType == 'i' && fp.contentType == 0) {
                ++numAudio;
                continue;
            }
            if (fp.ioType != 'i' || fp.contentType != 1) continue;
            ++numVideo;
        }
        return numAudio + numVideo > 1;
    }

    @Override
    public boolean setMedia(List<String> mediaFilePaths) {
        return false;
    }

    @Override
    public boolean canHandleMedia(String mediaFilePath) {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public JPanel getControlPanel() {
        return null;
    }

    @Override
    public void validateParameters() throws RecognizerConfigurationException {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getParameterValue(String param) {
        if (param == null) {
            return null;
        }
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof NumParam) {
                    if (((NumParam)p).current > Float.MIN_VALUE) {
                        return new Float(((NumParam)p).current);
                    }
                    return new Float(((NumParam)p).def);
                }
                if (p instanceof TextParam) {
                    String val = ((TextParam)p).curValue;
                    if (val == null) {
                        return ((TextParam)p).defValue;
                    }
                    return val;
                }
                if (!(p instanceof FileParam)) continue;
                return ((FileParam)p).filePath;
            }
        }
        return null;
    }

    @Override
    public int getRecognizerType() {
        return this.recognizerType;
    }

    public void setRecognizerType(int type) {
        this.recognizerType = type;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameterValue(String param, String value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (p instanceof TextParam) {
                    ((TextParam)p).curValue = value;
                    break;
                }
                if (!(p instanceof FileParam)) break;
                ((FileParam)p).filePath = value;
                break;
            }
        }
    }

    @Override
    public void setParameterValue(String param, float value) {
        if (this.paramList != null && !this.paramList.isEmpty()) {
            for (Param p : this.paramList) {
                if (p.id == null || !p.id.equals(param)) continue;
                if (!(p instanceof NumParam)) break;
                ((NumParam)p).current = value;
                break;
            }
        }
    }

    @Override
    public void setRecognizerHost(RecognizerHost host) {
        this.host = host;
    }

    @Override
    public void start() {
        if (this.runCommand == null || this.runCommand.length() == 0) {
            if (this.host != null) {
                ClientLogger.LOG.severe("No run command found");
                this.host.errorOccurred("No run command found");
            }
            return;
        }
        try {
            this.isRunning = true;
            this.host.setProgress(-1.0f);
            this.lastStartTime = System.currentTimeMillis() / 1000L * 1000L;
            StringTokenizer tokenizer = new StringTokenizer(this.runCommand);
            ArrayList<String> cmds = new ArrayList<String>();
            while (tokenizer.hasMoreTokens()) {
                cmds.add(tokenizer.nextToken());
            }
            ProcessBuilder pBuilder = new ProcessBuilder(cmds);
            pBuilder.redirectErrorStream(true);
            pBuilder.directory(this.baseDir);
            ClientLogger.LOG.info("Setting directory: " + this.baseDir);
            this.process = pBuilder.start();
            ClientLogger.LOG.info("Created process... command: " + this.runCommand);
            this.reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            new ReaderThread().start();
            XMLEscape xmlEscape = new XMLEscape();
            PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream())), true);
            if (this.paramList != null && this.paramList.size() > 0) {
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<PARAM xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"file:avatech-call.xsd\">");
                String timestamp = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ssZ").format(new Date());
                writer.print("<param name=\"InvocationContext\">");
                writer.print(this.id != null ? xmlEscape.escape(this.id) : "Unknown");
                writer.print(" " + timestamp);
                writer.println("</param>");
                for (Param p : this.paramList) {
                    String path;
                    writer.print("<param name=\"" + p.id + "\">");
                    if (p instanceof NumParam) {
                        writer.print(((NumParam)p).current);
                    } else if (p instanceof TextParam) {
                        String value = ((TextParam)p).curValue;
                        if (value == null) {
                            value = ((TextParam)p).defValue;
                        }
                        if (value != null && value.length() > 0) {
                            writer.print(xmlEscape.escape(value));
                        }
                    } else if (p instanceof FileParam && (path = ((FileParam)p).filePath) != null) {
                        if (path.startsWith("file:")) {
                            path = path.substring(5);
                        }
                        if (path.length() > 5 && path.substring(0, 5).matches("///[a-zA-Z]:")) {
                            path = path.substring(3).replace('/', '\\');
                        }
                        writer.print(xmlEscape.escape(path));
                    }
                    writer.println("</param>");
                }
                writer.println("</PARAM>");
            }
            writer.close();
        }
        catch (IOException ioe) {
            String msg = "Could not run the recognizer: " + ioe.getMessage();
            ClientLogger.LOG.severe(msg);
            this.host.appendToReport(msg + "\n");
            this.host.errorOccurred(msg);
        }
    }

    @Override
    public void stop() {
        if (this.isRunning && this.process != null) {
            ClientLogger.LOG.info("Stopping recognizer...");
            this.process.destroy();
            this.isRunning = false;
            this.convertTiers();
        }
    }

    protected void convertTiers() {
    }

    @Override
    public void updateLocale(Locale locale) {
    }

    @Override
    public void updateLocaleBundle(ResourceBundle bundle) {
    }

    public String getRunCommand() {
        return this.runCommand;
    }

    public void setRunCommand(String runCommand) {
        this.runCommand = runCommand;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    class ReaderThread
    extends Thread {
        private final String DONE = "RESULT: DONE.";
        private final String FAIL = "RESULT: FAILED.";
        private final String PROG = "PROGRESS:";
        private final String PROG2 = "INFO: PROGRESS:";
        private float lastProg = -1.0f;

        ReaderThread() {
        }

        private float convertToFloat(String progValue) {
            float prog = -1.0f;
            try {
                if (progValue.endsWith("%")) {
                    prog = Float.parseFloat(progValue.substring(0, progValue.length() - 1));
                    prog /= 100.0f;
                } else {
                    prog = Float.parseFloat(progValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return prog;
        }

        @Override
        public void run() {
            while (LocalRecognizer.this.isRunning && LocalRecognizer.this.reader != null) {
                try {
                    String line = LocalRecognizer.this.reader.readLine();
                    if (line != null) {
                        LocalRecognizer.this.lastReadSucces = System.currentTimeMillis();
                        LocalRecognizer.this.host.appendToReport(line + "\n");
                        if (line.equals("RESULT: DONE.")) {
                            LocalRecognizer.this.convertTiers();
                            LocalRecognizer.this.host.setProgress(1.0f);
                            break;
                        }
                        if (line.equals("RESULT: FAILED.")) {
                            ClientLogger.LOG.warning("Recognizer failed...");
                            LocalRecognizer.this.host.errorOccurred("Recognizer failed.");
                            break;
                        }
                        if (line.startsWith("PROGRESS:") || line.startsWith("INFO: PROGRESS:")) {
                            int colIndex = line.indexOf(58);
                            if (line.startsWith("INFO: PROGRESS:")) {
                                colIndex = line.indexOf(58, colIndex);
                            }
                            String message = null;
                            float prog = -1.0f;
                            if (colIndex >= line.length() - 2) continue;
                            String remains = line.substring(colIndex + 1).trim();
                            int space = remains.indexOf(32);
                            if (space > -1) {
                                prog = this.convertToFloat(remains.substring(0, space));
                                if (space < remains.length() - 1) {
                                    message = remains.substring(space).trim();
                                }
                            } else {
                                prog = this.convertToFloat(remains);
                            }
                            if (prog > this.lastProg) {
                                this.lastProg = prog;
                            } else {
                                prog = this.lastProg;
                            }
                            LocalRecognizer.this.host.setProgress(prog, message);
                            continue;
                        }
                        if (line.length() != 1) continue;
                        if (line.charAt(0) == '\u0004') {
                            ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                            LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                            LocalRecognizer.this.host.appendToReport("Recognizer failed, end of transmission.\n");
                            break;
                        }
                        try {
                            int eof = Integer.parseInt(line);
                            if (eof == -1) {
                                ClientLogger.LOG.warning("Recognizer failed... end of transmission");
                                LocalRecognizer.this.host.errorOccurred("Recognizer failed, end of transmission.");
                                LocalRecognizer.this.host.appendToReport("Recognizer failed, end of transmission.\n");
                                break;
                            }
                            if (eof != 0) continue;
                            ClientLogger.LOG.info("Recognizer terminated successfully, but did not send the corresponding RESULT code");
                            LocalRecognizer.this.host.appendToReport("Recognizer terminated successfully...\n");
                            LocalRecognizer.this.host.setProgress(1.0f);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    ClientLogger.LOG.warning("Recognizer stopped; unexpected end of transmission.");
                    LocalRecognizer.this.host.errorOccurred("Recognizer stopped; unexpected end of transmission.");
                    LocalRecognizer.this.host.appendToReport("Recognizer stopped; unexpected end of transmission.\n");
                    break;
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.info("Exception while reading the recognizer output: " + ioe.getMessage());
                }
            }
            if (LocalRecognizer.this.reader != null) {
                try {
                    LocalRecognizer.this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LocalRecognizer.this.isRunning = false;
        }
    }
}

