/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.api;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.recognizer.api.LocalRecognizer;
import mpi.eudico.client.annotator.recognizer.api.Recognizer;
import mpi.eudico.client.annotator.recognizer.api.SharedRecognizer;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.load.RecognizerBundle;
import mpi.eudico.client.annotator.recognizer.load.RecognizerLoader;
import mpi.eudico.client.annotator.recognizer.load.RecognizerParser;
import mpi.eudico.client.annotator.recognizer.silence.SilenceRecognizer;
import mpi.eudico.client.annotator.util.AvailabilityDetector;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.SAXException;

public class RecogAvailabilityDetector {
    private static Map<String, RecognizerBundle> audioRecognizerBundles = new HashMap<String, RecognizerBundle>(6);
    private static Map<String, RecognizerBundle> videoRecognizerBundles = new HashMap<String, RecognizerBundle>(6);
    private static Map<String, RecognizerBundle> otherRecognizerBundles = new HashMap<String, RecognizerBundle>(6);
    private static RecognizerLoader recognizerLoader;

    private RecogAvailabilityDetector() {
    }

    private static void addFromBundle(Map<String, Recognizer> map, Map<String, RecognizerBundle> bundles, int type) {
        for (String key : bundles.keySet()) {
            RecognizerBundle bundle = bundles.get(key);
            if (bundle.getRecExecutionType().equals("local")) {
                LocalRecognizer localRecognizer = new LocalRecognizer(bundle.getRecognizerClass());
                localRecognizer.setParamList(bundle.getParamList());
                localRecognizer.setName(bundle.getName());
                localRecognizer.setId(bundle.getId());
                localRecognizer.setRecognizerType(type);
                localRecognizer.setBaseDir(bundle.getBaseDir());
                map.put(key, localRecognizer);
                continue;
            }
            if (bundle.getRecExecutionType().equals("shared")) {
                SharedRecognizer sharedRecognizer = new SharedRecognizer(bundle.getRecognizerClass());
                sharedRecognizer.setParamList(bundle.getParamList());
                sharedRecognizer.setName(bundle.getName());
                sharedRecognizer.setId(bundle.getId());
                sharedRecognizer.setRecognizerType(type);
                sharedRecognizer.setBaseDir(bundle.getBaseDir());
                map.put(key, sharedRecognizer);
                continue;
            }
            if (bundle.getJavaLibs() != null) {
                if (recognizerLoader == null) {
                    recognizerLoader = new RecognizerLoader(bundle.getJavaLibs(), bundle.getNativeLibs());
                } else {
                    recognizerLoader.addLibs(bundle.getJavaLibs());
                    recognizerLoader.addNativeLibs(bundle.getNativeLibs());
                }
                try {
                    Recognizer rec = (Recognizer)Class.forName(bundle.getRecognizerClass(), true, recognizerLoader).newInstance();
                    rec.setName(bundle.getName());
                    map.put(key, rec);
                }
                catch (ClassNotFoundException cnfe) {
                    ClientLogger.LOG.severe("Cannot load the recognizer class: " + bundle.getRecognizerClass() + " - Class not found");
                }
                catch (InstantiationException ie) {
                    ClientLogger.LOG.severe("Cannot instantiate the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (IllegalAccessException iae) {
                    ClientLogger.LOG.severe("Cannot access the recognizer class: " + bundle.getRecognizerClass());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.severe("Cannot load the recognizer: " + bundle.getRecognizerClass() + " - " + ex.getMessage());
                }
                continue;
            }
            ClientLogger.LOG.severe("Cannot load the recognizer: no Java library has been found: " + bundle.getName());
        }
    }

    public static Map<String, Recognizer> getAudioRecognizers() {
        AvailabilityDetector.loadFilesFromExtensionsFolder();
        HashMap<String, Recognizer> audioRecs = new HashMap<String, Recognizer>(6);
        SilenceRecognizer sr = new SilenceRecognizer();
        audioRecs.put(sr.getName(), sr);
        RecogAvailabilityDetector.addFromBundle(audioRecs, audioRecognizerBundles, 0);
        return audioRecs;
    }

    public static Map<String, Recognizer> getVideoRecognizers() {
        AvailabilityDetector.loadFilesFromExtensionsFolder();
        HashMap<String, Recognizer> videoRecs = new HashMap<String, Recognizer>(5);
        RecogAvailabilityDetector.addFromBundle(videoRecs, videoRecognizerBundles, 1);
        return videoRecs;
    }

    public static Map<String, Recognizer> getOtherRecognizers() {
        AvailabilityDetector.loadFilesFromExtensionsFolder();
        HashMap<String, Recognizer> otherRecs = new HashMap<String, Recognizer>(3);
        RecogAvailabilityDetector.addFromBundle(otherRecs, otherRecognizerBundles, 2);
        return otherRecs;
    }

    public static List<Param> getParamList(String recognizerName) {
        if (recognizerName != null) {
            RecognizerBundle bundle = RecogAvailabilityDetector.getBundle(recognizerName);
            List<Param> params = null;
            if (bundle != null) {
                params = bundle.getParamList();
            }
            if (params != null) {
                ArrayList<Param> copyList = new ArrayList<Param>(params.size());
                for (Param p : params) {
                    if (p == null) continue;
                    try {
                        copyList.add((Param)p.clone());
                    }
                    catch (CloneNotSupportedException cnse) {
                        ClientLogger.LOG.warning("Cannot clone a parameter: " + p.id);
                    }
                }
                return copyList;
            }
        }
        return null;
    }

    private static RecognizerBundle getBundle(String name) {
        RecognizerBundle result = null;
        if (result == null && audioRecognizerBundles != null) {
            result = audioRecognizerBundles.get(name);
        }
        if (result == null && videoRecognizerBundles != null) {
            result = videoRecognizerBundles.get(name);
        }
        if (result == null && otherRecognizerBundles != null) {
            result = otherRecognizerBundles.get(name);
        }
        return result;
    }

    public static String getHelpFile(String recognizerName) {
        if (recognizerName != null) {
            RecognizerBundle bundle = RecogAvailabilityDetector.getBundle(recognizerName);
            String helpFile = null;
            if (bundle != null) {
                helpFile = bundle.getHelpFile();
            }
            if (helpFile == null && recognizerName.equals("Silence Recognizer MPI-PL")) {
                return "/mpi/eudico/client/annotator/resources/silence_recognizer.html";
            }
            return helpFile;
        }
        return null;
    }

    public static URL getIconURL(String recognizerName) {
        if (recognizerName != null) {
            RecognizerBundle bundle = RecogAvailabilityDetector.getBundle(recognizerName);
            URL icon = null;
            if (bundle != null) {
                icon = bundle.getIconURL();
            }
            if (bundle == null) {
                return RecogAvailabilityDetector.class.getResource("/mpi/eudico/client/annotator/resources/ELAN16.png");
            }
            return icon;
        }
        return null;
    }

    public static void createBundle(InputStream mdStream, URL[] libs, URL[] natLibs, File baseDir) {
        boolean isDetector = false;
        String binaryName = null;
        RecognizerBundle bundle = null;
        RecognizerParser parser = null;
        try {
            parser = new RecognizerParser(mdStream);
            parser.parse();
            if (parser.getRecognizerType() == null || !parser.getRecognizerType().equals("direct") && !parser.getRecognizerType().equals("local") && !parser.getRecognizerType().equals("shared")) {
                ClientLogger.LOG.warning("Unsupported recognizer type, should be 'direct', 'local' or 'shared': " + parser.getRecognizerType());
                return;
            }
            if (!parser.isCurOsSupported()) {
                ClientLogger.LOG.warning("Recognizer does not support this Operating System: " + parser.getRecognizerName());
                return;
            }
            if (parser.getImplementor() == null) {
                ClientLogger.LOG.warning("The implementing class name has not been specified.");
                return;
            }
            isDetector = true;
            binaryName = parser.getImplementor();
        }
        catch (SAXException sax) {
            ClientLogger.LOG.severe("Cannot parse metadata file: " + sax.getMessage());
        }
        if (isDetector) {
            boolean audio = false;
            boolean video = false;
            List<Param> paramList = parser.getParamList();
            if (paramList != null) {
                RecogAvailabilityDetector.validateParamList(paramList);
                for (Param par : paramList) {
                    if (!(par instanceof FileParam) || ((FileParam)par).ioType != 'i') continue;
                    if (((FileParam)par).contentType == 0) {
                        audio = true;
                        continue;
                    }
                    if (((FileParam)par).contentType != 1) continue;
                    video = true;
                }
            }
            if (parser.getRecognizerType().equals("direct")) {
                if (libs == null) {
                    return;
                }
                RecognizerLoader loader = new RecognizerLoader(libs, natLibs);
                if (binaryName != null) {
                    try {
                        Class<?> c = loader.loadClass(binaryName);
                        bundle = new RecognizerBundle();
                        bundle.setRecognizerClass(binaryName);
                        bundle.setJavaLibs(libs);
                        bundle.setNativeLibs(natLibs);
                    }
                    catch (ClassNotFoundException cne) {
                        ClientLogger.LOG.severe("Cannot load the recognizer class: " + binaryName + " - Class not found");
                    }
                } else {
                    ClientLogger.LOG.warning("Cannot load the recognizer class: Class not found");
                }
            } else if (parser.getRecognizerType().equals("local") || parser.getRecognizerType().equals("shared")) {
                bundle = new RecognizerBundle();
                bundle.setRecognizerClass(binaryName);
            }
            if (bundle != null) {
                bundle.setId(parser.getRecognizerName());
                bundle.setName(parser.getDescription());
                bundle.setParamList(paramList);
                bundle.setRecExecutionType(parser.getRecognizerType());
                bundle.setBaseDir(baseDir);
                bundle.setHelpFile(parser.getHelpFile());
                bundle.setIconRef(parser.getIconRef());
                if (video) {
                    videoRecognizerBundles.put(bundle.getName(), bundle);
                } else if (audio) {
                    audioRecognizerBundles.put(bundle.getName(), bundle);
                } else {
                    otherRecognizerBundles.put(bundle.getName(), bundle);
                }
            }
        }
    }

    private static void validateParamList(List<Param> paramList) {
        int n = 0;
        while (n < paramList.size()) {
            Param par = paramList.get(n);
            if (par.info == null) {
                paramList.remove(par);
                continue;
            }
            if (par instanceof NumParam) {
                if (!(((NumParam)par).min < ((NumParam)par).max)) {
                    paramList.remove(par);
                    continue;
                }
            } else if (par instanceof FileParam && ((FileParam)par).contentType < 0) {
                paramList.remove(par);
                continue;
            }
            ++n;
        }
    }
}

