/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.gui.AbstractParamPanel;

public class NumParamPanel
extends AbstractParamPanel
implements ChangeListener,
ActionListener,
FocusListener {
    private float min;
    private float max;
    private float initial;
    private int decPrecision = 1;
    private JSlider slider;
    private JTextField valueField;
    private int scale = 100000;
    private DecimalFormat decFormat;
    private String type;

    public NumParamPanel(String paramName, String description, float min, float max, float initial, int precision) {
        this(paramName, description, min, max, initial, precision, NumParam.FLOAT);
    }

    public NumParamPanel(String paramName, String description, float min, float max, float initial, int precision, String type) {
        super(paramName, description);
        this.min = min;
        this.max = max;
        if (this.min > this.max) {
            float tmp = this.max;
            this.max = this.min;
            this.min = tmp;
        }
        this.initial = initial;
        this.type = type;
        this.decPrecision = precision;
        this.type = type;
        this.initComponents();
    }

    public NumParamPanel(NumParam param) {
        super(param);
        if (param != null) {
            this.min = param.min;
            this.max = param.max;
            if (this.min > this.max) {
                float tmp = this.max;
                this.max = this.min;
                this.min = tmp;
            }
            this.initial = param.def;
            this.decPrecision = param.precision;
            this.type = param.type;
            this.initComponents();
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        StringBuilder sb = new StringBuilder("#0.");
        for (int i = 0; i < this.decPrecision; ++i) {
            sb.append("0");
        }
        this.decFormat = new DecimalFormat(sb.toString(), new DecimalFormatSymbols(Locale.US));
        StringBuilder builder = new StringBuilder("<html><p>");
        builder.append(this.description);
        if (this.showParamNames) {
            builder.append(" <i>[" + this.paramName + "]</i>");
        }
        builder.append(" <i><small>");
        if (this.type.equals(NumParam.INT)) {
            builder.append(" (" + Math.round(this.min) + " - " + Math.round(this.max) + "; " + Math.round(this.initial) + ")");
        } else {
            builder.append(" (" + this.min + " - " + this.max + "; " + this.initial + ")");
        }
        builder.append("</small></i></p></html>");
        this.descLabel.setText(builder.toString());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 2;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(1, 1, 0, 1);
        this.slider = this.type.equals(NumParam.INT) ? new JSlider(Math.round(this.min), Math.round(this.max), Math.round(this.initial)) : new JSlider((int)(this.min * (float)this.scale), (int)(this.max * (float)this.scale), (int)(this.initial * (float)this.scale));
        this.add((Component)this.slider, gbc);
        this.slider.addChangeListener(this);
        this.valueField = new JTextField(8);
        if (this.type.equals(NumParam.INT)) {
            this.valueField.setText(String.valueOf(Math.round(this.initial)));
        } else {
            this.valueField.setText(String.valueOf(this.initial));
        }
        this.valueField.addActionListener(this);
        this.valueField.addFocusListener(this);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 0, 5);
        this.add((Component)this.valueField, gbc);
    }

    @Override
    protected Object getParamValue() {
        if (this.slider != null) {
            if (this.type.equals(NumParam.INT)) {
                return new Float(this.slider.getValue());
            }
            return new Float((float)this.slider.getValue() / (float)this.scale);
        }
        return null;
    }

    @Override
    protected void setParamValue(Object value) {
        if (value instanceof Float) {
            float nv = ((Float)value).floatValue();
            if (nv >= this.min && nv <= this.max) {
                this.initial = nv;
                if (this.slider != null) {
                    if (this.type.equals(NumParam.INT)) {
                        this.slider.setValue(Math.round(this.initial));
                    } else {
                        this.slider.setValue((int)(this.initial * (float)this.scale));
                    }
                }
            }
        } else if (value instanceof String) {
            try {
                float nv = Float.parseFloat((String)value);
                if (nv >= this.min && nv <= this.max) {
                    this.initial = nv;
                    if (this.slider != null) {
                        if (this.type.equals(NumParam.INT)) {
                            this.slider.setValue(Math.round(this.initial));
                        } else {
                            this.slider.setValue((int)(this.initial * (float)this.scale));
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            if (this.type.equals(NumParam.FLOAT)) {
                this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
            } else {
                this.valueField.setText(String.valueOf(this.slider.getValue()));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.valueField) {
            String v = this.valueField.getText();
            try {
                float fv = Float.parseFloat(v);
                if (fv < this.min) {
                    fv = this.min;
                }
                if (fv > this.max) {
                    fv = this.max;
                }
                if (this.type.equals(NumParam.INT)) {
                    this.slider.setValue(Math.round(fv));
                } else {
                    this.slider.setValue((int)(fv * (float)this.scale));
                }
            }
            catch (NumberFormatException nfe) {
                if (this.type.equals(NumParam.FLOAT)) {
                    this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
                }
                this.valueField.setText(String.valueOf(this.slider.getValue()));
            }
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.valueField) {
            String v = this.valueField.getText();
            try {
                float fv = Float.parseFloat(v);
                if (fv < this.min) {
                    fv = this.min;
                }
                if (fv > this.max) {
                    fv = this.max;
                }
                if (this.type.equals(NumParam.INT)) {
                    this.slider.setValue(Math.round(fv));
                } else {
                    this.slider.setValue((int)(fv * (float)this.scale));
                }
            }
            catch (NumberFormatException nfe) {
                if (this.type.equals(NumParam.FLOAT)) {
                    this.valueField.setText(this.decFormat.format((float)this.slider.getValue() / (float)this.scale));
                }
                this.valueField.setText(String.valueOf(this.slider.getValue()));
            }
        }
    }
}

