/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import mpi.eudico.client.annotator.timeseries.NonContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.TimeFormatter;

public class CsvTimeSeriesIO {
    private File csvFile;
    private final String SC = ";";
    private int numColumns = -1;

    public CsvTimeSeriesIO(File csvFile) {
        this.csvFile = csvFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getAllTracks() {
        int nc;
        if (this.numColumns == -1 && (nc = this.getNumTracks()) <= 0) {
            return null;
        }
        FileReader fileRead = null;
        try {
            int i;
            fileRead = new FileReader(this.csvFile);
            BufferedReader bufRead = new BufferedReader(fileRead);
            String line = null;
            ArrayList<String> tracknames = new ArrayList<String>(this.numColumns);
            int lineNum = 0;
            Pattern pat = Pattern.compile(";");
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            ArrayList trackData = new ArrayList(this.numColumns);
            ArrayList<float[]> ranges = new ArrayList<float[]>(this.numColumns);
            boolean[] prevWasNaN = new boolean[this.numColumns];
            Arrays.fill(prevWasNaN, false);
            for (i = 0; i < this.numColumns; ++i) {
                trackData.add(new ArrayList(100));
                ranges.add(new float[]{min, max});
            }
            while ((line = bufRead.readLine()) != null) {
                if (line.length() == 0) continue;
                String[] nextRow = pat.split(line);
                if (lineNum == 0) {
                    for (i = 1; i < nextRow.length; ++i) {
                        tracknames.add(nextRow[i]);
                    }
                    ++lineNum;
                    continue;
                }
                for (i = 1; i < nextRow.length && i <= this.numColumns; ++i) {
                    TimeValue tv = this.getTimeValue(nextRow[0], nextRow[i]);
                    if (tv == null) continue;
                    if (!Float.isNaN(tv.value)) {
                        if (prevWasNaN[i - 1]) {
                            tv = new TimeValueStart(tv.time, tv.value);
                        }
                        prevWasNaN[i - 1] = false;
                        ((List)trackData.get(i - 1)).add(tv);
                        float[] mm = (float[])ranges.get(i - 1);
                        if (tv.value < mm[0]) {
                            mm[0] = tv.value;
                        }
                        if (!(tv.value > mm[1])) continue;
                        mm[1] = tv.value;
                        continue;
                    }
                    prevWasNaN[i - 1] = true;
                }
            }
            try {
                bufRead.close();
            }
            catch (Exception i2) {
                // empty catch block
            }
            ArrayList<Object> tracks = new ArrayList<Object>(this.numColumns);
            for (int i3 = 0; i3 < trackData.size(); ++i3) {
                NonContinuousRateTSTrack tsTrack = new NonContinuousRateTSTrack((String)tracknames.get(i3), "");
                tsTrack.setData((List)trackData.get(i3));
                tsTrack.setDerivativeLevel(0);
                tsTrack.setSource(this.csvFile.getAbsolutePath());
                tsTrack.setType(11);
                tsTrack.setRange((float[])ranges.get(i3));
                tsTrack.setColor(Color.GREEN);
                tracks.add(tsTrack);
            }
            ArrayList<Object> arrayList = tracks;
            return arrayList;
        }
        catch (FileNotFoundException fnfe) {
            ClientLogger.LOG.warning("File not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("File could not be read: " + ioe.getMessage());
        }
        finally {
            try {
                if (fileRead != null) {
                    fileRead.close();
                }
            }
            catch (IOException fnfe) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTracks() {
        if (this.numColumns > -1) {
            return this.numColumns;
        }
        FileReader fileRead = null;
        try {
            fileRead = new FileReader(this.csvFile);
            BufferedReader bufRead = new BufferedReader(fileRead);
            String line = null;
            Pattern pat = Pattern.compile(";");
            while ((line = bufRead.readLine()) != null) {
                if (line.length() == 0) continue;
                String[] nextRow = pat.split(line);
                this.numColumns = nextRow.length - 1;
                if (nextRow.length <= 0 || nextRow[0].equals("")) break;
                ClientLogger.LOG.warning("First column name is not \"#timestamp\"");
                break;
            }
            try {
                bufRead.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (FileNotFoundException fnfe) {
            ClientLogger.LOG.warning("File not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("File could not be read: " + ioe.getMessage());
        }
        finally {
            try {
                if (fileRead != null) {
                    fileRead.close();
                }
            }
            catch (IOException fnfe) {}
        }
        if (this.numColumns > -1) {
            return this.numColumns;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTrack(int column) {
        if (column < 1 || column > this.numColumns) {
            return null;
        }
        FileReader fileRead = null;
        try {
            fileRead = new FileReader(this.csvFile);
            BufferedReader bufRead = new BufferedReader(fileRead);
            String line = null;
            String trackname = null;
            int lineNum = 0;
            Pattern pat = Pattern.compile(";");
            boolean prevWasNaN = false;
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            ArrayList<TimeValue> values = new ArrayList<TimeValue>(100);
            while ((line = bufRead.readLine()) != null) {
                TimeValue tv;
                if (line.length() == 0) continue;
                String[] nextRow = pat.split(line);
                if (lineNum == 0) {
                    trackname = nextRow[column];
                    ++lineNum;
                    continue;
                }
                if (nextRow.length > column) {
                    tv = this.getTimeValue(nextRow[0], nextRow[column]);
                    if (tv == null) continue;
                    if (!Float.isNaN(tv.value)) {
                        if (prevWasNaN) {
                            tv = new TimeValueStart(tv.time, tv.value);
                        }
                        prevWasNaN = false;
                        values.add(tv);
                        if (tv.value < min) {
                            min = tv.value;
                        }
                        if (!(tv.value > max)) continue;
                        max = tv.value;
                        continue;
                    }
                    prevWasNaN = true;
                    continue;
                }
                if (nextRow.length <= 0 || (tv = this.getTimeValue(nextRow[0], null)) == null || Float.isNaN(tv.value)) continue;
                if (prevWasNaN) {
                    tv = new TimeValueStart(tv.time, tv.value);
                }
                prevWasNaN = false;
                values.add(tv);
                if (tv.value < min) {
                    min = tv.value;
                }
                if (!(tv.value > max)) continue;
                max = tv.value;
            }
            try {
                bufRead.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            NonContinuousRateTSTrack tsTrack = new NonContinuousRateTSTrack(trackname, "");
            tsTrack.setData(values);
            tsTrack.setDerivativeLevel(0);
            tsTrack.setSource(this.csvFile.getAbsolutePath());
            tsTrack.setType(11);
            tsTrack.setRange(new float[]{min, max});
            tsTrack.setColor(Color.GREEN);
            NonContinuousRateTSTrack nonContinuousRateTSTrack = tsTrack;
            return nonContinuousRateTSTrack;
        }
        catch (FileNotFoundException fnfe) {
            ClientLogger.LOG.warning("File not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("File could not be read: " + ioe.getMessage());
        }
        finally {
            try {
                if (fileRead != null) {
                    fileRead.close();
                }
            }
            catch (IOException fnfe) {}
        }
        return null;
    }

    private TimeValue getTimeValue(String time, String value) {
        if (time == null) {
            return null;
        }
        long t = TimeFormatter.toMilliSeconds(time);
        float v = 0.0f;
        if (value != null) {
            try {
                v = Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                v = Float.NaN;
            }
        } else {
            v = Float.NaN;
        }
        return new TimeValue(t, v);
    }
}

