/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.io;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import mpi.eudico.client.annotator.timeseries.NonContinuousRateTSTrack;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.timeseries.TimeValueStart;
import mpi.eudico.client.annotator.util.ClientLogger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmlTimeSeriesReader
implements ContentHandler {
    private final String TS = "TIMESERIES";
    private final String ITEM = "i";
    private final String TIME = "t";
    private final String VAL = "v";
    private int numColumns;
    private long bt = 0L;
    private String curContent = "";
    private File xmlFile;
    private List<String> vals;
    private List<String> tracknames = new ArrayList<String>();
    TimeValue tv;
    float min = Float.MAX_VALUE;
    float max = Float.MIN_VALUE;
    private List<List<TimeValue>> trackData;
    private List<float[]> ranges;
    private boolean[] prevWasNaN;

    public XmlTimeSeriesReader(File xmlFile) {
        this.xmlFile = xmlFile;
    }

    public List<Object> parse() throws IOException, SAXException {
        if (this.xmlFile == null || !this.xmlFile.exists() || !this.xmlFile.canRead() || this.xmlFile.isDirectory()) {
            throw new IOException("Cannot parse the TIMESERIES file.");
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setContentHandler(this);
            reader.parse(this.xmlFile.getAbsolutePath());
            if (this.trackData != null && this.trackData.size() >= 0) {
                ArrayList<Object> tracks = new ArrayList<Object>(this.numColumns);
                for (int i = 0; i < this.trackData.size(); ++i) {
                    NonContinuousRateTSTrack tsTrack = new NonContinuousRateTSTrack(this.tracknames.get(i), "");
                    tsTrack.setData(this.trackData.get(i));
                    tsTrack.setDerivativeLevel(0);
                    tsTrack.setSource(this.xmlFile.getAbsolutePath());
                    tsTrack.setType(11);
                    tsTrack.setRange(this.ranges.get(i));
                    tsTrack.setColor(Color.GREEN);
                    tracks.add(tsTrack);
                }
                return tracks;
            }
            ClientLogger.LOG.warning("No tracks found in the TIMESERIES file");
        }
        catch (IOException ioe) {
            ClientLogger.LOG.warning("Parsing failed: " + ioe.getMessage());
            throw ioe;
        }
        catch (SAXException sax) {
            ClientLogger.LOG.warning("Parsing failed: " + sax.getMessage());
            throw sax;
        }
        return null;
    }

    private long parseTime(String token) {
        if (token != null) {
            try {
                if (token.indexOf(46) > -1) {
                    float val = Float.parseFloat(token);
                    return (long)(1000.0f * val);
                }
                return Long.parseLong(token);
            }
            catch (NumberFormatException nfe) {
                return -1L;
            }
        }
        return -1L;
    }

    private float getValue(String value) {
        float v = 0.0f;
        if (value != null) {
            try {
                v = Float.parseFloat(value);
            }
            catch (NumberFormatException nfe) {
                v = Float.NaN;
            }
        } else {
            v = Float.NaN;
        }
        return v;
    }

    private void initDataColls() {
        this.vals = new ArrayList<String>(10);
        this.trackData = new ArrayList<List<TimeValue>>(this.numColumns);
        this.ranges = new ArrayList<float[]>(this.numColumns);
        this.prevWasNaN = new boolean[this.numColumns];
        Arrays.fill(this.prevWasNaN, false);
        for (int i = 0; i < this.numColumns; ++i) {
            this.trackData.add(new ArrayList(100));
            this.ranges.add(new float[]{this.min, this.max});
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.curContent = this.curContent + new String(ch, start, length);
    }

    @Override
    public void startDocument() throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
        if (name.equals("TIMESERIES")) {
            String cols = attributes.getValue("columns");
            if (cols == null || cols.length() <= 0) throw new SAXException("No timeseries columns found, cannot create timeseries tracks.");
            Pattern pat = Pattern.compile(" ");
            String[] columns = pat.split(cols);
            for (int i = 0; i < columns.length; ++i) {
                this.tracknames.add(columns[i]);
            }
            this.numColumns = columns.length;
            this.initDataColls();
            return;
        } else {
            if (!name.equals("i")) return;
            this.bt = this.parseTime(attributes.getValue("t"));
            this.vals.clear();
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        if (name.equals("v")) {
            this.vals.add(this.curContent.trim());
            this.curContent = "";
        } else if (name.equals("i") && this.bt > -1L) {
            for (int i = 0; i < this.vals.size() && i < this.numColumns; ++i) {
                TimeValue tv = new TimeValue(this.bt, this.getValue(this.vals.get(i)));
                if (!Float.isNaN(tv.value)) {
                    if (this.prevWasNaN[i]) {
                        tv = new TimeValueStart(tv.time, tv.value);
                    }
                    this.prevWasNaN[i] = false;
                    this.trackData.get(i).add(tv);
                    float[] mm = this.ranges.get(i);
                    if (tv.value < mm[0]) {
                        mm[0] = tv.value;
                    }
                    if (!(tv.value > mm[1])) continue;
                    mm[1] = tv.value;
                    continue;
                }
                this.prevWasNaN[i] = true;
            }
        }
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }
}

