/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.load;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.util.ClientLogger;

public class RecognizerBundle {
    private String id;
    private String name;
    private ClassLoader loader;
    private String recognizerClassName;
    private String recExecutionType;
    private List<Param> paramList;
    private String helpFile;
    private URL[] javaLibs;
    private URL[] nativeLibs;
    private File baseDir;
    private String iconRef;

    public RecognizerBundle() {
    }

    public RecognizerBundle(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public List<Param> getParamList() {
        if (this.paramList == null) {
            return null;
        }
        ArrayList<Param> params = new ArrayList<Param>(this.paramList.size());
        for (Param p : this.paramList) {
            try {
                params.add((Param)p.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
        }
        return params;
    }

    public void setParamList(List<Param> paramList) {
        this.paramList = paramList;
    }

    public void setHelpFile(String file) {
        this.helpFile = file;
    }

    public String getHelpFile() {
        URL url = this.getURL(this.helpFile);
        if (url != null) {
            return url.toString();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRecognizerClass() {
        return this.recognizerClassName;
    }

    public void setRecognizerClass(String recognizerClassName) {
        this.recognizerClassName = recognizerClassName;
    }

    public URL[] getJavaLibs() {
        return this.javaLibs;
    }

    public void setJavaLibs(URL[] javaLibs) {
        this.javaLibs = javaLibs;
    }

    public URL[] getNativeLibs() {
        return this.nativeLibs;
    }

    public void setNativeLibs(URL[] nativeLibs) {
        this.nativeLibs = nativeLibs;
    }

    public String getRecExecutionType() {
        return this.recExecutionType;
    }

    public void setRecExecutionType(String recExecutionType) {
        this.recExecutionType = recExecutionType;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setIconRef(String iconRef) {
        this.iconRef = iconRef;
    }

    public String getIconRef() {
        return this.iconRef;
    }

    public URL getIconURL() {
        return this.getURL(this.iconRef);
    }

    private URL getURL(String relative) {
        if (relative != null) {
            try {
                Object path = this.getBaseDir().getAbsolutePath();
                path = ((String)path).replace('\\', '/');
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                if (((String)path).charAt(0) != '/') {
                    path = "/" + (String)path;
                }
                URI base = new URI("file", null, (String)path, null);
                URI icon = base.resolve(relative);
                return icon.toURL();
            }
            catch (URISyntaxException e) {
                ClientLogger.LOG.warning("URISyntaxException: " + e.getMessage());
            }
            catch (MalformedURLException e) {
                ClientLogger.LOG.warning("MalformedURLException: " + e.getMessage());
            }
            catch (IllegalArgumentException e) {
                ClientLogger.LOG.warning("IllegalArgumentException: " + e.getMessage());
            }
        }
        return null;
    }
}

