/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.load;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import mpi.eudico.client.annotator.recognizer.data.FileParam;
import mpi.eudico.client.annotator.recognizer.data.NumParam;
import mpi.eudico.client.annotator.recognizer.data.Param;
import mpi.eudico.client.annotator.recognizer.data.TextParam;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RecognizerParser
implements ContentHandler {
    private String recognizerName;
    private String description;
    private String implementor;
    private String recognizerType;
    private boolean curOsSupported = false;
    private List<Param> paramList;
    private String helpFile;
    private String iconRef;
    private InputStream inputStream;
    String curContent = "";
    Param curParam;

    public String getRecognizerName() {
        return this.recognizerName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImplementor() {
        return this.implementor;
    }

    public String getRecognizerType() {
        return this.recognizerType;
    }

    public boolean isCurOsSupported() {
        return this.curOsSupported;
    }

    public List<Param> getParamList() {
        return this.paramList;
    }

    public String getHelpFile() {
        return this.helpFile;
    }

    public String getIconRef() {
        return this.iconRef;
    }

    public RecognizerParser(InputStream inputStream) {
        this.inputStream = inputStream;
        this.paramList = new ArrayList<Param>(10);
    }

    public void parse() throws SAXException {
        if (this.inputStream != null) {
            try {
                XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                reader.setContentHandler(this);
                reader.parse(new InputSource(this.inputStream));
            }
            catch (IOException ioe) {
                throw new SAXException(ioe);
            }
        } else {
            throw new SAXException("No input stream specified");
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.curContent = this.curContent + new String(ch, start, length);
    }

    @Override
    public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
        if (name.equals("recognizer")) {
            this.recognizerType = attributes.getValue("recognizerType");
            this.description = attributes.getValue("info");
            String os = System.getProperty("os.name").toLowerCase();
            if (os.indexOf("win") > -1) {
                this.implementor = attributes.getValue("runWin");
                this.curOsSupported = this.implementor != null;
            } else if (os.indexOf("mac") > -1) {
                this.implementor = attributes.getValue("runMac");
                this.curOsSupported = this.implementor != null;
            } else if (os.indexOf("linux") > -1) {
                this.implementor = attributes.getValue("runLinux");
                this.curOsSupported = this.implementor != null;
            }
        } else if (name.equals("numparam")) {
            int index;
            NumParam np = new NumParam();
            int minPrec = 1;
            int maxPrec = 1;
            String value = attributes.getValue("min");
            if (value != null) {
                try {
                    float min;
                    np.min = min = Float.parseFloat(value);
                    index = value.indexOf(".");
                    if (index > -1 && index < value.length() - 1) {
                        minPrec = value.length() - index;
                    }
                }
                catch (NumberFormatException nfe) {
                    np.min = 0.0f;
                }
            }
            if ((value = attributes.getValue("max")) != null) {
                try {
                    float max;
                    np.max = max = Float.parseFloat(value);
                    index = value.indexOf(".");
                    if (index > -1 && index < value.length() - 1) {
                        maxPrec = value.length() - index;
                    }
                }
                catch (NumberFormatException nfe) {
                    np.max = 100.0f;
                }
            }
            if ((value = attributes.getValue("default")) != null) {
                try {
                    float def;
                    np.def = def = Float.parseFloat(value);
                }
                catch (NumberFormatException nfe) {
                    np.def = 50.0f;
                }
            }
            if ((value = attributes.getValue("info")) != null) {
                np.info = value;
            }
            if ((value = attributes.getValue("level")) != null) {
                np.level = value;
            }
            if ((value = attributes.getValue("type")) != null) {
                np.type = value;
            }
            int n = np.precision = minPrec > maxPrec ? minPrec : maxPrec;
            if (np.max - np.min < 1.0f) {
                ++np.precision;
            }
            this.paramList.add(np);
            this.curParam = np;
        } else if (name.equals("textparam")) {
            TextParam tp = new TextParam();
            String value = attributes.getValue("default");
            if (value != null) {
                tp.defValue = value;
            }
            if ((value = attributes.getValue("info")) != null) {
                tp.info = value;
            }
            if ((value = attributes.getValue("level")) != null) {
                tp.level = value;
            }
            if ((value = attributes.getValue("convoc")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                ArrayList<String> cvList = new ArrayList<String>(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    cvList.add(tokenizer.nextToken());
                }
                tp.conVoc = cvList;
            }
            this.paramList.add(tp);
            this.curParam = tp;
        } else if (name.equals("input") || name.equals("output")) {
            FileParam fp = new FileParam();
            fp.ioType = name.equals("input") ? (char)105 : (char)111;
            String value = attributes.getValue("type");
            if (value != null) {
                if (value.equals("audio")) {
                    fp.contentType = 0;
                } else if (value.equals("video")) {
                    fp.contentType = 1;
                } else if (value.equals("tier")) {
                    fp.contentType = 2;
                } else if (value.equals("multitier")) {
                    fp.contentType = 7;
                } else if (value.equals("csvtier")) {
                    fp.contentType = 3;
                } else if (value.equals("timeseries")) {
                    fp.contentType = 4;
                } else if (value.equals("csvtimeseries")) {
                    fp.contentType = 5;
                } else if (value.equals("auxiliary")) {
                    fp.contentType = 6;
                }
            }
            if ((value = attributes.getValue("info")) != null) {
                fp.info = value;
            }
            if ((value = attributes.getValue("level")) != null) {
                fp.level = value;
            }
            if ((value = attributes.getValue("optional")) != null) {
                fp.optional = Boolean.valueOf(value);
            }
            if ((value = attributes.getValue("mimetypes")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(value);
                ArrayList<String> mts = new ArrayList<String>(tokenizer.countTokens());
                while (tokenizer.hasMoreTokens()) {
                    mts.add(tokenizer.nextToken());
                }
                fp.mimeTypes = mts;
            }
            this.paramList.add(fp);
            this.curParam = fp;
        } else if (name.equals("documentation")) {
            this.iconRef = attributes.getValue("icon16");
        }
    }

    @Override
    public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
        if (this.curContent != null && this.curContent.length() > 0) {
            if (name.equals("recognizer")) {
                this.recognizerName = this.curContent.trim();
            } else if (name.equals("numparam")) {
                ((NumParam)this.curParam).id = this.curContent.trim();
            } else if (name.equals("textparam")) {
                ((TextParam)this.curParam).id = this.curContent.trim();
            } else if (name.equals("input") || name.equals("output")) {
                ((FileParam)this.curParam).id = this.curContent.trim();
            } else if (name.equals("documentation")) {
                this.helpFile = this.curContent.trim();
            }
        }
        this.curContent = "";
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String arg0) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
    }

    @Override
    public void processingInstruction(String arg0, String arg1) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator arg0) {
    }

    @Override
    public void skippedEntity(String arg0) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
    }
}

