/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.recognizer.silence;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.recognizer.api.AbstractSelectionPanel;
import mpi.eudico.client.annotator.recognizer.api.ParamPreferences;
import mpi.eudico.client.annotator.recognizer.api.RecognizerConfigurationException;
import mpi.eudico.client.annotator.recognizer.data.RSelection;

public class SilenceRecognizerPanel
extends JPanel
implements ChangeListener,
ParamPreferences {
    private JLabel minimalSilenceDurationLabel;
    private JSlider minimalSilenceDuration;
    private JLabel minimalNonSilenceDurationLabel;
    private JSlider minimalNonSilenceDuration;
    private JComboBox mediaFilesComboBox;
    private JPanel settingsPanel;
    private AbstractSelectionPanel selectionPanel;
    private ArrayList<String> mediaFilesList;
    private JPanel selPanel;
    private ManualOrExamplePanel manualOrExamplePanel;
    private ResourceBundle languageBundle;

    public SilenceRecognizerPanel(AbstractSelectionPanel selectionPanel) {
        this.selectionPanel = selectionPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.mediaFilesComboBox = new JComboBox();
        JPanel filePanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        filePanel.add((Component)new JLabel("Files List :"), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        filePanel.add((Component)this.mediaFilesComboBox, gbc);
        this.selPanel = new JPanel(new GridBagLayout());
        this.selPanel.setBorder(new TitledBorder("Selection Panel"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.weightx = 1.0;
        this.selPanel.add((Component)this.selectionPanel, gbc);
        this.initializeSettingsPanel();
        JPanel settingPanel = new JPanel(new GridBagLayout());
        settingPanel.setBorder(new TitledBorder("Settings"));
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        settingPanel.add((Component)this.settingsPanel, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 2, 4, 2);
        this.add((Component)filePanel, gbc);
        gbc.anchor = 18;
        this.manualOrExamplePanel = new ManualOrExamplePanel();
        this.manualOrExamplePanel.setBorder(new TitledBorder("Silence Level"));
        this.add((Component)this.manualOrExamplePanel, gbc);
        this.add((Component)settingPanel, gbc);
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)new JPanel(), gbc);
    }

    private void initializeSettingsPanel() {
        int initialSilenceDuration = 400;
        int initialNonSilenceDuration = 300;
        this.settingsPanel = new JPanel();
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.settingsPanel.add(Box.createVerticalStrut(4));
        this.minimalSilenceDurationLabel = new JLabel();
        this.settingsPanel.add(this.minimalSilenceDurationLabel);
        this.minimalSilenceDuration = new JSlider(0, 0, 1000, initialSilenceDuration);
        this.minimalSilenceDuration.setMajorTickSpacing(200);
        this.minimalSilenceDuration.setMinorTickSpacing(25);
        this.minimalSilenceDuration.setPaintTicks(true);
        this.minimalSilenceDuration.setPaintLabels(true);
        this.minimalSilenceDuration.addChangeListener(this);
        this.settingsPanel.add(this.minimalSilenceDuration);
        this.settingsPanel.add(Box.createVerticalStrut(4));
        this.minimalNonSilenceDurationLabel = new JLabel();
        this.settingsPanel.add(this.minimalNonSilenceDurationLabel);
        this.minimalNonSilenceDuration = new JSlider(0, 0, 1000, initialNonSilenceDuration);
        this.minimalNonSilenceDuration.setMajorTickSpacing(200);
        this.minimalNonSilenceDuration.setMinorTickSpacing(25);
        this.minimalNonSilenceDuration.setPaintTicks(true);
        this.minimalNonSilenceDuration.setPaintLabels(true);
        this.minimalNonSilenceDuration.addChangeListener(this);
        this.settingsPanel.add(this.minimalNonSilenceDuration);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        int duration = source.getValue();
        if (source == this.minimalSilenceDuration) {
            if (this.languageBundle != null) {
                this.minimalSilenceDurationLabel.setText(this.languageBundle.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + this.languageBundle.getString("PlayAroundSelDialog.Ms"));
            }
        } else if (source == this.minimalNonSilenceDuration && this.languageBundle != null) {
            this.minimalNonSilenceDurationLabel.setText(this.languageBundle.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + this.languageBundle.getString("PlayAroundSelDialog.Ms"));
        }
    }

    public int getMinimalSilenceDuration() {
        return this.minimalSilenceDuration.getValue();
    }

    public int getMinimalNonSilenceDuration() {
        return this.minimalNonSilenceDuration.getValue();
    }

    public void updateLocale(Locale locale) {
        if (this.languageBundle == null) {
            this.updateLocaleBundle(null);
        }
    }

    public void updateLocaleBundle(ResourceBundle bundle) {
        if (bundle != null) {
            this.languageBundle = bundle;
            int duration = this.minimalSilenceDuration.getValue();
            this.minimalSilenceDurationLabel.setText(bundle.getString("Recognizer.Silence.MinimalSilenceDuration") + " " + duration + " " + bundle.getString("PlayAroundSelDialog.Ms"));
            duration = this.minimalNonSilenceDuration.getValue();
            this.minimalNonSilenceDurationLabel.setText(bundle.getString("Recognizer.Silence.MinimalNonSilenceDuration") + " " + duration + " " + bundle.getString("PlayAroundSelDialog.Ms"));
            this.selectionPanel.updateLocaleBundle(bundle);
            this.manualOrExamplePanel.updateLocale();
        }
    }

    public void updateMediaFiles(List<String> mediaFiles) {
        if (this.mediaFilesComboBox == null) {
            this.mediaFilesComboBox = new JComboBox();
        }
        if (this.mediaFilesList == null) {
            this.mediaFilesList = new ArrayList();
        }
        this.mediaFilesComboBox.removeAllItems();
        this.mediaFilesList.clear();
        if (mediaFiles != null && mediaFiles.size() > 0) {
            ArrayList<String> fileNameList = new ArrayList<String>();
            for (String media : mediaFiles) {
                String fileName = this.fileNameFromPath(media);
                if (fileNameList.contains(fileName)) {
                    this.mediaFilesComboBox.addItem(media);
                } else {
                    this.mediaFilesComboBox.addItem(fileName);
                    fileNameList.add(fileName);
                }
                this.mediaFilesList.add(media);
            }
            this.mediaFilesComboBox.setSelectedIndex(0);
        }
    }

    private String fileNameFromPath(String path) {
        if (path == null) {
            return "Unknown";
        }
        int index = path.lastIndexOf(47);
        if (index > -1 && index < path.length() - 1) {
            return path.substring(index + 1);
        }
        return path;
    }

    @Override
    public Map<String, Object> getParamPreferences() {
        HashMap<String, Object> sps = new HashMap<String, Object>(5);
        sps.put("MinimalSilenceDuration", this.minimalSilenceDuration.getValue());
        sps.put("MinimalNonSilenceDuration", this.minimalNonSilenceDuration.getValue());
        sps.put("ManualNoiseThreshold", new Double(this.getNoiseThreshold()));
        sps.put("NoiseThresholdSetManually", this.isNoiseThresholdSetManually());
        sps.put("SelectionPanelPref", this.selectionPanel.getStorableParamPreferencesMap(this.selectionPanel.getParamValue()));
        return sps;
    }

    @Override
    public void setParamPreferences(Map<String, Object> storedPrefs) {
        if (storedPrefs != null) {
            Object val = storedPrefs.get("MinimalSilenceDuration");
            if (val instanceof Integer) {
                this.minimalSilenceDuration.setValue((Integer)val);
            }
            if ((val = storedPrefs.get("MinimalNonSilenceDuration")) instanceof Integer) {
                this.minimalNonSilenceDuration.setValue((Integer)val);
            }
            if ((val = storedPrefs.get("ManualNoiseThreshold")) instanceof Double) {
                this.setNoiseThreshold((Double)val);
            }
            if ((val = storedPrefs.get("NoiseThresholdSetManually")) instanceof Boolean) {
                this.setNoiseThresholdSetManually((Boolean)val);
            }
            if ((val = storedPrefs.get("SelectionPanelPref")) instanceof HashMap) {
                this.selectionPanel.setParamValue((HashMap)val);
            }
        }
    }

    public String getSelectedMediaFile() {
        return this.mediaFilesList.get(this.mediaFilesComboBox.getSelectedIndex());
    }

    public void validateParameters() throws RecognizerConfigurationException {
        if (!this.isNoiseThresholdSetManually() && this.getSelections() == null) {
            if (this.languageBundle != null) {
                throw new RecognizerConfigurationException(this.languageBundle.getString("Recognizer.RecognizerPanel.Warning.Selection"));
            }
            throw new RecognizerConfigurationException("There are no selections provided.");
        }
    }

    public ArrayList<RSelection> getSelections() {
        Object value = this.selectionPanel.getSelectionValue();
        if (value instanceof ArrayList) {
            return (ArrayList)value;
        }
        return null;
    }

    public double getNoiseThreshold() {
        return this.manualOrExamplePanel.getNoiseThreshold();
    }

    public void setNoiseThreshold(double val) {
        this.manualOrExamplePanel.setNoiseThreshold(val);
    }

    public boolean isNoiseThresholdSetManually() {
        return this.manualOrExamplePanel.isNoiseThresholdSetManually();
    }

    public void setNoiseThresholdSetManually(boolean manual) {
        this.manualOrExamplePanel.setNoiseThresholdSetManually(manual);
    }

    private class ManualOrExamplePanel
    extends JPanel
    implements ActionListener,
    ChangeListener {
        private static final int SLIDER_DB_RANGE = 90;
        private JRadioButton manualRB = new JRadioButton();
        private JRadioButton byExampleRB = new JRadioButton();
        private JPanel changingPanel;
        private JLabel levelSliderLabel;
        private JSlider levelSlider;

        public ManualOrExamplePanel() {
            ButtonGroup group = new ButtonGroup();
            group.add(this.manualRB);
            group.add(this.byExampleRB);
            this.manualRB.addActionListener(this);
            this.byExampleRB.addActionListener(this);
            this.changingPanel = new JPanel();
            this.levelSliderLabel = new JLabel();
            this.levelSlider = new JSlider(0, -90, 0, (int)this.factorTodBRMS(0.05));
            this.levelSlider.setMajorTickSpacing(10);
            this.levelSlider.setMinorTickSpacing(5);
            this.levelSlider.setPaintTicks(true);
            this.levelSlider.setPaintLabels(true);
            this.levelSlider.addChangeListener(this);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.anchor = 18;
            gbc.fill = 0;
            gbc.weightx = 0.0;
            this.add((Component)this.manualRB, gbc);
            gbc.gridx = 1;
            this.add((Component)this.byExampleRB, gbc);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.changingPanel.setLayout(new GridBagLayout());
            this.add((Component)this.changingPanel, gbc);
            this.updateLocale();
            this.manualRB.doClick();
        }

        public void updateLocale() {
            if (SilenceRecognizerPanel.this.languageBundle != null) {
                this.manualRB.setText(SilenceRecognizerPanel.this.languageBundle.getString("Recognizer.Silence.SelectManually"));
                this.byExampleRB.setText(SilenceRecognizerPanel.this.languageBundle.getString("Recognizer.Silence.SelectByExample"));
                this.updateLevelSliderLabel(this.levelSlider.getValue());
            } else {
                this.manualRB.setText("Select manually");
                this.byExampleRB.setText("Select by example");
            }
        }

        private void updateLevelSliderLabel(int level) {
            String s = null;
            s = SilenceRecognizerPanel.this.languageBundle != null ? String.format("%s %d %s (%3.3f %%)", SilenceRecognizerPanel.this.languageBundle.getString("Recognizer.Silence.SilenceLevel"), level, SilenceRecognizerPanel.this.languageBundle.getString("Recognizer.Silence.Decibel"), 100.0 * this.dBRMSToFactor(level)) : String.format("%s %d %s (%3.3f %%)", "Silence level", level, "dB RMS", 100.0 * this.dBRMSToFactor(level));
            this.levelSliderLabel.setText(s);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source instanceof JRadioButton) {
                if (source == this.manualRB) {
                    this.showManualControls(true);
                } else if (source == this.byExampleRB) {
                    this.showManualControls(false);
                }
            }
        }

        public void showManualControls(boolean manually) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            this.changingPanel.removeAll();
            if (manually) {
                gbc.insets = new Insets(5, 20, 1, 1);
                this.changingPanel.add((Component)this.levelSliderLabel, gbc);
                gbc.insets = new Insets(0, 0, 0, 0);
                this.changingPanel.add((Component)this.levelSlider, gbc);
            } else {
                this.changingPanel.add((Component)SilenceRecognizerPanel.this.selPanel, gbc);
            }
            this.revalidate();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSlider source = (JSlider)e.getSource();
            int level = source.getValue();
            if (source == this.levelSlider) {
                this.updateLevelSliderLabel(level);
            }
        }

        public double getNoiseThreshold() {
            return this.dBRMSToFactor(this.levelSlider.getValue());
        }

        public void setNoiseThreshold(double value) {
            this.levelSlider.setValue((int)this.factorTodBRMS(value));
        }

        private double factorTodBRMS(double factor) {
            return 20.0 * Math.log10(factor);
        }

        private double dBRMSToFactor(double dB_RMS) {
            return Math.pow(10.0, dB_RMS / 20.0);
        }

        public boolean isNoiseThresholdSetManually() {
            return this.manualRB.isSelected();
        }

        public void setNoiseThresholdSetManually(boolean manually) {
            if (manually) {
                this.manualRB.doClick();
            } else {
                this.byExampleRB.doClick();
            }
        }
    }
}

