/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.logging.Level;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.search.model.EAFMultipleFileSearchHandler;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.model.ProgressListener;
import mpi.search.model.SearchEngine;
import mpi.search.query.model.Query;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EAFMultipleFileSearchEngine
implements SearchEngine {
    private final ProgressListener progressListener;

    public EAFMultipleFileSearchEngine(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public static ContentQuery createQuery(String regex, File[] files) throws Exception {
        AnchorConstraint ac = new AnchorConstraint("", regex, 0L, 0L, "", true, false, null);
        ContentQuery query = new ContentQuery(ac, new EAFType(), files);
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeThread(ContentQuery query) throws Exception {
        EAFMultipleFileSearchHandler handler = new EAFMultipleFileSearchHandler(query);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        File[] files = query.getFiles();
        ArrayList<File> failedFiles = new ArrayList<File>();
        try {
            SAXParser saxParser = factory.newSAXParser();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                FileInputStream fis = null;
                handler.newFile(file);
                try {
                    fis = new FileInputStream(file);
                    InputSource source = new InputSource(fis);
                    saxParser.parse(source, (DefaultHandler)handler);
                }
                catch (SAXException e) {
                    failedFiles.add(file);
                }
                catch (IOException e) {
                    failedFiles.add(file);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException e) {}
                }
                if (this.progressListener == null) continue;
                this.progressListener.setProgress((int)((double)(i + 1) * 100.0 / (double)files.length));
            }
        }
        catch (ConcurrentModificationException saxParser) {
            // empty catch block
        }
        if (!failedFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder(ElanLocale.getString("MultipleFileSearch.Message.ParseErrors"));
            sb.append("\n");
            int max = 6;
            for (int i = 0; i < failedFiles.size() && i < max; ++i) {
                sb.append(((File)failedFiles.get(i)).getName());
                sb.append("\n");
            }
            if (failedFiles.size() > max) {
                sb.append("... + " + (failedFiles.size() - max));
            }
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning(sb.toString());
            }
            throw new SAXException(sb.toString());
        }
    }

    @Override
    public void performSearch(Query query) throws Exception {
        this.executeThread((ContentQuery)query);
    }
}

