/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.query.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.TierSortAndSelectDialog2;
import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.eudico.client.annotator.search.query.viewer.ElanPatternPanel;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.RestrictedAnchorConstraint;
import mpi.search.content.query.viewer.AbstractConstraintPanel;
import mpi.search.content.query.viewer.AnchorConstraintPanel;
import mpi.search.content.query.viewer.AttributeConstraintPanel;
import mpi.search.content.query.viewer.RelationPanel;

public class ElanAnchorConstraintPanel
extends AnchorConstraintPanel
implements ActionListener {
    public ElanAnchorConstraintPanel(AnchorConstraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);
    }

    @Override
    protected void makeLayout() {
        this.patternPanel = new ElanPatternPanel(this.type, this.tierComboBox, this.regExCheckBox, this.constraint, this.startAction, Constants.DEFAULTFONT);
        this.relationPanel = new RelationPanel(this.type, this.constraint);
        JPanel checkBoxPanel = new JPanel(new GridLayout(2, 1));
        this.regExCheckBox.setFont(Constants.deriveSmallFont(this.getFont()));
        this.caseCheckBox.setFont(Constants.deriveSmallFont(this.getFont()));
        checkBoxPanel.add(this.regExCheckBox);
        checkBoxPanel.add(this.caseCheckBox);
        this.optionPanel.add((Component)checkBoxPanel, "West");
        this.regExCheckBox.addActionListener(this);
        this.caseCheckBox.addActionListener(this);
        JPanel inputPanel = new JPanel(new GridLayout(2, 1, 0, 1));
        inputPanel.add(this.patternPanel);
        inputPanel.add(this.relationPanel);
        if (this.type.hasAttributes()) {
            this.attributePanel = new AttributeConstraintPanel(this.type);
            this.optionPanel.add((Component)this.attributePanel, "Center");
            this.attributePanel.setTier(this.getTierName());
        }
        JPanel specificationPanel = new JPanel(new FlowLayout(0, 0, 1));
        specificationPanel.add(inputPanel);
        specificationPanel.add(this.optionPanel);
        this.framedPanel.add((Component)specificationPanel, "");
        this.framedPanel.setBorder(this.blueBorder);
        this.framedPanelLayout.show(this.framedPanel, "");
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleComponent, "North");
        this.add((Component)this.framedPanel, "Center");
        this.tierComboBox.addItemListener(this);
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 5, 1));
        AbstractAction addConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElanAnchorConstraintPanel.this.addConstraint();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(65, 2);
        addConstraintAction.putValue("AcceleratorKey", ks);
        JButton addButton = new JButton(addConstraintAction);
        buttonPanel.add(addButton);
        if (this.constraint.getParent() != null && !(this.constraint.getParent() instanceof RestrictedAnchorConstraint)) {
            AbstractAction deleteConstraintAction = new AbstractAction(SearchLocale.getString("Search.Query.Delete")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ElanAnchorConstraintPanel.this.deleteConstraint();
                }
            };
            ks = KeyStroke.getKeyStroke(68, 2);
            deleteConstraintAction.putValue("AcceleratorKey", ks);
            JButton deleteButton = new JButton(deleteConstraintAction);
            buttonPanel.add(deleteButton);
        }
        this.add((Component)buttonPanel, "South");
        try {
            Class popupMenu = this.type.getInputMethodClass();
            popupMenu.getConstructor(Component.class, AbstractConstraintPanel.class).newInstance(this.patternPanel.getDefaultInputComponent(), this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void grabFocus() {
        this.patternPanel.grabFocus();
    }

    @Override
    protected void selectCustomTierSet() {
        String[] tierNames;
        if (!(this.type instanceof ElanType)) {
            return;
        }
        Window w = SwingUtilities.getWindowAncestor(this);
        ArrayList<String> allTiers = new ArrayList<String>();
        for (String string : tierNames = this.type.getTierNames()) {
            allTiers.add(string);
        }
        TranscriptionImpl trans = (TranscriptionImpl)((ElanType)this.type).getTranscription();
        ArrayList<String> sTiers = new ArrayList<String>();
        if (this.selectedTiers != null) {
            sTiers.addAll(this.selectedTiers);
        } else {
            String[] curTiers = this.getTierNames();
            if (curTiers.length == 1 && curTiers[0] == "Search.Constraint.AllTiers") {
                List<String> list = Preferences.getListOfString("Search.SelectedTiers", trans);
                if (list != null) {
                    sTiers.addAll(list);
                } else {
                    sTiers.addAll(allTiers);
                }
            } else {
                for (String s : curTiers) {
                    sTiers.add(s);
                }
            }
        }
        TierSortAndSelectDialog2 dialog = null;
        if (w instanceof Dialog) {
            dialog = new TierSortAndSelectDialog2((Dialog)w, trans, allTiers, sTiers);
        } else if (w instanceof Frame) {
            dialog = new TierSortAndSelectDialog2((Frame)w, trans, allTiers, sTiers);
        }
        if (dialog == null) {
            return;
        }
        String string = Preferences.getString("Search.TierSelectionMode", trans);
        List<String> itemPref = Preferences.getListOfString("Search.HiddenItems", trans);
        if (string != null) {
            dialog.setSelectionMode(string, itemPref);
        }
        dialog.setTitle(ElanLocale.getString("TranscriptionManager.SelectTierDlg.Title"));
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        List<String> selTiers = dialog.getSelectedTiers();
        if (selTiers != null) {
            this.setTierNames(selTiers);
            String mode = dialog.getSelectionMode();
            List<String> items = dialog.getUnselectedItems();
            Preferences.set("Search.SelectedTiers", selTiers, (Transcription)trans);
            Preferences.set("Search.TierSelectionMode", mode, (Transcription)trans);
            Preferences.set("Search.HiddenItems", items, (Transcription)trans);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.regExCheckBox) {
            Preferences.set("Search.RegularExpression", this.regExCheckBox.isSelected(), null, false, false);
        } else if (e.getSource() == this.caseCheckBox) {
            Preferences.set("Search.CaseSensitive", this.caseCheckBox.isSelected(), null, false, false);
        }
    }
}

