/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.query.viewer;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.search.query.viewer.ElanConstraintEditor;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AbstractConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.viewer.ConstraintRenderer;
import mpi.search.content.query.viewer.QueryPanel;

public class ElanQueryPanel
extends QueryPanel {
    public ElanQueryPanel(CorpusType type, Action startAction) {
        super(type, startAction);
    }

    @Override
    protected void createTree(Action startAction) {
        MutableTreeNode rootNode = (MutableTreeNode)this.treeModel.getRoot();
        if (rootNode instanceof AbstractConstraint) {
            Boolean casePref;
            AbstractConstraint rootCon = (AbstractConstraint)rootNode;
            Boolean regExPref = Preferences.getBool("Search.RegularExpression", null);
            if (regExPref != null) {
                rootCon.setRegEx(regExPref);
            }
            if ((casePref = Preferences.getBool("Search.CaseSensitive", null)) != null) {
                rootCon.setCaseSensitive(casePref);
            }
        }
        this.jTree = new JTree(this.treeModel){

            @Override
            public boolean isPathEditable(TreePath path) {
                return ((Constraint)path.getLastPathComponent()).isEditable();
            }
        };
        this.jTree.setEditable(true);
        this.jTree.setCellRenderer(new ConstraintRenderer());
        this.jTree.setCellEditor(new ElanConstraintEditor(this.treeModel, this.type, startAction));
        this.jTree.setRowHeight(0);
        this.jTree.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.jTree.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jTree, "Center");
        this.jTree.startEditingAtPath(this.jTree.getPathForRow(0));
        this.treeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesInserted(final TreeModelEvent e) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ElanQueryPanel.this.jTree.startEditingAtPath(e.getTreePath().pathByAddingChild(e.getChildren()[0]));
                        }
                    });
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                ElanQueryPanel.this.jTree.startEditingAtPath(e.getTreePath());
            }
        });
    }
}

