/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.result.viewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerPopupMenu;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerGridRenderer;
import mpi.eudico.client.annotator.search.result.viewer.EAFResultViewerTableModel;
import mpi.eudico.client.util.LinkButton;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.search.content.result.model.ContentMatch;
import mpi.search.result.model.Match;
import mpi.search.result.model.Result;
import mpi.search.result.model.ResultEvent;
import mpi.search.result.viewer.AbstractResultViewer;

public class EAFMultipleFileResultViewer
extends AbstractResultViewer
implements ListDataListener {
    private AnnotationTable table;
    private EAFResultViewerTableModel dataModel;
    private ElanFrame2 elanFrame;
    private JPopupMenu popup;
    private LinkButton nextButton;
    private LinkButton previousButton;

    public EAFMultipleFileResultViewer(ElanFrame2 elanFrame) {
        this.elanFrame = elanFrame;
        this.dataModel = new EAFResultViewerTableModel();
        this.table = new AnnotationTable(this.dataModel);
        this.table.setSelectionMode(0);
        this.setLayout(new BorderLayout());
        this.table.setDefaultRenderer(Object.class, new EAFResultViewerGridRenderer(this.dataModel));
        this.table.updateLocale();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        scrollPane.getViewport().setBackground(Color.white);
        this.add((Component)scrollPane, "Center");
        this.popup = new GridViewerPopupMenu(this.table);
        this.setTableListener();
        this.makeControlPanel();
    }

    public void setColumnVisible(String columnName, boolean visible) {
        this.table.setColumnVisible(columnName, visible);
    }

    public void setData(List<? extends AnnotationCore> list) {
        this.dataModel.updateAnnotations(list);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.table.getPreferredScrollableViewportSize();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.dataModel.setFirstRealIndex(this.result.getFirstShownRealIndex());
        this.dataModel.updateAnnotations(this.result.getSubList());
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.dataModel.setFirstRealIndex(this.result.getFirstShownRealIndex());
        for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
            this.dataModel.addAnnotation((ContentMatch)this.result.getElementAt(i));
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
    }

    @Override
    public void reset() {
        super.reset();
        this.setData(new ArrayList());
    }

    @Override
    public void resultChanged(ResultEvent e) {
        this.result = (Result)e.getSource();
        if (e.getType() == 1 && this.result.getStatus() == 0) {
            this.result.addListDataListener(this);
        }
        if (e.getType() == 1 && this.result.getRealSize() == 0) {
            this.reset();
        } else if (e.getType() == 2) {
            this.controlPanel.setVisible(true);
            this.updateButtons();
        } else if (e.getType() == 1 && (this.result.getStatus() == 1 || this.result.getStatus() == -1)) {
            this.updateButtons();
        }
    }

    public void showMatch(Match match) {
    }

    @Override
    public void showResult(Result result) {
        System.out.println("In show");
        this.setData(result.getMatches());
        this.updateButtons();
    }

    protected void setTableListener() {
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    return;
                }
                int selrow = EAFMultipleFileResultViewer.this.table.getSelectedRow();
                if (selrow < 0) {
                    return;
                }
                if (EAFMultipleFileResultViewer.this.elanFrame != null) {
                    int fileColumn = EAFMultipleFileResultViewer.this.dataModel.findColumn("ColumnFileName");
                    EAFMultipleFileResultViewer.this.setCursor(Cursor.getPredefinedCursor(3));
                    final ElanFrame2 newElanFrame = FrameManager.getInstance().getFrameFor((String)EAFMultipleFileResultViewer.this.dataModel.getValueAt(selrow, fileColumn));
                    EAFMultipleFileResultViewer.this.setCursor(Cursor.getPredefinedCursor(0));
                    if (newElanFrame != null) {
                        final ContentMatch match = (ContentMatch)EAFMultipleFileResultViewer.this.dataModel.getValueAt(selrow, EAFMultipleFileResultViewer.this.dataModel.findColumn("ColumnAnnotation"));
                        if (newElanFrame.getViewerManager() != null && newElanFrame.isFullyInitialized()) {
                            newElanFrame.getViewerManager().getSelection().setSelection(match.getBeginTimeBoundary(), match.getEndTimeBoundary());
                            newElanFrame.getViewerManager().getMasterMediaPlayer().setMediaTime(match.getBeginTimeBoundary());
                        } else {
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    long timeOut = System.currentTimeMillis() + 60000L;
                                    while (!newElanFrame.isFullyInitialized() && System.currentTimeMillis() < timeOut) {
                                        try {
                                            Thread.sleep(200L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    if (!newElanFrame.isFullyInitialized()) {
                                        return;
                                    }
                                    newElanFrame.getViewerManager().getSelection().setSelection(match.getBeginTimeBoundary(), match.getEndTimeBoundary());
                                    newElanFrame.getViewerManager().getMasterMediaPlayer().setMediaTime(match.getBeginTimeBoundary());
                                }
                            }).start();
                        }
                        newElanFrame.toFront();
                        SwingUtilities.windowForComponent(EAFMultipleFileResultViewer.this).toFront();
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                    EAFMultipleFileResultViewer.this.popup.show(EAFMultipleFileResultViewer.this, 100, 20);
                }
            }
        });
    }

    protected void makeControlPanel() {
        this.previousButton = new LinkButton(this.previousAction);
        this.nextButton = new LinkButton(this.nextAction);
        this.previousButton.setVisible(false);
        this.nextButton.setVisible(false);
        this.controlPanel.setOpaque(false);
        this.controlPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.controlPanel.add(this.previousButton);
        this.controlPanel.add(this.currentLabel);
        this.controlPanel.add(this.nextButton);
        this.controlPanel.add(Box.createHorizontalGlue());
    }

    @Override
    protected void updateButtons() {
        super.updateButtons();
        this.previousButton.setVisible(this.previousAction.isEnabled());
        this.nextButton.setVisible(this.nextAction.isEnabled());
        this.previousButton.setLabel(this.intervalToString(this.getPreviousInterval()));
        this.nextButton.setLabel(this.intervalToString(this.getNextInterval()));
        ((Window)this.getTopLevelAncestor()).validate();
    }
}

