/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;

public class EAFMultipleFileUtilities {
    public static final String extension = ".eaf";

    public static boolean specifyDomain(Component parent, List<String> searchDirs, List<String> searchPaths) {
        int nFiles;
        File[] currentFiles = null;
        int nDirs = searchDirs.size();
        if (nDirs + (nFiles = searchPaths.size()) > 0) {
            int i;
            currentFiles = new File[nDirs + nFiles];
            for (i = 0; i < searchDirs.size(); ++i) {
                currentFiles[i] = new File(searchDirs.get(i));
            }
            for (i = 0; i < searchPaths.size(); ++i) {
                currentFiles[i + nDirs] = new File(searchPaths.get(i));
            }
        }
        FileChooser chooser = new FileChooser(parent);
        chooser.createAndShowMultiFileDialog(ElanLocale.getString("MultipleFileSearch.DomainDialogTitle"), 0, ElanLocale.getString("Button.OK"), null, FileExtension.EAF_EXT, false, "MultipleFileSearchLastDir", 2, currentFiles);
        Object[] names = chooser.getSelectedFiles();
        if (names != null) {
            searchDirs.clear();
            searchPaths.clear();
            for (Object name2 : names) {
                String name = name2.toString();
                File f = new File(name);
                if (f.isFile()) {
                    searchPaths.add(f.getPath());
                    continue;
                }
                if (!f.isDirectory()) continue;
                searchDirs.add(f.getPath());
            }
            Preferences.set("MultipleFileSearchDirs", searchDirs, null);
            Preferences.set("MultipleFileSearchPaths", searchPaths, null);
            return true;
        }
        return false;
    }

    public static File[] getUniqueEAFFilesIn(List<String> dirs, List<String> paths) {
        int i;
        TreeSet<File> sortedUniqueFiles = new TreeSet<File>();
        for (i = 0; i < dirs.size(); ++i) {
            File dir = new File(dirs.get(i));
            if (!dir.exists() || !dir.isDirectory() || !dir.canRead()) continue;
            sortedUniqueFiles.addAll(EAFMultipleFileUtilities.getAllEafFilesUnder(dir));
        }
        for (i = 0; i < paths.size(); ++i) {
            File file;
            String path = paths.get(i);
            if (!path.toLowerCase().endsWith(extension) || !(file = new File(path)).exists() || !file.canRead()) continue;
            sortedUniqueFiles.add(file);
        }
        return sortedUniqueFiles.toArray(new File[0]);
    }

    public static List<File> getAllEafFilesUnder(File directory) {
        ArrayList<File> eafFiles = new ArrayList<File>();
        File[] filesAndDirs = directory.listFiles();
        if (filesAndDirs == null) {
            return eafFiles;
        }
        for (File fileOrDir : filesAndDirs) {
            if (fileOrDir.isFile() && fileOrDir.canRead()) {
                if (!fileOrDir.getName().toLowerCase().endsWith(extension)) continue;
                eafFiles.add(fileOrDir);
                continue;
            }
            if (!fileOrDir.isDirectory() || !fileOrDir.canRead()) continue;
            eafFiles.addAll(EAFMultipleFileUtilities.getAllEafFilesUnder(fileOrDir));
        }
        return eafFiles;
    }
}

