/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.search.viewer;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.search.model.EAFType;
import mpi.eudico.client.annotator.search.model.ElanSearchEngine;
import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.eudico.client.annotator.search.query.viewer.ElanQueryPanel;
import mpi.eudico.client.annotator.search.result.viewer.ElanResultViewer;
import mpi.eudico.client.annotator.search.viewer.ExportResultDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;
import mpi.search.SearchLocale;
import mpi.search.content.query.model.ContentQuery;
import mpi.search.content.query.xml.Query2Xml;
import mpi.search.content.query.xml.Xml2Query;
import mpi.search.content.result.model.ContentResult;
import mpi.search.content.viewer.AbstractComplexSearchPanel;
import mpi.search.model.DefaultSearchController;
import mpi.search.query.model.Query;

public class ElanSearchPanel
extends AbstractComplexSearchPanel
implements ElanLocaleListener,
ACMEditListener {
    static final String LAST_DIR_KEY = "SearchLastDir";
    protected final Action replaceAction;
    private final JLabel infoLabel = new JLabel();
    private final ViewerManager2 viewerManager;
    private boolean queryRestarted = false;
    private PatternSyntaxException lastPSException;

    public ElanSearchPanel(ViewerManager2 viewerManager) {
        this.viewerManager = viewerManager;
        this.queryPanel = new ElanQueryPanel(new ElanType((TranscriptionImpl)viewerManager.getTranscription()), this.startAction);
        this.resultViewer = viewerManager.createSearchResultViewer();
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnFileName", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnLeftContext", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnRightContext", false);
        ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnTierName", false);
        this.saveAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Save"));
        this.readAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Open"));
        this.exportAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Export"));
        this.replaceAction = new AbstractAction(SearchLocale.getString("Action.Replace")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ElanSearchPanel.this.replace();
            }
        };
        this.replaceAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Replace"));
        this.makeLayout();
        this.searchEngine = new DefaultSearchController(this, new ElanSearchEngine(this, viewerManager.getTranscription()));
        this.searchEngine.setProgressListener(this.progressViewer);
        try {
            viewerManager.getTranscription().addACMEditListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.queryManager.size() == 0) {
            return;
        }
        if (e.getOperation() == 6 || e.getOperation() == 1 || e.getOperation() == 8 || e.getOperation() == 7 || e.getOperation() == 14) {
            Object o = e.getModification() != null ? e.getModification() : e.getInvalidatedObject();
            String tierName = null;
            if (o instanceof TierImpl) {
                try {
                    tierName = ((TierImpl)o).getName();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (o instanceof AbstractAnnotation) {
                try {
                    tierName = ((AbstractAnnotation)o).getTier().getName();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            block4: for (int i = 1; i <= this.queryManager.size(); ++i) {
                ContentResult result = (ContentResult)this.queryManager.getQuery(i).getResult();
                if (tierName != null) {
                    String[] tierNames;
                    if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                        ClientLogger.LOG.fine("Checking search results, edited tier is: " + tierName);
                    }
                    for (String tierName2 : tierNames = result.getTierNames()) {
                        if (!tierName.equals(tierName2)) continue;
                        result.setStatus(2);
                        continue block4;
                    }
                    continue;
                }
                if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                    ClientLogger.LOG.fine("Search results, edited tier is not known, executing query again");
                }
                result.setStatus(2);
            }
            if (this.queryManager.getCurrentQuery().getResult() != null && this.queryManager.getCurrentQuery().getResult().getStatus() == 2) {
                this.queryRestarted = true;
                this.startSearch();
            }
        }
    }

    @Override
    public void executionStarted() {
        super.executionStarted();
        this.updateResultViewer();
        this.infoLabel.setText(" " + ElanLocale.getString("SearchDialog.FoundNone"));
    }

    @Override
    public void executionStopped() {
        super.executionStopped();
        this.viewerManager.setControllersForViewer((AbstractViewer)((Object)this.resultViewer), ((ContentResult)this.searchEngine.getResult()).getTierNames());
        this.queryRestarted = false;
    }

    @Override
    public void handleException(Exception e) {
        if (e instanceof PatternSyntaxException) {
            if (!this.queryRestarted) {
                JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.Formulation"), 0, null);
            } else {
                PatternSyntaxException curPSE = (PatternSyntaxException)e;
                if (this.lastPSException != null && curPSE.getIndex() == this.lastPSException.getIndex() && curPSE.getPattern().equals(this.lastPSException.getPattern())) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning("Repeated Formulation Error: " + e.getMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.Formulation"), 0, null);
                }
            }
            this.searchEngine.stopExecution();
            this.lastPSException = (PatternSyntaxException)e;
        } else {
            super.handleException(e);
        }
    }

    @Override
    public void updateLocale() {
        this.repaint();
    }

    @Override
    protected Query getQuery() {
        Query query = super.getQuery();
        if (query != null) {
            query.getResult().setPageSize(Integer.MAX_VALUE);
        }
        return query;
    }

    protected void close() {
        if (this.viewerManager != null) {
            this.viewerManager.destroyViewer((AbstractViewer)((Object)this.resultViewer));
            this.viewerManager.getTranscription().removeACMEditListener(this);
        }
    }

    @Override
    protected void export() {
        ExportResultDialog dialog = new ExportResultDialog((Frame)((JFrame)SwingUtilities.getRoot(this)), true, (TranscriptionImpl)this.viewerManager.getTranscription(), (ContentQuery)this.queryManager.getCurrentQuery());
        dialog.setVisible(true);
    }

    @Override
    protected void read() {
        String lastDir = Preferences.getString(LAST_DIR_KEY, this.viewerManager.getTranscription());
        FileChooser fc = new FileChooser(this);
        fc.createAndShowFileDialog(null, 0, FileExtension.EAQ_EXT, LAST_DIR_KEY);
        if (fc.getSelectedFile() != null) {
            String selectedFile = fc.getSelectedFile().toString();
            ContentQuery query = new ContentQuery(null, new EAFType());
            try {
                Xml2Query.translate(selectedFile, query);
                this.addQuery(query);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.QueryReadError"), 0);
            }
        }
    }

    @Override
    protected void save() {
        FileChooser fc = new FileChooser(this);
        fc.createAndShowFileDialog(null, 1, FileExtension.EAQ_EXT, LAST_DIR_KEY);
        if (fc.getSelectedFile() != null) {
            Object selectedFile = fc.getSelectedFile().toString();
            if (!((String)selectedFile).endsWith(FileExtension.EAQ_EXT[0])) {
                selectedFile = (String)selectedFile + "." + FileExtension.EAQ_EXT[0];
            }
            try {
                Query2Xml.translate((String)selectedFile, (ContentQuery)this.queryManager.getCurrentQuery());
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), SearchLocale.getString("Search.Exception.QuerySaveError"), 0);
            }
        }
    }

    @Override
    protected void updateActions() {
        super.updateActions();
        this.replaceAction.setEnabled(this.exportAction.isEnabled());
    }

    @Override
    protected void userQuit() {
        this.close();
        super.userQuit();
    }

    private void replace() {
        String replaceString = JOptionPane.showInputDialog(this, SearchLocale.getString("ReplaceDialog.Message"), SearchLocale.getString("ReplaceDialog.Title"), -1);
        if (replaceString != null) {
            Command command = ELANCommandFactory.createCommand(this.viewerManager.getTranscription(), "CommandActions.Replace");
            Object[] args = new Object[]{this.queryManager.getCurrentQuery().getResult(), replaceString};
            command.execute(this.viewerManager.getTranscription(), args);
        }
    }

    private void updateResultViewer() {
        if (this.queryManager.hasQuery()) {
            ContentQuery query = (ContentQuery)this.queryManager.getCurrentQuery();
            String[] tierNames = query.getAnchorConstraint().getTierNames();
            boolean multipleTiers = tierNames.length > 1 || tierNames.length == 1 && tierNames[0] == "Search.Constraint.AllTiers";
            ((ElanResultViewer)this.resultViewer).setColumnVisible("ColumnTierName", multipleTiers);
        }
    }
}

