/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.prefs.gui.RecentLanguagesBox;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerFactory;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerInitializationException;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.util.Pair;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;

public class AddSpellCheckerDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private static final int DEFAULT_MINIMUM_HEIGHT = 260;
    private static final int DEFAULT_MINIMUM_WIDTH = 700;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel dataFieldPanel;
    private JComboBox checkerTypeBox;
    private JComboBox newLanguageComboBox;
    List<LangInfo> languageList;
    List<JTextField> textFields = new ArrayList<JTextField>();
    Map<String, JTextField> textFieldMap = new HashMap<String, JTextField>();
    private SpellChecker spellChecker;
    private LangInfo langInfo;
    private JLabel checkerTypeLabel;
    private JLabel languageLabel;
    private Transcription transcription = null;

    public AddSpellCheckerDialog(JDialog owner, boolean modal, Transcription transcription) {
        super((Dialog)owner, modal);
        this.transcription = transcription;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.dataFieldPanel = new JPanel(new BorderLayout());
        Container dialogPane = this.getContentPane();
        dialogPane.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        dialogPane.add((Component)this.titlePanel, gridBagConstraints);
        JPanel checkerInfoPanel = new JPanel();
        checkerInfoPanel.setLayout(new GridBagLayout());
        this.checkerTypeLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        checkerInfoPanel.add((Component)this.checkerTypeLabel, gridBagConstraints);
        this.checkerTypeBox = new JComboBox();
        this.checkerTypeBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        checkerInfoPanel.add((Component)this.checkerTypeBox, gridBagConstraints);
        String[] spellCheckerTypes = SpellCheckerFactory.getTypes();
        for (SpellCheckerFactory.SpellCheckerType type : SpellCheckerFactory.SpellCheckerType.values()) {
            this.checkerTypeBox.addItem(type);
        }
        this.languageLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        checkerInfoPanel.add((Component)this.languageLabel, gridBagConstraints);
        this.newLanguageComboBox = this.transcription != null ? new RecentLanguagesBox(null) : this.getNewLanguageComboBox();
        this.newLanguageComboBox.addItemListener(this);
        this.newLanguageComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        checkerInfoPanel.add((Component)this.newLanguageComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        dialogPane.add((Component)checkerInfoPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        dialogPane.add((Component)this.dataFieldPanel, gridBagConstraints);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 1, 0, 2));
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        dialogPane.add((Component)this.buttonPanel, gridBagConstraints);
        this.setLocationRelativeTo(this.getParent());
    }

    private void postInit() {
        this.addCloseActions();
        this.updateLocale();
        this.setPosition();
        this.updateNewLanguageComboBox();
    }

    private void updateLocale() {
        this.titleLabel.setText(ElanLocale.getString("AddSpellCheckerDialog.Label.Add"));
        this.checkerTypeLabel.setText(ElanLocale.getString("AddSpellCheckerDialog.Label.Type"));
        this.languageLabel.setText(ElanLocale.getString("Button.Language"));
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (arg0.getSource() == this.checkerTypeBox) {
            this.updateFieldsForSelectedType();
        } else if (arg0.getSource() == this.newLanguageComboBox) {
            this.langInfo = (LangInfo)this.newLanguageComboBox.getSelectedItem();
        }
    }

    private void updateFieldsForSelectedType() {
        SpellCheckerFactory.SpellCheckerType type = (SpellCheckerFactory.SpellCheckerType)((Object)this.checkerTypeBox.getSelectedItem());
        this.dataFieldPanel.removeAll();
        this.dataFieldPanel.add((Component)this.createPanelForType(type), "Center");
        this.dataFieldPanel.invalidate();
        this.dataFieldPanel.revalidate();
        this.dataFieldPanel.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.okButton) {
            this.createSpellChecker();
            this.closeDialog();
        } else if (ae.getSource() == this.cancelButton) {
            this.closeDialog();
        }
    }

    private void createSpellChecker() {
        block3: {
            HashMap<String, String> spellCheckerSettings = new HashMap<String, String>();
            for (Map.Entry<String, JTextField> entry : this.textFieldMap.entrySet()) {
                spellCheckerSettings.put(entry.getKey(), entry.getValue().getText());
            }
            try {
                this.spellChecker = SpellCheckerFactory.create((SpellCheckerFactory.SpellCheckerType)((Object)this.checkerTypeBox.getSelectedItem()), spellCheckerSettings);
                this.spellChecker.initializeSpellChecker();
            }
            catch (SpellCheckerInitializationException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                ClientLogger.LOG.warning("Could not create a spell checker (" + e.getMessage() + ")");
            }
        }
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }

    public LangInfo getLangInfo() {
        return this.langInfo;
    }

    private JPanel createPanelForType(SpellCheckerFactory.SpellCheckerType type) {
        this.textFieldMap.clear();
        ArrayList<Pair<String, String>> fields = SpellCheckerFactory.getDataFields(type);
        JPanel panel = new JPanel(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        int gridy = 0;
        for (Pair<String, String> field : fields) {
            JTextField textField;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = insets;
            JLabel label = new JLabel(ElanLocale.getString(field.getSecond()));
            panel.add((Component)label, gridBagConstraints);
            if (field.getFirst().equals("password")) {
                textField = new JPasswordField();
            } else if (field.getFirst().equals("path")) {
                textField = new JTextField();
                textField.setEditable(false);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 2;
                gridBagConstraints.gridy = gridy;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.insets = insets;
                JButton browseButton = new JButton();
                browseButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddSpellCheckerDialog.this.getFile(textField);
                    }
                });
                browseButton.setText(ElanLocale.getString("Button.Browse"));
                panel.add((Component)browseButton, gridBagConstraints);
            } else {
                textField = new JTextField();
            }
            this.textFieldMap.put(field.getFirst(), textField);
            label.setLabelFor(textField);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = gridy++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = insets;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            panel.add((Component)textField, gridBagConstraints);
        }
        panel.validate();
        return panel;
    }

    private void getFile(JTextComponent textComponent) {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(new String[]{"dic"});
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("HunspellChecker.DataField.Browse.Title"), 0, new String[]{"dic"}, null);
        File impFile = chooser.getSelectedFile();
        if (impFile != null) {
            textComponent.setText(impFile.getAbsolutePath());
        }
    }

    protected void setPosition() {
        this.pack();
        this.setSize(Math.max(this.getSize().width, 700), Math.max(this.getSize().height, 260));
        this.setLocationRelativeTo(this.getParent());
    }

    protected JComboBox getNewLanguageComboBox() {
        JComboBox box = new JComboBox();
        box.setEditable(false);
        return box;
    }

    protected void updateNewLanguageComboBox() {
        if (!(this.newLanguageComboBox instanceof RecentLanguagesBox)) {
            LanguageCollection.setLocalCacheFolder(Constants.ELAN_DATA_DIR);
            List<LangInfo> languages = LanguageCollection.getLanguages();
            LanguagesListModel m = new LanguagesListModel(languages);
            this.newLanguageComboBox.setPrototypeDisplayValue(languages.get(0));
            this.newLanguageComboBox.setModel(m);
        }
    }

    int getNumberOfLanguages() {
        return this.languageList.size();
    }

    private static class LanguagesListModel
    extends AbstractListModel
    implements ComboBoxModel {
        final List<LangInfo> languages;
        final int size;
        Object selectedItem;

        LanguagesListModel(List<LangInfo> languages) {
            this.languages = languages;
            this.size = languages.size();
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0) {
                return "";
            }
            if (index < this.size) {
                return this.languages.get(index);
            }
            return "";
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

