/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.spellcheck.AddSpellCheckerDialog;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerRegistry;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.util.Pair;
import mpi.eudico.util.multilangcv.LanguageCollection;

public class EditSpellCheckerDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private static final int DEFAULT_MINIMUM_HEIGHT = 260;
    private static final int DEFAULT_MINIMUM_WIDTH = 700;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel checkerInfoPanel;
    private JLabel checkerNameLabel;
    private JComboBox checkerNameBox;
    private JLabel checkerInfoLabel;
    private JTextArea checkerInfoText;
    private JPanel checkerButtonPanel;
    private JButton addCheckerButton;
    private JButton deleteCheckerButton;
    private JPanel closeButtonPanel;
    private JButton closeButton;
    private Transcription transcription = null;

    public EditSpellCheckerDialog(Frame owner, boolean modal) {
        super(owner, modal);
        ViewerManager2 vm;
        if (owner != null && owner instanceof ElanFrame2 && (vm = ((ElanFrame2)owner).getViewerManager()) != null) {
            this.transcription = vm.getTranscription();
        }
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditSpellCheckerDialog.this.closeDialog();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.checkerInfoPanel = new JPanel();
        this.checkerInfoPanel.setLayout(new GridBagLayout());
        this.checkerNameLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.checkerInfoPanel.add((Component)this.checkerNameLabel, gridBagConstraints);
        this.checkerNameBox = new JComboBox();
        this.checkerNameBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.checkerInfoPanel.add((Component)this.checkerNameBox, gridBagConstraints);
        this.checkerInfoLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.checkerInfoPanel.add((Component)this.checkerInfoLabel, gridBagConstraints);
        this.checkerInfoText = new JTextArea();
        this.checkerInfoText.setLineWrap(true);
        this.checkerInfoText.setWrapStyleWord(true);
        this.checkerInfoText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.checkerInfoPanel.add((Component)new JScrollPane(this.checkerInfoText), gridBagConstraints);
        this.checkerButtonPanel = new JPanel();
        this.checkerButtonPanel.setLayout(new GridLayout(0, 1, 6, 6));
        this.addCheckerButton = new JButton();
        this.addCheckerButton.addActionListener(this);
        this.checkerButtonPanel.add(this.addCheckerButton);
        this.deleteCheckerButton = new JButton();
        this.deleteCheckerButton.setEnabled(false);
        this.deleteCheckerButton.addActionListener(this);
        this.checkerButtonPanel.add(this.deleteCheckerButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        this.checkerInfoPanel.add((Component)this.checkerButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.checkerInfoPanel, gridBagConstraints);
        this.closeButtonPanel = new JPanel();
        this.closeButtonPanel.setLayout(new GridLayout(1, 1, 0, 2));
        this.closeButton = new JButton();
        this.closeButton.addActionListener(this);
        this.closeButtonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.closeButtonPanel, gridBagConstraints);
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.updateUIforSelectedChecker();
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void postInit() {
        this.addCloseActions();
        this.updateLocale();
        this.setPosition();
        this.updateCheckerNameBox();
        this.updateUIforSelectedChecker();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("EditSpellCheckerDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("EditSpellCheckerDialog.Title"));
        this.checkerNameLabel.setText(ElanLocale.getString("EditSpellCheckerDialog.Label.Checkername"));
        this.checkerInfoLabel.setText(ElanLocale.getString("EditSpellCheckerDialog.Label.Checkerinfo"));
        this.addCheckerButton.setText(ElanLocale.getString("Button.Add"));
        this.deleteCheckerButton.setText(ElanLocale.getString("Button.Delete"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    protected void setPosition() {
        this.pack();
        this.setSize(Math.max(this.getSize().width, 700), Math.max(this.getSize().height, 260));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addCheckerButton) {
            this.showSpellCheckerWizard(null);
        } else if (ae.getSource() == this.deleteCheckerButton) {
            this.deleteChecker();
        } else if (ae.getSource() == this.closeButton) {
            this.closeDialog();
        }
    }

    private void deleteChecker() {
        Pair pair = (Pair)this.checkerNameBox.getSelectedItem();
        SpellCheckerRegistry.getInstance().delete((String)pair.getFirst());
        this.updateCheckerNameBox();
        this.updateUIforSelectedChecker();
    }

    private void updateCheckerNameBox() {
        this.checkerNameBox.removeItemListener(this);
        SpellCheckerRegistry checkerRegistry = SpellCheckerRegistry.getInstance();
        Set<String> checkerIds = checkerRegistry.getSpellCheckers().keySet();
        this.checkerNameBox.removeAllItems();
        for (String next : checkerIds) {
            this.checkerNameBox.addItem(new Pair<String, SpellChecker>(next, checkerRegistry.getSpellChecker(next)));
        }
        if (checkerIds.size() > 0) {
            this.checkerNameBox.setSelectedIndex(0);
        }
        this.checkerNameBox.addItemListener(this);
    }

    private void updateUIforSelectedChecker() {
        if (this.checkerNameBox.getSelectedIndex() > -1) {
            Pair pair = (Pair)this.checkerNameBox.getSelectedItem();
            String langRef = (String)pair.getFirst();
            SpellChecker checker = (SpellChecker)pair.getSecond();
            String langStr = ElanLocale.getString("Button.Language");
            String typeStr = ElanLocale.getString("EditSpellCheckerDialog.Label.Type");
            String infoStr = ElanLocale.getString("EditSpellCheckerDialog.Label.Info");
            String descStr = ElanLocale.getString("EditSpellCheckerDialog.Label.Description");
            this.checkerInfoText.setText(langStr + ": " + LanguageCollection.getLanguageInfo(langRef).getLabel() + "\n" + typeStr + ": " + checker.getType() + "\n" + infoStr + ": " + checker.getInfo() + "\n" + descStr + ": " + checker.getDescription());
            this.deleteCheckerButton.setEnabled(true);
        } else {
            this.checkerInfoText.setText("");
            this.deleteCheckerButton.setEnabled(false);
        }
    }

    private void showSpellCheckerWizard(SpellChecker checker) {
        AddSpellCheckerDialog dialog = new AddSpellCheckerDialog(this, true, this.transcription);
        dialog.setVisible(true);
        if (dialog.getSpellChecker() != null) {
            SpellCheckerRegistry.getInstance().putSpellChecker(dialog.getLangInfo().getId(), dialog.getSpellChecker());
            this.updateCheckerNameBox();
            this.updateUIforSelectedChecker();
        }
    }
}

