/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.spellcheck;

import com.atlascopco.hunspell.Hunspell;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mpi.eudico.client.annotator.spellcheck.SpellChecker;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerFactory;
import mpi.eudico.client.annotator.spellcheck.SpellCheckerInitializationException;
import mpi.eudico.util.Pair;

public class HunspellChecker
implements SpellChecker {
    private String description = "A spellchecker that uses localy installed Hunspell dictionaries. See also http://hunspell.github.io/";
    private SpellCheckerFactory.SpellCheckerType type = SpellCheckerFactory.SpellCheckerType.HUNSPELL;
    private String filePath;
    private Hunspell dict;
    private Set<String> newWords = new HashSet<String>();

    public HunspellChecker(String filePath) {
        this.filePath = filePath.endsWith(".dic") ? filePath.substring(0, filePath.length() - 4) : filePath;
    }

    public static HunspellChecker create(HashMap<String, String> args) {
        if (args.containsKey("path")) {
            return new HunspellChecker(args.get("path"));
        }
        return null;
    }

    public static ArrayList<Pair<String, String>> getDataFields() {
        ArrayList<Pair<String, String>> fields = new ArrayList<Pair<String, String>>();
        fields.add(new Pair<String, String>("path", "HunspellChecker.DataField.Path"));
        return fields;
    }

    @Override
    public void initializeSpellChecker() throws SpellCheckerInitializationException {
        try {
            this.dict = new Hunspell(this.filePath + ".dic", this.filePath + ".aff");
        }
        catch (UnsatisfiedLinkError e) {
            throw new SpellCheckerInitializationException("No Hunspell dictionary could be opened from " + this.filePath + " - " + e.getMessage(), e);
        }
        catch (UnsupportedOperationException e) {
            throw new SpellCheckerInitializationException("No Hunspell dictionary could be opened from " + this.filePath + " - " + e.getMessage(), e);
        }
    }

    @Override
    public void setType(SpellCheckerFactory.SpellCheckerType type) {
        this.type = type;
    }

    @Override
    public SpellCheckerFactory.SpellCheckerType getType() {
        return this.type;
    }

    @Override
    public String getInfo() {
        return this.filePath;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPreferencesString() {
        return this.type + "," + this.filePath;
    }

    public String toString() {
        return "Hunspell: " + this.getInfo();
    }

    @Override
    public List<Pair<String, List<String>>> getSuggestions(String text) {
        ArrayList<Pair<String, List<String>>> suggestions = new ArrayList<Pair<String, List<String>>>();
        String[] words = text.split("\\b");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (!word.matches(".*\\p{L}.*")) continue;
            List wordSuggestions = this.isCorrect(word) == false ? this.dict.suggest(word) : new ArrayList();
            suggestions.add(new Pair(word, wordSuggestions));
        }
        return suggestions;
    }

    @Override
    public Boolean isCorrect(String text) {
        String[] words = text.split("\\s+");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (this.dict.spell(word)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addUserDefinedWord(String word) {
        this.newWords.add(word);
    }

    @Override
    public Set<String> getUserDefinedWords() {
        return this.newWords;
    }
}

