/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class AnnotationsFromGapsDlg
extends ClosableDialog
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private TranscriptionImpl transcription;
    private long mediaDuration;
    private JPanel tierPanel;
    private JPanel optionsPanel;
    private JPanel buttonPanel;
    private JButton selectAllButton;
    private JButton selectNoneButton;
    private JButton closeButton;
    private JButton startButton;
    private JComboBox onTierCB;
    private JLabel titleLabel;
    private JList tierList;
    private DefaultListModel model;
    private JRadioButton onSameTierRB;
    private JRadioButton onNewTierRB;
    private JLabel tierNameLabel;
    private JTextField tierNameTF;
    private JRadioButton emptyRB;
    private JRadioButton durationRB;
    private JRadioButton valueRB;
    private JRadioButton msRB;
    private JRadioButton secRB;
    private JRadioButton hourRB;
    private JTextField annValueTF;

    public AnnotationsFromGapsDlg(Frame owner, TranscriptionImpl transcription, long mediaDuration) throws HeadlessException {
        super(owner);
        this.transcription = transcription;
        this.mediaDuration = mediaDuration;
        this.initComponents();
        this.extractTiers();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.tierPanel = new JPanel();
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.selectAllButton = new JButton();
        this.selectAllButton.addActionListener(this);
        this.selectNoneButton = new JButton();
        this.selectNoneButton.addActionListener(this);
        this.model = new DefaultListModel();
        this.tierList = new JList(this.model);
        this.tierList.setSelectionMode(2);
        this.tierList.addListSelectionListener(this);
        this.onTierCB = new JComboBox();
        this.onSameTierRB = new JRadioButton();
        this.onSameTierRB.setSelected(true);
        this.onSameTierRB.addChangeListener(this);
        this.onNewTierRB = new JRadioButton();
        this.onNewTierRB.addChangeListener(this);
        this.tierNameLabel = new JLabel();
        this.tierNameTF = new JTextField();
        this.tierNameTF.setEnabled(false);
        this.emptyRB = new JRadioButton();
        this.emptyRB.setSelected(true);
        this.emptyRB.addChangeListener(this);
        this.durationRB = new JRadioButton();
        this.durationRB.addChangeListener(this);
        this.valueRB = new JRadioButton();
        this.valueRB.addChangeListener(this);
        this.msRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        this.msRB.setSelected(true);
        this.msRB.setEnabled(false);
        this.secRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.Seconds"));
        this.secRB.setEnabled(false);
        this.hourRB = new JRadioButton(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.hourRB.setEnabled(false);
        this.annValueTF = new JTextField();
        this.annValueTF.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.msRB);
        bg.add(this.secRB);
        bg.add(this.hourRB);
        ButtonGroup bg2 = new ButtonGroup();
        bg2.add(this.onSameTierRB);
        bg2.add(this.onNewTierRB);
        ButtonGroup bg3 = new ButtonGroup();
        bg3.add(this.emptyRB);
        bg3.add(this.durationRB);
        bg3.add(this.valueRB);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.titleLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.tierPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.tierPanel.setLayout(new GridBagLayout());
        Dimension tableDim = new Dimension(450, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierList);
        tierScrollPane.setPreferredSize(tableDim);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)tierScrollPane, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = insets;
        gbc.anchor = 17;
        this.tierPanel.add((Component)this.selectAllButton, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.gridy = 1;
        gbc.gridy = 1;
        this.tierPanel.add((Component)this.selectNoneButton, gbc);
        this.optionsPanel.setLayout(new GridBagLayout());
        insets.bottom = 3;
        JLabel destLabel = new JLabel(ElanLocale.getString("FillGapsDialog.Label.Destination"));
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        this.optionsPanel.add((Component)destLabel, gbc);
        gbc.insets = new Insets(2, 16, 2, 6);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        this.optionsPanel.add((Component)this.onSameTierRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.onTierCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        this.optionsPanel.add((Component)this.onNewTierRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.tierNameTF, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(24, 6, 2, 6);
        this.optionsPanel.add((Component)new JLabel(ElanLocale.getString("FillGapsDialog.Label.AnnotationValue")), gbc);
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(2, 16, 2, 6);
        this.optionsPanel.add((Component)this.valueRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.optionsPanel.add((Component)this.annValueTF, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.gridwidth = 3;
        this.optionsPanel.add((Component)this.durationRB, gbc);
        gbc.gridy = 7;
        gbc.insets = new Insets(2, 32, 2, 6);
        this.optionsPanel.add((Component)this.msRB, gbc);
        gbc.gridy = 8;
        this.optionsPanel.add((Component)this.secRB, gbc);
        gbc.gridy = 9;
        this.optionsPanel.add((Component)this.hourRB, gbc);
        gbc.gridy = 4;
        gbc.insets = new Insets(2, 16, 2, 6);
        this.optionsPanel.add((Component)this.emptyRB, gbc);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        this.updateLocale();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("FillGapsDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("FillGapsDialog.Title"));
        this.tierPanel.setBorder(new TitledBorder(ElanLocale.getString("FillGapsDialog.Label.SelectTiers")));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("LabelAndNumberDialog.Label.Options")));
        this.onSameTierRB.setText(ElanLocale.getString("FillGapsDialog.Label.SameTier"));
        this.onNewTierRB.setText(ElanLocale.getString("FillGapsDialog.Label.NewTier"));
        this.tierNameLabel.setText(ElanLocale.getString("FillGapsDialog.Label.NewTierName"));
        this.emptyRB.setText(ElanLocale.getString("FillGapsDialog.Label.Empty"));
        this.durationRB.setText(ElanLocale.getString("FillGapsDialog.Label.Duration"));
        this.valueRB.setText(ElanLocale.getString("FillGapsDialog.Label.SpecifyValue"));
        this.startButton.setText(ElanLocale.getString("Button.OK"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
        this.selectAllButton.setText(ElanLocale.getString("Button.SelectAll"));
        this.selectNoneButton.setText(ElanLocale.getString("Button.SelectNone"));
    }

    private void extractTiers() {
        if (this.transcription != null) {
            List<TierImpl> v = this.transcription.getTiers();
            for (int i = 0; i < v.size(); ++i) {
                TierImpl t = v.get(i);
                if (t.getParentTier() != null || !t.isTimeAlignable()) continue;
                this.model.addElement(t.getName());
                this.onTierCB.addItem(t.getName());
            }
            if (this.model.getSize() > 0) {
                this.tierList.setSelectedIndex(0);
            } else {
                this.startButton.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.selectAllButton) {
            this.tierList.setSelectionInterval(0, this.model.getSize() - 1);
        } else if (e.getSource() == this.selectNoneButton) {
            this.tierList.clearSelection();
        } else if (e.getSource() == this.closeButton) {
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.startButton) {
            String nTierName;
            Object[] tierNamesTemp = this.tierList.getSelectedValues();
            String[] tierNames = new String[tierNamesTemp.length];
            for (int i = 0; i < tierNames.length; ++i) {
                tierNames[i] = (String)tierNamesTemp[i];
            }
            if (tierNames == null || tierNames.length <= 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("LabelAndNumberDialog.Warning.NoTier"), ElanLocale.getString("Message.Error"), 2);
                return;
            }
            if (this.onNewTierRB.isSelected()) {
                nTierName = this.tierNameTF.getText();
                if (nTierName == null || nTierName.length() == 0) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Message.Error"), 2);
                    return;
                }
                if (this.transcription.getTierWithId(nTierName) != null) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 2);
                    return;
                }
            } else {
                nTierName = (String)this.onTierCB.getSelectedItem();
            }
            String annValue = null;
            String format = null;
            if (this.valueRB.isSelected()) {
                annValue = this.annValueTF.getText();
            } else if (this.durationRB.isSelected()) {
                if (this.msRB.isSelected()) {
                    format = "ms";
                } else if (this.secRB.isSelected()) {
                    format = "ss.ms";
                } else if (this.hourRB.isSelected()) {
                    format = "hh:mm:ss.ms";
                }
            }
            Object[] arg = new Object[]{tierNames, nTierName, annValue, format, new Long(this.mediaDuration)};
            Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsFromGaps");
            com.execute(this.transcription, arg);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.onSameTierRB || e.getSource() == this.onNewTierRB) {
            this.onTierCB.setEnabled(this.onSameTierRB.isSelected() && this.onSameTierRB.isEnabled());
            this.tierNameTF.setEnabled(this.onNewTierRB.isSelected());
        } else if (e.getSource() == this.valueRB) {
            this.annValueTF.setEnabled(this.valueRB.isSelected());
        } else if (e.getSource() == this.durationRB) {
            boolean b = this.durationRB.isSelected();
            this.msRB.setEnabled(b);
            this.secRB.setEnabled(b);
            this.hourRB.setEnabled(b);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        JList list = (JList)event.getSource();
        int nrSelectedItems = list.getSelectedIndices().length;
        int firstSelectedIndex = list.getSelectedIndex();
        switch (nrSelectedItems) {
            case 0: {
                this.startButton.setEnabled(false);
                this.onSameTierRB.setEnabled(false);
                this.onSameTierRB.setSelected(true);
                this.onTierCB.setEnabled(false);
                this.onNewTierRB.setEnabled(false);
                this.tierNameTF.setEnabled(false);
                this.emptyRB.setEnabled(false);
                this.durationRB.setEnabled(false);
                this.valueRB.setEnabled(false);
                this.msRB.setEnabled(false);
                this.secRB.setEnabled(false);
                this.hourRB.setEnabled(false);
                this.annValueTF.setEnabled(false);
                break;
            }
            case 1: {
                this.onTierCB.removeAllItems();
                this.onTierCB.addItem(this.tierList.getSelectedValue());
                if (firstSelectedIndex >= 0) {
                    this.onTierCB.setSelectedIndex(0);
                }
                this.startButton.setEnabled(true);
                this.onSameTierRB.setEnabled(true);
                this.onNewTierRB.setEnabled(true);
                this.tierNameTF.setEnabled(this.onNewTierRB.isSelected());
                this.emptyRB.setEnabled(true);
                this.durationRB.setEnabled(true);
                this.valueRB.setEnabled(true);
                this.annValueTF.setEnabled(this.valueRB.isSelected());
                break;
            }
            default: {
                this.onTierCB.removeAllItems();
                for (int i = 0; i < nrSelectedItems; ++i) {
                    this.onTierCB.addItem(this.tierList.getSelectedValues()[i]);
                }
                if (firstSelectedIndex >= 0) {
                    this.onTierCB.setSelectedIndex(0);
                }
                this.startButton.setEnabled(true);
                this.onSameTierRB.setEnabled(true);
                this.onNewTierRB.setEnabled(true);
                this.tierNameTF.setEnabled(this.onNewTierRB.isSelected());
                this.emptyRB.setEnabled(true);
                this.durationRB.setEnabled(true);
                this.valueRB.setEnabled(true);
                this.annValueTF.setEnabled(this.valueRB.isSelected());
            }
        }
    }
}

