/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.AbstractFileAndTierSelectionStepPane;
import mpi.eudico.client.annotator.tier.DisplayableContentTableModel;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.EmptyStringComparator;

public class CopyAnnotationsOfTierStep1
extends AbstractFileAndTierSelectionStepPane
implements ListSelectionListener {
    public CopyAnnotationsOfTierStep1(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane, transcription);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.tierTable.getSelectionModel().addListSelectionListener(this);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CopyAnnotationsDialog.SelectSource");
    }

    @Override
    public void enterStepForward() {
    }

    @Override
    public boolean leaveStepForward() {
        if (this.tierTable.getSelectedRow() < 0) {
            return false;
        }
        return super.leaveStepForward();
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, this.tierTable.getSelectedRow() > -1);
        this.multiPane.setButtonEnabled(2, Boolean.FALSE);
    }

    @Override
    public boolean leaveStepBackward() {
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int row;
        if (!e.getValueIsAdjusting() && (row = this.tierTable.getSelectedRow()) > -1) {
            int col = this.tierTable.convertColumnIndexToModel(0);
            for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                if (i != row) {
                    this.tierTable.setValueAt(Boolean.FALSE, i, col);
                    continue;
                }
                this.tierTable.setValueAt(Boolean.TRUE, i, col);
            }
        }
        this.multiPane.setButtonEnabled(1, this.tierTable.getSelectedRow() > -1);
    }

    @Override
    protected void initTierSelectionPanel() {
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        this.globalInset = new Insets(5, 10, 5, 10);
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("CopyAnnotationsDialog.SelectSource")));
        this.tierTable = new JTable();
        this.tierTable.setSelectionMode(0);
        this.tierTable.setShowVerticalLines(true);
        if (this.transcription != null) {
            String[] tierArray = this.tierSet.toArray(new String[0]);
            String[] linguisticArray = new String[tierArray.length];
            for (int i = 0; i < tierArray.length; ++i) {
                TierImpl tier = this.transcription.getTierWithId(tierArray[i]);
                linguisticArray[i] = tier.getLinguisticType().getLinguisticTypeName();
            }
            SelectableContentTableModel model = new SelectableContentTableModel(new Object[][]{tierArray, linguisticArray}, new String[]{ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"), ElanLocale.getString("FileAndTierSelectionStepPane.Column.LinguisticType")});
            model.addTableModelListener(new AbstractFileAndTierSelectionStepPane.ModelChangedHandler());
            this.tierTable.setModel(model);
            this.tierTable.getColumnModel().getColumn(0).setMaxWidth(30);
            TableRowSorter<SelectableContentTableModel> rowSorter = new TableRowSorter<SelectableContentTableModel>(model);
            EmptyStringComparator emptyComp = new EmptyStringComparator();
            for (int i = 1; i < this.tierTable.getColumnCount(); ++i) {
                rowSorter.setComparator(i, emptyComp);
            }
            this.tierTable.setRowSorter(rowSorter);
        } else {
            DisplayableContentTableModel model = new DisplayableContentTableModel(ElanLocale.getString("FileAndTierSelectionStepPane.Message1"));
            this.tierTable.setModel(model);
            this.tierTable.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.Header.Message"));
        }
        this.tierTableScrollPane = new JScrollPane(this.tierTable);
        this.tierTableScrollPane.setColumnHeaderView(null);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = this.globalInset;
        this.tierSelectionPanel.add((Component)this.tierTableScrollPane, gbc);
    }

    @Override
    public void updateButtonStates() {
    }
}

