/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.CopyAnnotationsOfTierCommand;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.AbstractProgressStepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CopyAnnotationsOfTierStep4
extends AbstractProgressStepPane {
    private TranscriptionImpl transcription;
    private List<String> openFiles;
    private String sourceTierName;
    private String targetTierName;
    private String copyMode;
    private String queryValue;
    private Boolean useRegex;
    private Boolean overwrite;

    public CopyAnnotationsOfTierStep4(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CopyAnnotationsDialog.ProgressStep.Title");
    }

    @Override
    public void enterStepForward() {
        List selTiers = (List)this.multiPane.getStepProperty("SelectedTiers");
        if (selTiers == null || selTiers.size() <= 0) {
            this.showWarningDialog("The source tier is undefined, cannot copy.");
            return;
        }
        this.sourceTierName = (String)selTiers.get(0);
        this.targetTierName = (String)this.multiPane.getStepProperty("TargetTier");
        if (this.targetTierName == null) {
            this.showWarningDialog("The destination tier is undefined, cannot copy.");
            return;
        }
        this.copyMode = (String)this.multiPane.getStepProperty("CopyMode");
        this.queryValue = (String)this.multiPane.getStepProperty("QueryValue");
        this.useRegex = (Boolean)this.multiPane.getStepProperty("UseRegex");
        this.overwrite = (Boolean)this.multiPane.getStepProperty("Overwrite");
        if (this.transcription == null) {
            this.openFiles = (List)this.multiPane.getStepProperty("OpenedFiles");
        }
        super.enterStepForward();
    }

    @Override
    public void startProcess() {
        CopyAnnotationsOfTierCommand com = (CopyAnnotationsOfTierCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.CopyAnnotationsOfTier");
        Object[] args = new Object[]{this.sourceTierName, this.targetTierName, this.copyMode, this.queryValue, this.useRegex, this.overwrite};
        com.addProgressListener(this);
        com.execute(this.transcription, args);
    }
}

