/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.RadioButtonCellEditor;
import mpi.eudico.client.util.RadioButtonTableCellRenderer;
import mpi.eudico.client.util.SelectEnableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CreateAnnsOnDependentTiersStep2
extends StepPane
implements TableModelListener {
    private TranscriptionImpl transcription;
    private JTable tierTable;
    private DefaultTableModel model;
    private JCheckBox overWriteCB;
    private List<String> selectedParentTiers;
    private List<String> emptyAnnTierList = new ArrayList<String>();
    private List<String> annWithValTierList = new ArrayList<String>();
    private final String TIER_NAME_COLUMN = "Tiers";
    private final String EMPTY_ANNOTATION_COLUMN = "Empty Annotations";
    private final String ANNOTATION_WITH_VAL_COLUMN = "Annotation With Value of Parent";
    private static final int EMPTY_COL = 2;
    private static final int WITH_VAL_COL = 3;

    public CreateAnnsOnDependentTiersStep2(MultiStepPane multiPane, TranscriptionImpl trans) {
        super(multiPane);
        this.transcription = trans;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.model = new TierExportTableModel();
        this.model.addTableModelListener(this);
        this.model.setColumnIdentifiers(new String[]{"", "Tiers", "Empty Annotations", "Annotation With Value of Parent"});
        this.tierTable = new TierExportTable(this.model, true);
        this.tierTable.getColumn("Empty Annotations").setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.tierTable.getColumn("Empty Annotations").setCellRenderer(new RadioButtonTableCellRenderer());
        this.tierTable.getColumn("Empty Annotations").setWidth(75);
        this.tierTable.getColumn("Annotation With Value of Parent").setCellEditor(new RadioButtonCellEditor(new JCheckBox()));
        this.tierTable.getColumn("Annotation With Value of Parent").setCellRenderer(new RadioButtonTableCellRenderer());
        this.tierTable.getColumn("Annotation With Value of Parent").setWidth(150);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Dimension tableDim = new Dimension(450, 100);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        tierScrollPane.setPreferredSize(tableDim);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)tierScrollPane, gridBagConstraints);
        this.overWriteCB = new JCheckBox(ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Label.Overwrite"));
        this.overWriteCB.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.add((Component)this.overWriteCB, gridBagConstraints);
    }

    private void extractTiers() {
        this.model.setRowCount(0);
        if (this.transcription != null) {
            for (int i = 0; i < this.selectedParentTiers.size(); ++i) {
                TierImpl t = this.transcription.getTierWithId(this.selectedParentTiers.get(i));
                List<TierImpl> v = t.getDependentTiers();
                for (int x = 0; x < v.size(); ++x) {
                    Boolean checked;
                    t = v.get(x);
                    SelectEnableObject<String> emptySEO = new SelectEnableObject<String>("", true, false);
                    SelectEnableObject<String> withValSEO = new SelectEnableObject<String>("", false, false);
                    if (i == 0 && x == 0) {
                        checked = Boolean.TRUE;
                        emptySEO.setEnabled(true);
                        withValSEO.setEnabled(true);
                    } else {
                        checked = Boolean.FALSE;
                    }
                    this.model.addRow(new Object[]{checked, t.getName(), emptySEO, withValSEO});
                }
            }
        }
    }

    private void updateSelectedTierList() {
        Object selObj = null;
        String nameObj = null;
        this.emptyAnnTierList.clear();
        this.annWithValTierList.clear();
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            selObj = this.model.getValueAt(i, 0);
            if (selObj != Boolean.TRUE) continue;
            SelectEnableObject emptyAnnSEO = (SelectEnableObject)this.model.getValueAt(i, 2);
            nameObj = (String)this.model.getValueAt(i, 1);
            if (nameObj == null) continue;
            if (emptyAnnSEO.isSelected()) {
                this.emptyAnnTierList.add(nameObj);
                continue;
            }
            this.annWithValTierList.add(nameObj);
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CreateAnnsOnDependentTiersDlg.Title");
    }

    @Override
    public void enterStepForward() {
        this.selectedParentTiers = (List)this.multiPane.getStepProperty("SelectedParentTiers");
        this.extractTiers();
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        this.multiPane.setButtonEnabled(4, true);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void enterStepBackward() {
    }

    @Override
    public boolean leaveStepForward() {
        return true;
    }

    @Override
    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        this.overWriteCB.setEnabled(false);
        return true;
    }

    @Override
    public boolean doFinish() {
        this.updateSelectedTierList();
        Object[] args = new Object[]{this.emptyAnnTierList, this.annWithValTierList, this.overWriteCB.isSelected()};
        Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AnnotationsOnDependentTiers");
        command.execute(this.transcription, args);
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int selectedRowIndex = e.getFirstRow();
        int selectedColumnIndex = e.getColumn();
        if (e.getType() != 0 || selectedRowIndex < 0 || selectedColumnIndex == -1) {
            return;
        }
        if (selectedColumnIndex == 0) {
            boolean enableRadioButtons = (Boolean)this.model.getValueAt(selectedRowIndex, 0);
            ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 2)).setEnabled(enableRadioButtons);
            ((SelectEnableObject)this.model.getValueAt(selectedRowIndex, 3)).setEnabled(enableRadioButtons);
        }
        if (this.model.getValueAt(selectedRowIndex, selectedColumnIndex) instanceof SelectEnableObject) {
            SelectEnableObject seo1 = (SelectEnableObject)this.model.getValueAt(selectedRowIndex, selectedColumnIndex);
            if (seo1.isSelected()) {
                SelectEnableObject seo2 = (SelectEnableObject)this.model.getValueAt(selectedRowIndex, 5 - selectedColumnIndex);
                if (seo2 != null && seo2.isEnabled()) {
                    seo2.setSelected(false);
                }
            } else {
                seo1.setSelected(true);
            }
        }
        this.updateSelectedTierList();
        boolean enableFinish = !this.emptyAnnTierList.isEmpty() || !this.annWithValTierList.isEmpty();
        this.multiPane.setButtonEnabled(3, enableFinish);
        boolean enableOverwrite = !this.annWithValTierList.isEmpty();
        this.overWriteCB.setEnabled(enableOverwrite);
        this.tierTable.repaint();
    }
}

