/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.OverlapsStep2;

public class MergeMultiTiersStep2
extends OverlapsStep2
implements KeyListener {
    private JCheckBox onlyOverlapsCB;
    private JCheckBox specificValueCB;
    private JTextField specificValueTF;
    private boolean validateCriteria = false;
    private boolean validCriteria = false;

    public MergeMultiTiersStep2(MultiStepPane mp, Frame owner) {
        super(mp, owner);
        this.makeLayout();
    }

    private void makeLayout() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeMultiTiersStep2.this.updateButtonStates();
                MergeMultiTiersStep2.this.specificValueTF.setEnabled(MergeMultiTiersStep2.this.specificValueCB.isSelected());
                MergeMultiTiersStep2.this.valuesTheSameRB.setEnabled(MergeMultiTiersStep2.this.onlyOverlapsCB.isSelected());
                MergeMultiTiersStep2.this.valuesDifferentRB.setEnabled(MergeMultiTiersStep2.this.onlyOverlapsCB.isSelected());
                MergeMultiTiersStep2.this.specificValueCB.setEnabled(MergeMultiTiersStep2.this.valuesTheSameRB.isEnabled() && MergeMultiTiersStep2.this.valuesTheSameRB.isSelected());
            }
        };
        this.onlyOverlapsCB = new JCheckBox(ElanLocale.getString("MergeTiers.CheckBox.Overlap"));
        this.onlyOverlapsCB.addActionListener(actionListener);
        this.specificValueCB = new JCheckBox(ElanLocale.getString("MergeTiers.Radio.SpecificValue"));
        this.specificValueCB.addActionListener(actionListener);
        this.specificValueTF = new JTextField();
        this.specificValueTF.setEnabled(false);
        this.specificValueTF.addKeyListener(this);
        this.valuesTheSameRB.addActionListener(actionListener);
        this.valuesTheSameRB.setEnabled(this.onlyOverlapsCB.isSelected());
        this.valuesDifferentRB.setEnabled(this.onlyOverlapsCB.isSelected());
        this.specificValueCB.setEnabled(this.valuesTheSameRB.isEnabled() && this.valuesTheSameRB.isSelected());
        this.createAnnotationLabel.setText(ElanLocale.getString("MergeTiers.Label.MergeAnn"));
        this.overlapRB.setText(ElanLocale.getString("OverlapsDialog.Radio.Overlap"));
        this.valuesTheSameRB.setText(ElanLocale.getString("MergeTiers.Radio.ValuesTheSame"));
        this.valuesDifferentRB.setText(ElanLocale.getString("MergeTiers.Radio.ValuesDifferent"));
        this.valuesMatchConstraintsRB.setText(ElanLocale.getString("OverlapsDialog.Radio.ValuesMatchConstraints"));
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        panel.add((Component)this.specificValueCB, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)this.specificValueTF, gbc);
        this.criteriaPanel.remove(this.valuesTheSameRB);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = this.singleTabInset;
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.criteriaPanel.add((Component)this.valuesTheSameRB, gbc);
        gbc.insets = new Insets(0, 60, 0, 10);
        gbc.gridy = 6;
        this.criteriaPanel.add((Component)panel, gbc);
        gbc.gridy = 7;
        gbc.weightx = 1.0;
        gbc.insets = this.globalInset;
        this.criteriaPanel.add((Component)this.onlyOverlapsCB, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MergeTiers.Title.Step2");
    }

    @Override
    public boolean leaveStepForward() {
        this.validateCriteria = true;
        this.updateButtonStates();
        if (!this.validCriteria) {
            return false;
        }
        int overlapsCriteria = 0;
        if (this.overlapRB.isSelected()) {
            overlapsCriteria = 0;
        } else if (this.valuesTheSameRB.isSelected()) {
            overlapsCriteria = 1;
        } else if (this.valuesDifferentRB.isSelected()) {
            overlapsCriteria = 2;
        } else if (this.valuesMatchConstraintsRB.isSelected()) {
            overlapsCriteria = 3;
        }
        if (this.constraintValues == null) {
            this.constraintValues = new ArrayList();
        }
        if (this.specificValueCB.isSelected()) {
            this.constraintValues.clear();
            this.constraintValues.add(new String[]{this.specificValueTF.getText().trim()});
        }
        this.multiPane.putStepProperty("OnlyProcessOverlapingAnnotations", this.onlyOverlapsCB.isSelected());
        this.multiPane.putStepProperty("overlapsCriteria", overlapsCriteria);
        this.multiPane.putStepProperty("tierValueConstraints", this.constraintValues);
        return true;
    }

    @Override
    public void updateButtonStates() {
        if (this.validateCriteria) {
            this.createAnnotationLabel.setForeground(Color.BLACK);
            this.createAnnotationLabel.setText(ElanLocale.getString("MergeTiers.Label.MergeAnn"));
            this.specificValueCB.setForeground(Color.BLACK);
            if (this.valuesTheSameRB.isEnabled() && this.valuesTheSameRB.isSelected() && this.specificValueCB.isSelected()) {
                if (this.specificValueTF.getText().trim().length() <= 0) {
                    this.specificValueCB.setForeground(Color.RED);
                    this.validCriteria = false;
                } else {
                    this.validCriteria = true;
                }
            } else if (!this.onlyOverlapsCB.isSelected() && (this.valuesTheSameRB.isSelected() || this.valuesDifferentRB.isSelected())) {
                this.createAnnotationLabel.setForeground(Color.RED);
                this.createAnnotationLabel.setText(this.createAnnotationLabel.getText() + " - " + ElanLocale.getString("MergeTiers.Criteria.Select"));
                this.validCriteria = false;
            } else {
                this.validCriteria = true;
                this.validateCriteria = false;
            }
        } else {
            this.validCriteria = true;
        }
        this.multiPane.setButtonEnabled(1, this.validCriteria);
        this.multiPane.setButtonEnabled(2, true);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.updateButtonStates();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.updateButtonStates();
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.updateButtonStates();
    }
}

