/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.MergeTierGroupCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.tier.CalcOverlapsStep3;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Transcription;

public class MergeTierGroupStep3
extends CalcOverlapsStep3
implements ProgressListener {
    private MergeTierGroupCommand com;

    public MergeTierGroupStep3(MultiStepPane multiPane, Transcription transcription) {
        super(multiPane, transcription);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("OverlapsDialog.MergingGroups");
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        String tierName1 = (String)this.multiPane.getStepProperty("Source-1");
        String tierName2 = (String)this.multiPane.getStepProperty("Source-2");
        String destTierSuffix = (String)this.multiPane.getStepProperty("Suffix");
        if (tierName1 == null || tierName2 == null || destTierSuffix == null) {
            this.progressInterrupted(null, "Illegal argument: a tier could not be found");
        }
        this.com = (MergeTierGroupCommand)ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.MergeTierGroup");
        this.com.addProgressListener(this);
        this.com.execute(this.transcription, new Object[]{tierName1, tierName2, destTierSuffix});
        return false;
    }
}

