/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tier;

import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;

public class TierExportTable
extends JTable {
    protected DefaultTableModel model;
    int selectionMode;

    public TierExportTable(DefaultTableModel model) {
        this(model, 1, false);
    }

    public TierExportTable(DefaultTableModel model, boolean showTableHeader) {
        this(model, 1, showTableHeader);
    }

    public TierExportTable(DefaultTableModel model, int selectionMode) {
        super(model);
        this.model = model;
        this.init(selectionMode, false);
    }

    public TierExportTable(DefaultTableModel model, int selectionMode, boolean showTableHeader) {
        super(model);
        this.model = model;
        this.init(selectionMode, showTableHeader);
    }

    public void init(int selectionMode, boolean showTableHeader) {
        if (this.model.getColumnCount() < 2) {
            this.model.setColumnCount(2);
        }
        DefaultCellEditor cellEd = new DefaultCellEditor(new JCheckBox());
        TableColumn column0 = this.getColumnModel().getColumn(0);
        column0.setCellEditor(cellEd);
        column0.setCellRenderer(new CheckBoxTableCellRenderer());
        column0.setMaxWidth(30);
        this.setSelectionMode(selectionMode);
        this.getSelectionModel().setSelectionMode(selectionMode);
        this.setShowVerticalLines(false);
        if (!showTableHeader) {
            this.setTableHeader(null);
        }
    }

    @Override
    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionInterval(int from, int to) {
        this.getSelectionModel().setSelectionInterval(from, to);
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.getSelectionModel().addListSelectionListener(listener);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        super.valueChanged(lse);
        if (this.model != null && lse.getValueIsAdjusting()) {
            if (this.selectionMode == 0) {
                int i = this.getSelectedRow();
                if (i > -1) {
                    for (int j = 0; j < this.getRowCount(); ++j) {
                        if (j == i) {
                            this.model.setValueAt(Boolean.TRUE, j, 0);
                            continue;
                        }
                        this.model.setValueAt(Boolean.FALSE, j, 0);
                    }
                    this.revalidate();
                }
            } else {
                int b = lse.getFirstIndex();
                int e = lse.getLastIndex();
                for (int i = b; i <= e; ++i) {
                    if (!this.isRowSelected(i)) continue;
                    this.model.setValueAt(Boolean.TRUE, i, 0);
                }
            }
        }
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        int i;
        super.editingStopped(e);
        if (this.selectionMode == 0 && (i = this.getSelectedRow()) >= 0) {
            int rowCount = this.model.getRowCount();
            for (int j = 0; j < rowCount; ++j) {
                if (j == i) continue;
                this.model.setValueAt(Boolean.FALSE, j, 0);
            }
        }
    }

    @Override
    public void editingCanceled(ChangeEvent e) {
        super.editingCanceled(e);
    }
}

