/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tiersets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DropMode;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.TransferHandler;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.annotator.tiersets.EditTierSetDlg;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.tiersets.TierSetUtil;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ManageTierSetDlg
extends ClosableDialog
implements ActionListener,
ListSelectionListener {
    private JPanel tierSetButtonPanel;
    private JButton addButton;
    private JButton deleteButton;
    private JButton sortButton;
    private JButton upButton;
    private JButton downButton;
    private JPanel tierSetPanel;
    private JTable tierSetTable;
    private DefaultTableModel tierSetModel;
    private JPanel tierSetAttriPanel;
    private JTable tierTable;
    private DefaultTableModel tierModel;
    private JLabel missingTiersLabel;
    private JButton editButton;
    private JTextArea nameTextArea;
    private JTextArea descTextArea;
    private JButton okButton;
    private JButton cancelButton;
    private AbstractTierSortAndSelectPanel tierSelectPanel;
    protected final String VISIBLE_COLUMN = ElanLocale.getString("SignalViewer.Segmentation.Visible");
    protected final String NAME_COLUMN = ElanLocale.getString("AboutDialog.Name");
    protected final int VISIBLE_COL_INDEX = 0;
    protected final int NAME_COL_INDEX = 1;
    private TierSetUtil tierSetUtil;
    private TranscriptionImpl transcription;
    private List<File> openFilesList;
    private List<String> missingTiersList;
    private HashMap<String, HashMap<String, Boolean>> tierSetMap;
    private Insets globalInsets = new Insets(2, 4, 2, 4);

    public ManageTierSetDlg(ElanFrame2 frame) {
        super(frame, ElanLocale.getString("TierSet.Title.ManageTierSet"), true);
        if (frame.getViewerManager() != null) {
            this.transcription = (TranscriptionImpl)frame.getViewerManager().getTranscription();
        }
        this.tierSetUtil = TierSetUtil.getTierSetUtilInstance();
        this.missingTiersList = new ArrayList<String>();
        this.tierSetMap = new HashMap();
        this.initComponents();
        WindowLocationAndSizeManager.postInit(this, "ManageTierSetDlg");
    }

    private void initTierSetPanel() {
        this.initTierSetButtonPanel();
        this.tierSetModel = new TierExportTableModel();
        this.tierSetTable = new JTable(this.tierSetModel);
        this.tierSetTable.setDragEnabled(true);
        this.tierSetTable.setDropMode(DropMode.USE_SELECTION);
        this.tierSetTable.setTransferHandler(ManageTierSetDlg.tableDragAndDropHandler());
        this.initTableAndModel(this.tierSetTable, this.tierSetModel);
        this.tierSetPanel = new JPanel();
        this.tierSetPanel.setLayout(new GridBagLayout());
        this.tierSetPanel.setBorder(new TitledBorder(ElanLocale.getString("TierSet.TierSetList")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.tierSetPanel.add((Component)new JScrollPane(this.tierSetTable), gbc);
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.tierSetPanel.add((Component)this.tierSetButtonPanel, gbc);
    }

    protected static final TransferHandler tableDragAndDropHandler() {
        return new TransferHandler(){
            DataFlavor intArrayDataFlavor = new DataFlavor(int[].class, "Integer Array");

            @Override
            public int getSourceActions(JComponent c) {
                return 3;
            }

            @Override
            public Transferable createTransferable(JComponent comp) {
                JTable table = (JTable)comp;
                int[] rows = table.getSelectedRows();
                TransferableIntArray transferable = new TransferableIntArray(rows);
                return transferable;
            }

            @Override
            public boolean canImport(TransferHandler.TransferSupport info) {
                return info.isDataFlavorSupported(this.intArrayDataFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                int[] rows;
                if (!support.isDrop()) {
                    return false;
                }
                if (!this.canImport(support)) {
                    return false;
                }
                JTable table = (JTable)support.getComponent();
                DefaultTableModel tableModel = (DefaultTableModel)table.getModel();
                JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                int dropRow = dl.getRow();
                try {
                    rows = (int[])support.getTransferable().getTransferData(this.intArrayDataFlavor);
                }
                catch (UnsupportedFlavorException e) {
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
                ArrayList<Object[]> tierSetList = new ArrayList<Object[]>();
                int selectedRowsAboveDropRow = 0;
                for (int i = rows.length - 1; i >= 0; --i) {
                    if (rows[i] < dropRow) {
                        ++selectedRowsAboveDropRow;
                    }
                    Boolean isVisible = (Boolean)table.getModel().getValueAt(rows[i], 0);
                    String tierName = (String)table.getModel().getValueAt(rows[i], 1);
                    System.out.println("TIERNAME: " + tierName);
                    tierSetList.add(new Object[]{isVisible, tierName});
                    tableModel.removeRow(rows[i]);
                }
                int insertRow = dropRow - selectedRowsAboveDropRow;
                for (int i = 0; i < tierSetList.size(); ++i) {
                    tableModel.insertRow(insertRow, (Object[])tierSetList.get(i));
                }
                table.setRowSelectionInterval(insertRow, insertRow + rows.length - 1);
                return true;
            }

            class TransferableIntArray
            implements Transferable {
                protected DataFlavor[] supportedFlavors;
                int[] intArray;

                public TransferableIntArray(int[] intArray) {
                    this.supportedFlavors = new DataFlavor[]{intArrayDataFlavor};
                    this.intArray = intArray;
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    if (flavor.equals(intArrayDataFlavor)) {
                        return this.intArray;
                    }
                    throw new UnsupportedFlavorException(flavor);
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return this.supportedFlavors;
                }

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return flavor.equals(intArrayDataFlavor);
                }
            }
        };
    }

    private void initTierSetButtonPanel() {
        this.addButton = new JButton();
        this.addButton.setToolTipText(ElanLocale.getString("Button.Add"));
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton();
        this.deleteButton.setToolTipText(ElanLocale.getString("Button.Delete"));
        this.deleteButton.addActionListener(this);
        this.sortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Sort"));
        this.sortButton.addActionListener(this);
        this.upButton = new JButton();
        this.upButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Up"));
        this.upButton.addActionListener(this);
        this.downButton = new JButton();
        this.downButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Down"));
        this.downButton.addActionListener(this);
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        try {
            ImageIcon addIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif"));
            ImageIcon removeIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif"));
            this.addButton.setIcon(addIcon);
            this.deleteButton.setIcon(removeIcon);
        }
        catch (Exception ex) {
            this.addButton.setText("+");
            this.deleteButton.setText("-");
        }
        this.tierSetButtonPanel = new JPanel();
        this.tierSetButtonPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.tierSetButtonPanel.add((Component)this.upButton, gbc);
        gbc.gridx = 1;
        this.tierSetButtonPanel.add(this.downButton);
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        this.tierSetButtonPanel.add(this.sortButton);
        gbc.gridx = 3;
        gbc.anchor = 13;
        this.tierSetButtonPanel.add(this.addButton);
        gbc.gridx = 4;
        this.tierSetButtonPanel.add(this.deleteButton);
    }

    private void initTierSetAttributePanel() {
        this.tierModel = new TierExportTableModel();
        this.tierTable = new JTable(this.tierModel);
        this.tierTable.setRowSelectionAllowed(false);
        if (this.transcription != null) {
            this.tierTable.setDefaultRenderer(Object.class, new MyTableCellRender());
        }
        this.initTableAndModel(this.tierTable, this.tierModel);
        this.editButton = new JButton(ElanLocale.getString("Menu.Edit"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this);
        this.nameTextArea = new JTextArea(1, 1);
        this.nameTextArea.setEditable(false);
        this.descTextArea = new JTextArea(5, 1);
        this.descTextArea.setWrapStyleWord(true);
        this.descTextArea.setEditable(false);
        this.missingTiersLabel = new JLabel();
        this.missingTiersLabel.setFont(new Font(this.missingTiersLabel.getFont().getFontName(), 0, 10));
        this.missingTiersLabel.setForeground(Color.RED);
        this.tierSetAttriPanel = new JPanel();
        this.tierSetAttriPanel.setLayout(new GridBagLayout());
        this.tierSetAttriPanel.setBorder(new TitledBorder(ElanLocale.getString("TierSet.Attributes")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(4, 2, 4, 2);
        gbc.anchor = 18;
        gbc.fill = 0;
        this.tierSetAttriPanel.add((Component)new JLabel(ElanLocale.getString("TierSet.Name")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.tierSetAttriPanel.add((Component)this.nameTextArea, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.tierSetAttriPanel.add((Component)new JLabel(ElanLocale.getString("TierSet.Description")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.tierSetAttriPanel.add((Component)this.descTextArea, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        this.tierSetAttriPanel.add((Component)new JLabel(ElanLocale.getString("TierSet.TierList")), gbc);
        gbc.gridy = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.tierSetAttriPanel.add((Component)new JScrollPane(this.tierTable), gbc);
        gbc.gridy = 4;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 12;
        this.tierSetAttriPanel.add((Component)this.missingTiersLabel, gbc);
        gbc.gridy = 5;
        gbc.anchor = 10;
        this.tierSetAttriPanel.add((Component)this.editButton, gbc);
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.initTierSetPanel();
        this.initTierSetAttributePanel();
        JLabel editTierLabel = new JLabel(ElanLocale.getString("TierSet.Title.EditTierSet"));
        editTierLabel.setFont(editTierLabel.getFont().deriveFont(14.0f));
        editTierLabel.setHorizontalAlignment(0);
        JLabel filePanelLabel = new JLabel("FileSelectionPannel");
        filePanelLabel.setFont(editTierLabel.getFont().deriveFont(14.0f));
        filePanelLabel.setHorizontalAlignment(0);
        this.okButton = new JButton(ElanLocale.getString("Button.Apply"));
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y++;
        gbc.insets = this.globalInsets;
        gbc.anchor = 18;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        gbc.weightx = 0.0;
        this.getContentPane().add((Component)this.tierSetPanel, gbc);
        gbc.gridx = 1;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.tierSetAttriPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        this.getContentPane().add((Component)buttonPanel, gbc);
        List<String> list = this.tierSetUtil.getTierSetList();
        for (String name : list) {
            TierSet tierSet = this.tierSetUtil.getTierSet(name);
            this.tierSetModel.addRow(new Object[]{tierSet.isVisible(), name});
        }
        this.tierSetTable.getSelectionModel().addListSelectionListener(this);
        if (this.tierSetTable.getRowCount() > 0) {
            this.tierSetTable.setRowSelectionInterval(0, 0);
        }
        this.updateMissingTiers();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ManageTierSetDlg.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        WindowLocationAndSizeManager.storeLocationAndSizePreferences(this, "ManageTierSetDlg");
        this.setVisible(false);
        this.dispose();
    }

    protected void initTableAndModel(JTable table, DefaultTableModel model) {
        model.setColumnIdentifiers(new String[]{this.VISIBLE_COLUMN, this.NAME_COLUMN});
        table.getColumn(this.VISIBLE_COLUMN).setCellEditor(new DefaultCellEditor(new JCheckBox()));
        table.getColumn(this.VISIBLE_COLUMN).setCellRenderer(new CheckBoxTableCellRenderer());
        table.getColumn(this.VISIBLE_COLUMN).setMaxWidth(60);
    }

    private void addTierSet() {
        EditTierSetDlg dlg = new EditTierSetDlg(this, ElanLocale.getString("TierSet.Title.NewTierSet"));
        dlg.setVisible(true);
        TierSet tierSet = dlg.getTierSet();
        if (tierSet != null) {
            this.tierSetModel.addRow(new Object[]{tierSet.isVisible(), tierSet.getName()});
            this.tierSetTable.setRowSelectionInterval(this.tierSetModel.getRowCount() - 1, this.tierSetModel.getRowCount() - 1);
        }
        this.updateMissingTiers();
    }

    private void updateMissingTiers() {
        if (this.transcription == null) {
            return;
        }
        this.missingTiersList.clear();
        for (int i = 0; i < this.tierSetTable.getRowCount(); ++i) {
            TierSet ts = this.tierSetUtil.getTierSet((String)this.tierSetTable.getValueAt(i, 1));
            List<String> tierList = ts.getTierList();
            for (String tier : tierList) {
                if (this.transcription.getTierWithId(tier) != null || this.missingTiersList.contains(tier)) continue;
                this.missingTiersList.add(tier);
            }
        }
        if (this.missingTiersList.size() > 0) {
            this.missingTiersLabel.setText("* tiers marked red are missing in this transcription");
        }
    }

    private void editTierSet() {
        String tierSetName = this.nameTextArea.getText();
        TierSet tierSet = TierSetUtil.getTierSetUtilInstance().getTierSet(tierSetName);
        EditTierSetDlg dlg = new EditTierSetDlg(this, tierSet, ElanLocale.getString("TierSet.Title.EditTierSet"));
        dlg.setVisible(true);
        tierSet = dlg.getTierSet();
        if (tierSet != null) {
            this.tierSetModel.setValueAt(tierSet.getName(), this.tierSetTable.getSelectedRow(), 1);
            this.loadTierSetDescPanel(tierSet);
        }
        this.updateMissingTiers();
    }

    private void deleteTierSet() {
        int selectedRowIndex = this.tierSetTable.getSelectedRow();
        this.tierSetModel.removeRow(selectedRowIndex);
        this.tierSetUtil.deleteTierSet(this.nameTextArea.getText());
        if (this.tierSetModel.getRowCount() > 0) {
            if (selectedRowIndex > this.tierSetTable.getRowCount() - 1) {
                selectedRowIndex = this.tierSetTable.getRowCount() - 1;
            }
            this.tierSetTable.setRowSelectionInterval(selectedRowIndex, selectedRowIndex);
        } else {
            this.loadTierSetDescPanel(null);
        }
        this.updateMissingTiers();
    }

    private void moveUp() {
        if (this.tierSetTable == null || this.tierSetModel == null || this.tierSetModel.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierSetTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierSetTable.isRowSelected(row - 1)) continue;
            this.tierSetModel.moveRow(row, row, row - 1);
            this.tierSetTable.changeSelection(row, 0, true, false);
            this.tierSetTable.changeSelection(row - 1, 0, true, false);
        }
    }

    private void moveDown() {
        if (this.tierSetTable == null || this.tierSetModel == null || this.tierSetModel.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierSetTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.tierSetModel.getRowCount() - 1 || this.tierSetTable.isRowSelected(row + 1)) continue;
            this.tierSetModel.moveRow(row, row, row + 1);
            this.tierSetTable.changeSelection(row, 0, true, false);
            this.tierSetTable.changeSelection(row + 1, 0, true, false);
        }
    }

    private void sortAZ() {
        String tierSetName;
        int i;
        if (this.tierSetModel.getRowCount() < 2) {
            return;
        }
        String curSelectedTS = "";
        if (this.tierSetTable.getSelectedRow() > -1) {
            curSelectedTS = (String)this.tierSetTable.getValueAt(this.tierSetTable.getSelectedRow(), 1);
        }
        HashMap<String, Boolean> tierSetVisibleMap = new HashMap<String, Boolean>();
        ArrayList<String> values = new ArrayList<String>(this.tierSetModel.getRowCount());
        for (i = 0; i < this.tierSetModel.getRowCount(); ++i) {
            tierSetName = (String)this.tierSetModel.getValueAt(i, 1);
            values.add(tierSetName);
            tierSetVisibleMap.put(tierSetName, (Boolean)this.tierSetModel.getValueAt(i, 0));
        }
        Collections.sort(values);
        this.tierSetTable.getSelectionModel().removeListSelectionListener(this);
        for (i = 0; i < this.tierSetModel.getRowCount(); ++i) {
            tierSetName = (String)values.get(i);
            this.tierSetModel.setValueAt(tierSetName, i, 1);
            this.tierSetModel.setValueAt(tierSetVisibleMap.get(tierSetName), i, 0);
            if (!tierSetName.equals(curSelectedTS)) continue;
            this.tierSetTable.setRowSelectionInterval(i, i);
        }
        this.tierSetTable.getSelectionModel().addListSelectionListener(this);
    }

    private void storeCurrentTierSetChanges() {
        String tierSetName = this.nameTextArea.getText().trim();
        HashMap<String, Boolean> tierMap = null;
        if (this.tierSetMap.containsKey(tierSetName)) {
            tierMap = this.tierSetMap.get(tierSetName);
            tierMap.clear();
        }
        if (tierMap == null) {
            tierMap = new HashMap();
            this.tierSetMap.put(tierSetName, tierMap);
        }
        for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
            String tierName = (String)this.tierTable.getValueAt(i, 1);
            boolean isVisible = (Boolean)this.tierTable.getValueAt(i, 0);
            tierMap.put(tierName, isVisible);
        }
    }

    private void loadTierSetDescPanel(TierSet tierSet) {
        this.nameTextArea.setText("");
        this.descTextArea.setText("");
        while (this.tierModel.getRowCount() > 0) {
            this.tierModel.removeRow(this.tierModel.getRowCount() - 1);
        }
        if (tierSet != null) {
            this.nameTextArea.setText(tierSet.getName());
            this.descTextArea.setText(tierSet.getDescription());
            if (this.tierSetMap.containsKey(tierSet.getName())) {
                HashMap<String, Boolean> tierMap = this.tierSetMap.get(tierSet.getName());
                List<String> visibleTiers = tierSet.getVisibleTierList();
                for (String tierName : tierSet.getTierList()) {
                    if (tierMap.containsKey(tierName)) {
                        this.tierModel.addRow(new Object[]{tierMap.get(tierName), tierName});
                        continue;
                    }
                    this.tierModel.addRow(new Object[]{visibleTiers.contains(tierName), tierName});
                }
            } else {
                List<String> visibleTiers = tierSet.getVisibleTierList();
                for (String tierName : tierSet.getTierList()) {
                    this.tierModel.addRow(new Object[]{visibleTiers.contains(tierName), tierName});
                }
            }
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
    }

    private List<String> getFileNamesList() {
        ArrayList<String> fileList = new ArrayList<String>();
        if (this.openFilesList != null) {
            for (File f : this.openFilesList) {
                fileList.add(f.getAbsolutePath());
            }
            return fileList;
        }
        return null;
    }

    public TranscriptionImpl getTranscription() {
        return this.transcription;
    }

    public void setTierSelectPanel(AbstractTierSortAndSelectPanel tierSelectPanel) {
        this.tierSelectPanel = tierSelectPanel;
    }

    public AbstractTierSortAndSelectPanel getTierSelectPanel() {
        return this.tierSelectPanel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.addButton) {
            this.addTierSet();
        } else if (source == this.editButton) {
            this.editTierSet();
        } else if (source == this.deleteButton) {
            this.deleteTierSet();
        } else if (source == this.sortButton) {
            this.sortAZ();
        } else if (source == this.upButton) {
            this.moveUp();
        } else if (source == this.downButton) {
            this.moveDown();
        } else if (source == this.okButton) {
            this.storeCurrentTierSetChanges();
            ArrayList<String> tierSetSortOrder = new ArrayList<String>();
            for (int i = 0; i < this.tierSetTable.getRowCount(); ++i) {
                String tierSetName = (String)this.tierSetTable.getValueAt(i, 1);
                TierSet tierSet = this.tierSetUtil.getTierSet(tierSetName);
                tierSetSortOrder.add(tierSetName);
                tierSet.setVisible((Boolean)this.tierSetTable.getValueAt(i, 0));
                HashMap<String, Boolean> tierMap = this.tierSetMap.get(tierSetName);
                if (tierMap == null) continue;
                for (String tierName : tierMap.keySet()) {
                    tierSet.setTierVisiblity(tierName, tierMap.get(tierName));
                }
            }
            this.tierSetUtil.updateTierSetSortOrder(tierSetSortOrder);
            this.tierSetUtil.writeTierSetsToFile();
            this.tierSetUtil.notifyAllListeners();
            this.closeDialog();
        } else if (ae.getSource() == this.cancelButton) {
            this.closeDialog();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (this.tierSetTable.getSelectedRow() > -1) {
            this.storeCurrentTierSetChanges();
            this.loadTierSetDescPanel(this.tierSetUtil.getTierSet((String)this.tierSetTable.getValueAt(this.tierSetTable.getSelectedRow(), 1)));
        }
    }

    private class MyTableCellRender
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (column == 1) {
                if (ManageTierSetDlg.this.missingTiersList.contains(value.toString())) {
                    cell.setForeground(Color.RED);
                } else {
                    cell.setForeground(table.getForeground());
                }
            } else {
                cell.setForeground(table.getForeground());
            }
            return cell;
        }
    }
}

