/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.tiersets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.client.annotator.tiersets.TierSet;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TierSetIO {
    private final String DESC = "DESCRIPTION";
    private final String NAME = "NAME";
    private final String TIER = "TIER";
    private final String TIERS = "TIERS";
    private final String TIERSET = "TIERSET";
    private final String TIERSETS = "TIERSETS";
    private final String VISIBLE = "VISIBLE";

    public List<TierSet> read(File file) throws IOException {
        if (file == null) {
            throw new IOException("Cannot read from file: file is null");
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            ParamHandler ph = new ParamHandler();
            reader.setContentHandler(ph);
            reader.parse(file.getAbsolutePath());
            return ph.getTierSetList();
        }
        catch (SAXException sax) {
            ClientLogger.LOG.warning("Parsing failed: " + sax.getMessage());
            throw new IOException(sax.getMessage());
        }
    }

    public void write(File file, List<TierSet> tierSetList) throws IOException {
        if (file == null) {
            throw new IOException("Cannot write to file: file is null");
        }
        if (tierSetList == null || tierSetList.isEmpty()) {
            throw new IOException("Cannot write to file: the tier set list is null or empty");
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))));
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<TIERSETS>");
        for (TierSet tierSet : tierSetList) {
            writer.println("<TIERSET NAME=\"" + tierSet.getName() + "\" DESCRIPTION=\"" + tierSet.getDescription() + "\" VISIBLE=\"" + tierSet.isVisible() + "\">");
            writer.println("<TIERS>");
            List<String> visibleTierList = tierSet.getVisibleTierList();
            List<String> tierList = tierSet.getTierList();
            for (String tier : tierList) {
                writer.println("<TIER NAME=\"" + tier + "\" VISIBLE=\"" + visibleTierList.contains(tier) + "\" />");
            }
            writer.println("</TIERS>");
            writer.println("</TIERSET>");
        }
        writer.println("</TIERSETS>");
        writer.close();
    }

    public void writeLS(File file, List<TierSet> tierSetList) throws IOException {
        if (file == null) {
            throw new IOException("Cannot write to file: file is null");
        }
        if (tierSetList == null || tierSetList.isEmpty()) {
            throw new IOException("Cannot write to file: the tier set list is null or empty");
        }
        Document doc = this.createDoc(tierSetList);
        try {
            IoUtil.writeEncodedFile("UTF-8", file.getAbsolutePath(), doc.getDocumentElement());
        }
        catch (Throwable t) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Error while writing the tierset file: " + t.getMessage());
            }
            throw new IOException(t);
        }
    }

    private Document createDoc(List<TierSet> tierSetList) throws IOException {
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
            Element docEl = doc.createElement("TIERSETS");
            if (docEl != null) {
                doc.appendChild(docEl);
            }
            for (TierSet tierSet : tierSetList) {
                Element tierSetEl = doc.createElement("TIERSET");
                docEl.appendChild(tierSetEl);
                tierSetEl.setAttribute("NAME", tierSet.getName());
                tierSetEl.setAttribute("DESCRIPTION", tierSet.getDescription());
                tierSetEl.setAttribute("VISIBLE", String.valueOf(tierSet.isVisible()));
                Element tiersEl = doc.createElement("TIERS");
                tierSetEl.appendChild(tiersEl);
                List<String> visibleTierList = tierSet.getVisibleTierList();
                List<String> tierList = tierSet.getTierList();
                for (String tier : tierList) {
                    Element tierEl = doc.createElement("TIER");
                    tiersEl.appendChild(tierEl);
                    tierEl.setAttribute("NAME", tier);
                    tierEl.setAttribute("VISIBLE", String.valueOf(visibleTierList.contains(tier)));
                }
            }
            return doc;
        }
        catch (ParserConfigurationException pce) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Could not create a document: " + pce.getMessage());
            }
            throw new IOException(pce);
        }
        catch (Throwable t) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Could not create a document: " + t.getMessage());
            }
            throw new IOException(t);
        }
    }

    class ParamHandler
    implements ContentHandler {
        private String curName = "";
        private String desc = "";
        private boolean isVisible;
        private List<String> tierList = null;
        private List<String> visibleTierList = null;
        private List<TierSet> tierSetList = new ArrayList<TierSet>();

        public List<TierSet> getTierSetList() {
            return this.tierSetList;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attributes) throws SAXException {
            if (name.equals("TIERSET")) {
                this.curName = attributes.getValue("NAME");
                this.desc = attributes.getValue("DESCRIPTION");
                this.isVisible = Boolean.valueOf(attributes.getValue("VISIBLE"));
            } else if (name.equals("TIERS")) {
                this.tierList = new ArrayList<String>();
                this.visibleTierList = new ArrayList<String>();
            } else if (name.equals("TIER")) {
                this.tierList.add(attributes.getValue("NAME"));
                if (Boolean.valueOf(attributes.getValue("VISIBLE")).booleanValue()) {
                    this.visibleTierList.add(attributes.getValue("NAME"));
                }
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String rawName) throws SAXException {
            if (name.equals("TIERSET")) {
                TierSet tierSet = new TierSet(this.curName, this.tierList);
                tierSet.setDescription(this.desc);
                tierSet.setVisibleTiers(this.visibleTierList);
                tierSet.setVisible(this.isVisible);
                this.tierSetList.add(tierSet);
                this.curName = "";
                this.tierList = null;
                this.visibleTierList = null;
                this.desc = "";
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String arg0) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        @Override
        public void processingInstruction(String arg0, String arg1) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator arg0) {
        }

        @Override
        public void skippedEntity(String arg0) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        }
    }
}

