/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.tier.TierTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;

public class ExtractStep1
extends StepPane
implements ActionListener,
ListSelectionListener {
    private TranscriptionImpl transcription;
    private JTable sourceTable;
    private TierTableModel tierModel;
    private JList dependList;
    private DefaultListModel depModel;
    private JButton newTierButton;

    public ExtractStep1(MultiStepPane multiPane, TranscriptionImpl transcription) {
        super(multiPane);
        this.transcription = transcription;
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        if (this.transcription != null) {
            List<TierImpl> allTiers = this.transcription.getTiers();
            ArrayList<TierImpl> alignables = new ArrayList<TierImpl>(allTiers.size());
            for (int i = 0; i < allTiers.size(); ++i) {
                TierImpl tier = allTiers.get(i);
                if (!tier.isTimeAlignable() || tier.getNumberOfAnnotations() <= 0) continue;
                alignables.add(tier);
            }
            this.tierModel = new TierTableModel(alignables, new String[]{"TierName", "Parent", "LinguisticType"});
            this.sourceTable = new JTable(this.tierModel);
        } else {
            this.tierModel = new TierTableModel();
            this.sourceTable = new JTable(this.tierModel);
        }
        this.sourceTable.setSelectionMode(0);
        JScrollPane tableScroll = new JScrollPane(this.sourceTable);
        this.depModel = new DefaultListModel();
        this.dependList = new JList(this.depModel);
        this.dependList.setSelectionMode(0);
        JScrollPane listScroll = new JScrollPane(this.dependList);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel("<html>" + ElanLocale.getString("TimeSeriesViewer.Extract.SourceTier") + "</html>"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)tableScroll, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        this.add((Component)new JLabel("<html>" + ElanLocale.getString("TimeSeriesViewer.Extract.DestTier") + "</html>"), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)listScroll, gbc);
        this.newTierButton = new JButton(ElanLocale.getString("Menu.Tier.AddNewTier"));
        this.newTierButton.addActionListener(this);
        this.newTierButton.setEnabled(false);
        gbc = new GridBagConstraints();
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = insets;
        this.add((Component)this.newTierButton, gbc);
        this.sourceTable.getSelectionModel().addListSelectionListener(this);
        this.dependList.getSelectionModel().addListSelectionListener(this);
    }

    private void updateDependentTierList() {
        this.multiPane.setButtonEnabled(1, false);
        this.depModel.removeAllElements();
        this.newTierButton.setEnabled(false);
        int row = this.sourceTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String tierName = this.tierModel.getValueAt(row, this.tierModel.findColumn("TierName"));
        TierImpl tier = this.transcription.getTierWithId(tierName);
        if (tier != null) {
            for (TierImpl loopTier : tier.getChildTiers()) {
                if (loopTier.getLinguisticType().getConstraints().getStereoType() != 4) continue;
                this.depModel.addElement(loopTier.getName());
            }
            if (this.depModel.getSize() > 0) {
                this.dependList.setSelectedIndex(0);
                this.multiPane.setButtonEnabled(1, true);
            }
            this.newTierButton.setEnabled(true);
        }
    }

    private void createTier() {
        int row = this.sourceTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        String tierName = this.tierModel.getValueAt(row, this.tierModel.findColumn("TierName"));
        TierImpl tier = this.transcription.getTierWithId(tierName);
        if (tier != null) {
            Command c;
            String name = JOptionPane.showInputDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Menu.Tier.AddNewTier"), 3);
            if (name == null || name.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.TierName"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            if (this.transcription.getTierWithId(name) != null) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTierDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 0);
                return;
            }
            List<LinguisticType> types = this.transcription.getLinguisticTypes();
            ArrayList<String> symbList = new ArrayList<String>(types.size());
            for (LinguisticType lt : types) {
                if (lt.getConstraints() == null || lt.getConstraints().getStereoType() != 4) continue;
                symbList.add(lt.getLinguisticTypeName());
            }
            if (symbList.size() == 0) {
                String typeName = JOptionPane.showInputDialog(this, ElanLocale.getString("EditTypeDialog.Message.TypeName"), ElanLocale.getString("Menu.Type.AddNewType"), 3);
                if (typeName == null || typeName.length() == 0) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTypeDialog.Message.TypeName"), ElanLocale.getString("Message.Error"), 0);
                    return;
                }
                if (this.transcription.getLinguisticTypeByName(typeName) != null) {
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("EditTypeDialog.Message.Exists"), ElanLocale.getString("Message.Error"), 0);
                    return;
                }
                c = ELANCommandFactory.createCommand(this.transcription, "Menu.Type.AddNewType");
                c.execute(this.transcription, new Object[]{typeName, new SymbolicAssociation(), null, Boolean.FALSE, Boolean.FALSE});
                LinguisticType lt = this.transcription.getLinguisticTypeByName(typeName);
                if (lt != null) {
                    symbList.add(typeName);
                } else {
                    return;
                }
            }
            String selTypeName = null;
            selTypeName = symbList.size() == 1 ? (String)symbList.get(0) : (String)JOptionPane.showInputDialog(this, ElanLocale.getString("TimeSeriesViewer.Extract.SelectType"), ElanLocale.getString("EditTypeDialog.ChangeType"), 3, null, symbList.toArray(), symbList.get(0));
            if (selTypeName != null) {
                c = ELANCommandFactory.createCommand(this.transcription, "Menu.Tier.AddNewTier");
                c.execute(this.transcription, new Object[]{name, tier, selTypeName, tier.getParticipant(), tier.getAnnotator(), tier.getDefaultLocale(), tier.getLangRef()});
                this.updateDependentTierList();
            }
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("TimeSeriesViewer.Extract.SelectTiers");
    }

    @Override
    public void enterStepBackward() {
        if (this.dependList.getSelectedIndex() < 0) {
            this.multiPane.setButtonEnabled(1, false);
        } else {
            this.multiPane.setButtonEnabled(1, true);
        }
    }

    @Override
    public boolean leaveStepForward() {
        if (this.sourceTable.getSelectedRow() >= 0 && this.dependList.getSelectedIndex() >= 0) {
            String sourceName = this.tierModel.getValueAt(this.sourceTable.getSelectedRow(), this.tierModel.findColumn("TierName"));
            this.multiPane.putStepProperty("SourceTier", sourceName);
            String destName = (String)this.dependList.getSelectedValue();
            this.multiPane.putStepProperty("DestTier", destName);
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.createTier();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            if (e.getSource() == this.sourceTable.getSelectionModel()) {
                this.updateDependentTierList();
            } else if (e.getSource() == this.dependList.getSelectionModel()) {
                if (this.dependList.getSelectedIndex() < 0) {
                    this.multiPane.setButtonEnabled(1, false);
                } else {
                    this.multiPane.setButtonEnabled(1, true);
                }
            }
        }
    }
}

