/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.timeseries.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Pattern;
import mpi.eudico.client.annotator.timeseries.TimeValue;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.util.TimeFormatter;

public class CSVReader
implements ClientLogger {
    private final String TAB = "\t";
    private final String SC = ";";
    private final String COMMA = ",";
    private File sourceFile;
    private FileReader fileRead;
    private BufferedReader bufRead;
    private String delimiter = null;
    private int numColumns = 1;
    private boolean trimLinesBeforeParsing = false;
    private float msPerSample = 0.0f;
    private float deltaT = 1.0f;
    private int sampleFrequency = 0;
    private int lastTimeCol = -1;
    private TimeFormatter.TIME_FORMAT lastDetectedTimeFormat = null;

    public CSVReader(File file) {
        if (file == null) {
            throw new NullPointerException("The file is null");
        }
        this.sourceFile = file;
        this.detectDelimiter();
    }

    public CSVReader(String fileName) {
        if (fileName == null) {
            throw new NullPointerException("The file name is null");
        }
        if (fileName.startsWith("file:")) {
            fileName = fileName.substring(5);
        }
        this.sourceFile = new File(fileName);
        this.detectDelimiter();
    }

    public void setDelimiter(String delimiter) {
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
    }

    private void detectDelimiter() {
        if (this.sourceFile == null) {
            return;
        }
        if (!this.sourceFile.exists() || this.sourceFile.isDirectory()) {
            return;
        }
        try {
            this.fileRead = new FileReader(this.sourceFile);
            this.bufRead = new BufferedReader(this.fileRead);
            int maxNumLines = 10;
            int numLines = 0;
            int numTabs = 0;
            int numCommas = 0;
            int numSemiCol = 0;
            String line = null;
            while ((line = this.bufRead.readLine()) != null && numLines < maxNumLines) {
                if (this.trimLinesBeforeParsing) {
                    line = line.trim();
                }
                if (line.length() == 0 || line.startsWith("#")) continue;
                ++numLines;
                Pattern pat = Pattern.compile("\t");
                numTabs += pat.split(line).length - 1;
                pat = Pattern.compile(";");
                numSemiCol += pat.split(line).length - 1;
                pat = Pattern.compile(",");
                numCommas += pat.split(line).length - 1;
            }
            try {
                this.bufRead.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String del = null;
            if (numTabs > numSemiCol && numTabs > numCommas) {
                del = "\t";
            } else if (numSemiCol > numTabs && numSemiCol > numCommas) {
                del = ";";
            } else if (numCommas > numTabs && numCommas > numSemiCol) {
                del = ",";
            }
            this.delimiter = del;
            if (this.delimiter == null) {
                LOG.warning("Could not detect the delimiter");
            }
        }
        catch (IOException ioe) {
            LOG.warning("Cannot detect delimiter: " + ioe.getMessage());
        }
    }

    public boolean isValidFile() {
        return this.delimiter != null;
    }

    public int getNumColumns() {
        if (this.numColumns == 1) {
            try {
                this.numColumns = this.detectNumColumns();
            }
            catch (IOException ioe) {
                LOG.warning("Could not detect the number of columns: " + ioe.getMessage());
            }
        }
        return this.numColumns;
    }

    private int detectNumColumns() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        int maxNumLines = 10;
        int numLines = 0;
        int numCols = 0;
        String line = null;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = this.bufRead.readLine()) != null && numLines < maxNumLines) {
            if (this.trimLinesBeforeParsing) {
                line = line.trim();
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            ++numLines;
            numCols += pat.split(line).length;
        }
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (numLines > 0 && numCols > 0) {
            this.numColumns = Math.round((float)numCols / (float)numLines);
            return this.numColumns;
        }
        return 1;
    }

    public List<String[]> getSamples(int rowCount) throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("No source file specified");
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        String line = null;
        int count = 0;
        Pattern pat = Pattern.compile(this.delimiter);
        while ((line = this.bufRead.readLine()) != null && count < rowCount) {
            if (this.trimLinesBeforeParsing) {
                line = line.trim();
            }
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] nextRow = pat.split(line);
            rows.add(nextRow);
            ++count;
        }
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rows;
    }

    public int getSampleFrequency() {
        return this.sampleFrequency;
    }

    private void detectSampleFrequency(int column) throws IOException {
        long time;
        if (this.sourceFile == null) {
            return;
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        Pattern pat = Pattern.compile(this.delimiter);
        int numSamplesRead = 0;
        long curDuration = 0L;
        long firstTime = time = 0L;
        String li = null;
        while ((li = this.bufRead.readLine()) != null && numSamplesRead < 20) {
            if (this.trimLinesBeforeParsing) {
                li = li.trim();
            }
            if (li.length() == 0 || li.trim().startsWith("#")) continue;
            time = this.getTime(li, column, pat);
            if (time > -1L) {
                curDuration = time;
            }
            if (numSamplesRead == 0) {
                firstTime = curDuration;
            }
            ++numSamplesRead;
        }
        if (numSamplesRead > 1) {
            float average = (float)(curDuration - firstTime) / (float)(numSamplesRead - 1);
            this.sampleFrequency = Math.round(1000.0f / average);
            this.msPerSample = 1000.0f * (1.0f / (float)this.sampleFrequency);
            this.deltaT = this.msPerSample / 1000.0f;
            LOG.info("Sec Per Sample: " + average + " - Freq. " + this.sampleFrequency);
            LOG.info("Ms per sample: " + this.msPerSample + " - dT: " + this.deltaT);
        }
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void detectTimeFormat(int column) throws IOException {
        if (this.sourceFile == null) {
            return;
        }
        this.lastDetectedTimeFormat = null;
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        Pattern pattern = Pattern.compile(this.delimiter);
        int numSamplesRead = 0;
        String li = null;
        int hmCount = 0;
        int secCount = 0;
        int msCount = 0;
        while ((li = this.bufRead.readLine()) != null && numSamplesRead < 20) {
            if (this.trimLinesBeforeParsing) {
                li = li.trim();
            }
            if (li.length() == 0 || li.trim().startsWith("#")) continue;
            String[] row = pattern.split(li);
            if (row.length > column) {
                String timeString = row[column];
                if (timeString.indexOf(58) > -1) {
                    ++hmCount;
                } else if (timeString.indexOf(46) > -1 || timeString.indexOf(44) > -1) {
                    ++secCount;
                } else {
                    ++msCount;
                }
            }
            ++numSamplesRead;
        }
        if (numSamplesRead > 1) {
            if (hmCount > secCount && hmCount > msCount) {
                this.lastDetectedTimeFormat = TimeFormatter.TIME_FORMAT.HHMMSSMS;
            } else if (secCount > hmCount && secCount >= msCount) {
                this.lastDetectedTimeFormat = TimeFormatter.TIME_FORMAT.SSMS;
            } else if (msCount > hmCount && msCount > secCount) {
                this.lastDetectedTimeFormat = TimeFormatter.TIME_FORMAT.MS;
            }
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(String.format("Detected time format in column %d: %s", new Object[]{column, this.lastDetectedTimeFormat}));
            }
        }
        try {
            this.bufRead.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private float getFloat(String line, int column, Pattern pattern) {
        if (line == null || pattern == null || column < 0) {
            return -1.0f;
        }
        String[] row = pattern.split(line);
        if (row.length > column) {
            return this.toFloat(row[column]);
        }
        return -1.0f;
    }

    private long getTime(String line, int timeCol, Pattern pattern) {
        if (line == null || line.length() == 0) {
            return -1L;
        }
        long t = -1L;
        String[] row = pattern.split(line);
        if (row.length > timeCol) {
            t = TimeFormatter.toMilliSeconds(row[timeCol], this.lastDetectedTimeFormat);
        }
        return t;
    }

    private TimeValue getTimeValue(String line, int timeCol, int dataCol, Pattern pattern) {
        if (line == null || line.length() == 0) {
            return null;
        }
        long t = 0L;
        float v = 0.0f;
        String[] row = pattern.split(line);
        if (row.length > timeCol) {
            t = TimeFormatter.toMilliSeconds(row[timeCol], this.lastDetectedTimeFormat);
        }
        if (row.length > dataCol) {
            v = this.toFloat(row[dataCol]);
        }
        return new TimeValue(t, v);
    }

    private float toFloat(String val) {
        try {
            return Float.parseFloat(val);
        }
        catch (NumberFormatException nfe) {
            LOG.warning("Could not parse float: " + val);
            return Float.NaN;
        }
    }

    private Object readTrack(int timeCol, int dataCol, int derLevel, boolean continuousRate) throws IOException {
        if (!this.isValidFile()) {
            return null;
        }
        if (timeCol < 0 || dataCol < 0) {
            throw new IllegalArgumentException("Time column and data column must be greater than or equal to 0");
        }
        if (timeCol != this.lastTimeCol) {
            if (continuousRate) {
                this.detectSampleFrequency(timeCol);
            }
            this.detectTimeFormat(timeCol);
            this.lastTimeCol = timeCol;
        }
        this.fileRead = new FileReader(this.sourceFile);
        this.bufRead = new BufferedReader(this.fileRead);
        ArrayList<Comparable<TimeValue>> values = new ArrayList<Comparable<TimeValue>>();
        Pattern pat = Pattern.compile(this.delimiter);
        long curTimeStamp = 0L;
        long firstTimeStamp = 0L;
        float curSample = 0.0f;
        int sampleCount = 0;
        TimeValue tv = null;
        String li = null;
        float[][] derivArray = null;
        if (derLevel > 0) {
            derivArray = new float[derLevel + 1][2];
        }
        while ((li = this.bufRead.readLine()) != null) {
            if (this.trimLinesBeforeParsing) {
                li = li.trim();
            }
            if (li.length() == 0 || li.trim().startsWith("#")) continue;
            tv = this.getTimeValue(li, timeCol, dataCol, pat);
            if (tv != null) {
                curTimeStamp = tv.time;
                curSample = tv.value;
                if (!continuousRate) {
                    if (derLevel == 0) {
                        values.add(tv);
                    } else if (sampleCount == 0) {
                        derivArray[0][0] = curSample;
                        firstTimeStamp = curTimeStamp;
                    } else if (sampleCount == 1) {
                        derivArray[0][1] = curSample;
                        this.calculateDerivatives(derivArray);
                        values.add(new TimeValue(firstTimeStamp, derivArray[derivArray.length - 1][1]));
                        values.add(new TimeValue(curTimeStamp, derivArray[derivArray.length - 1][1]));
                    } else {
                        this.shiftSamplesInArray(derivArray);
                        derivArray[0][1] = curSample;
                        this.calculateDerivatives(derivArray);
                        values.add(new TimeValue(curTimeStamp, derivArray[derivArray.length - 1][1]));
                    }
                } else {
                    if (sampleCount == 0 && (double)curTimeStamp > 1.5 * (double)this.msPerSample) {
                        float fillSample = this.msPerSample;
                        while (fillSample < (float)curTimeStamp - this.msPerSample) {
                            values.add(new Float(0.0f));
                            fillSample += this.msPerSample;
                            ++sampleCount;
                        }
                    }
                    if ((float)curTimeStamp - (float)sampleCount * this.msPerSample > this.msPerSample / 2.0f) {
                        LOG.info("Adding fill-in at sample: " + sampleCount);
                        if (derLevel == 0) {
                            values.add(new Float(curSample));
                        } else {
                            this.shiftSamplesInArray(derivArray);
                            derivArray[0][1] = curSample;
                            this.calculateDerivatives(derivArray);
                            values.add(new Float(derivArray[derivArray.length - 1][1]));
                        }
                        ++sampleCount;
                    }
                    if (derLevel == 0) {
                        values.add(new Float(curSample));
                    } else if (sampleCount == 0) {
                        derivArray[0][0] = curSample;
                    } else if (sampleCount == 1) {
                        derivArray[0][1] = curSample;
                        this.calculateDerivatives(derivArray);
                        values.add(new Float(derivArray[derivArray.length - 1][1]));
                        values.add(new Float(derivArray[derivArray.length - 1][1]));
                    } else {
                        this.shiftSamplesInArray(derivArray);
                        derivArray[0][1] = curSample;
                        this.calculateDerivatives(derivArray);
                        values.add(new Float(derivArray[derivArray.length - 1][1]));
                    }
                }
            }
            ++sampleCount;
            curSample = 0.0f;
        }
        LOG.info("Derivative: " + derLevel + " Number of samples: " + sampleCount + " Last time value: " + tv.time);
        try {
            this.bufRead.close();
        }
        catch (IOException fillSample) {
            // empty catch block
        }
        if (continuousRate) {
            float[] result = new float[sampleCount];
            for (int i = 0; i < sampleCount; ++i) {
                Float fl = (Float)values.get(i);
                result[i] = fl.floatValue();
            }
            return result;
        }
        return values;
    }

    public float[] readContinuousRateTrack(int timeCol, int dataCol, int derLevel) throws IOException {
        return (float[])this.readTrack(timeCol, dataCol, derLevel, true);
    }

    public List<TimeValue> readNonContinuousRateTrack(int timeCol, int dataCol, int derLevel) throws IOException {
        return (List)this.readTrack(timeCol, dataCol, derLevel, false);
    }

    private void calculateDerivatives(float[][] derivArray) {
        for (int i = 0; i < derivArray.length - 1; ++i) {
            derivArray[i + 1][1] = (derivArray[i][1] - derivArray[i][0]) / this.deltaT;
        }
    }

    private void shiftSamplesInArray(float[][] derivArray) {
        for (int i = 0; i < derivArray.length; ++i) {
            derivArray[i][0] = derivArray[i][1];
        }
    }

    public boolean isTrimLinesBeforeParsing() {
        return this.trimLinesBeforeParsing;
    }

    public void setTrimLinesBeforeParsing(boolean trimLinesBeforeParsing) {
        this.trimLinesBeforeParsing = trimLinesBeforeParsing;
    }
}

