/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.transcriptionMode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.HTMLViewer;
import mpi.eudico.client.annotator.layout.TranscriptionManager;
import mpi.eudico.client.annotator.transcriptionMode.PossibleTypesExtractor;
import mpi.eudico.client.annotator.transcriptionMode.SelectChildTiersDlg;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class TranscriptionModeSettingsDlg
extends ClosableDialog
implements ActionListener,
ChangeListener,
ItemListener {
    private final String COLUMN_NO = ElanLocale.getString("TranscriptionModeSettingsDlg.Column.No");
    private final String COLUMN_TYPE = ElanLocale.getString("TranscriptionModeSettingsDlg.Column.SelectType");
    private final String DEFAULT_VALUE = ElanLocale.getString("TranscriptionModeSettingsDlg.DefaultValue");
    private Transcription transcription;
    private ElanLayoutManager layoutManager;
    private JComboBox fontSizeComboBox;
    private JSpinner spinner;
    private JTable table;
    private DefaultTableModel model;
    private JButton butSelectTiers;
    private JButton helpButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton addColButton;
    private JButton deleteColButton;
    private List<String> columnTypeList;
    private List<String> hiddenTiersList;
    PossibleTypesExtractor computeTypes;
    private Map<TierImpl, List<TierImpl>> tierMap;
    private final List<String> currentColumnTypeList;
    private final List<String> currentHiddenTiersList;
    private final Map<TierImpl, List<TierImpl>> currentTierMap;
    private SelectChildTiersDlg dialog;
    private int fontSize;
    private boolean valueChanged = false;
    private final int TYPE_COL_INDEX = 1;

    public TranscriptionModeSettingsDlg(ElanLayoutManager layoutManager, List<String> columnTypes, Map<TierImpl, List<TierImpl>> hashMap, List<String> hiddenTiers, Integer size) {
        super(layoutManager.getElanFrame(), ElanLocale.getString("TranscriptionModeSettingsDlg.Title"), true);
        List<String> possibleTypes;
        this.transcription = layoutManager.getViewerManager().getTranscription();
        this.layoutManager = layoutManager;
        this.computeTypes = new PossibleTypesExtractor((TranscriptionImpl)this.transcription);
        this.currentHiddenTiersList = new ArrayList<String>();
        this.currentColumnTypeList = new ArrayList<String>();
        this.currentTierMap = new HashMap<TierImpl, List<TierImpl>>();
        if (hashMap != null) {
            this.currentTierMap.putAll(hashMap);
        }
        if (hiddenTiers != null) {
            this.currentHiddenTiersList.addAll(hiddenTiers);
        }
        if (columnTypes != null) {
            this.currentColumnTypeList.addAll(columnTypes);
        }
        this.initComponents();
        if (size != null) {
            this.fontSizeComboBox.setSelectedItem(size);
            this.fontSize = size;
        }
        if (this.currentColumnTypeList != null && this.currentColumnTypeList.size() >= 1 && (possibleTypes = this.computeTypes.getPossibleTypesForColumn(1, this.columnTypeList)).contains(this.currentColumnTypeList.get(0))) {
            this.columnTypeList.add(this.currentColumnTypeList.get(0));
            this.table.setValueAt(this.currentColumnTypeList.get(0), 0, 1);
            for (int i = 1; i < this.currentColumnTypeList.size(); ++i) {
                int column = i + 1;
                possibleTypes = this.computeTypes.getPossibleTypesForColumn(column, this.columnTypeList);
                if (!possibleTypes.contains(this.currentColumnTypeList.get(i))) continue;
                this.columnTypeList.add(this.currentColumnTypeList.get(i));
                this.model.addRow(new Object[]{column, this.currentColumnTypeList.get(i)});
            }
            this.spinner.setValue(this.table.getRowCount());
        }
        this.applyButton.setEnabled(false);
        this.enableOrDisableSeletTierButton();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.hiddenTiersList = new ArrayList<String>();
        this.columnTypeList = new ArrayList<String>();
        this.tierMap = new HashMap<TierImpl, List<TierImpl>>();
        this.model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (this.getColumnName(column).equals(TranscriptionModeSettingsDlg.this.COLUMN_NO)) {
                    return false;
                }
                if (TranscriptionModeSettingsDlg.this.table.getValueAt(row, column) == null) {
                    return false;
                }
                return !TranscriptionModeSettingsDlg.this.table.getValueAt(row, column).toString().equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE);
            }
        };
        this.model.setColumnIdentifiers(new String[]{this.COLUMN_NO, this.COLUMN_TYPE});
        DefaultTableCellRenderer render = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value == null) {
                    return cell;
                }
                if (value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                    cell.setForeground(Color.GRAY);
                } else {
                    cell.setForeground(Color.BLACK);
                }
                return cell;
            }
        };
        this.table = new JTable(this.model);
        this.table.setCellSelectionEnabled(true);
        this.table.setDefaultEditor(Object.class, new TableCellEditor());
        this.table.setDefaultRenderer(Object.class, render);
        this.table.setShowGrid(true);
        this.table.setGridColor(Color.BLACK);
        this.table.setSelectionBackground(Color.WHITE);
        this.table.setRowHeight(this.table.getRowHeight() + 5);
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        this.fontSizeComboBox = new JComboBox();
        for (int element : Constants.FONT_SIZES) {
            this.fontSizeComboBox.addItem(element);
        }
        this.fontSizeComboBox.addItemListener(this);
        this.spinner = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.model.addRow(new Object[]{1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
        this.spinner.addChangeListener(this);
        this.butSelectTiers = new JButton(ElanLocale.getString("TranscriptionModeSettingsDlg.SelectTier"));
        this.butSelectTiers.setEnabled(false);
        this.helpButton = new JButton(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Help24.gif")));
        this.helpButton.setToolTipText(ElanLocale.getString("Button.Help.ToolTip"));
        this.helpButton.setPreferredSize(new Dimension(24, 24));
        this.addColButton = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Plus16.gif")));
        this.addColButton.setPreferredSize(new Dimension(20, 20));
        this.deleteColButton = new JButton(new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Minus16.gif")));
        this.deleteColButton.setPreferredSize(new Dimension(20, 20));
        this.applyButton = new JButton();
        this.applyButton.setText(ElanLocale.getString("Button.Apply"));
        this.applyButton.setEnabled(false);
        this.cancelButton = new JButton();
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.butSelectTiers.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.addColButton.addActionListener(this);
        this.deleteColButton.addActionListener(this);
        JLabel fontSizeLabel = new JLabel(ElanLocale.getString("TranscriptionModeSettingsDlg.FontSize"));
        JLabel columnNoLabel = new JLabel(ElanLocale.getString("TranscriptionModeSettingsDlg.SelectColumns"));
        JScrollPane scroller = new JScrollPane(this.table);
        Insets inset = new Insets(5, 10, 5, 10);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = inset;
        buttonPanel.add((Component)this.applyButton, gbc);
        gbc.gridx = 1;
        buttonPanel.add((Component)this.cancelButton, gbc);
        JPanel columnPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        columnPanel.add((Component)this.spinner, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        columnPanel.add((Component)this.addColButton, gbc);
        gbc.gridx = 2;
        columnPanel.add((Component)this.deleteColButton, gbc);
        this.getContentPane().setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.insets = inset;
        this.getContentPane().add((Component)this.helpButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.getContentPane().add((Component)fontSizeLabel, gbc);
        gbc.gridx = 1;
        this.getContentPane().add((Component)this.fontSizeComboBox, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.getContentPane().add((Component)columnNoLabel, gbc);
        gbc.gridx = 1;
        this.getContentPane().add((Component)columnPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)scroller, gbc);
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)this.butSelectTiers, gbc);
        gbc.gridx = 1;
        gbc.anchor = 13;
        this.getContentPane().add((Component)buttonPanel, gbc);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                TranscriptionModeSettingsDlg.this.doClose();
            }
        });
    }

    private void enableOrDisableSeletTierButton() {
        this.butSelectTiers.setEnabled(false);
        if (this.columnTypeList.size() >= 1) {
            this.butSelectTiers.setEnabled(true);
        }
    }

    public List<String> getColumnTypeList() {
        return this.columnTypeList;
    }

    public Map<TierImpl, List<TierImpl>> getTierMap() {
        return this.tierMap;
    }

    public List<String> getHiddenTiersList() {
        return this.hiddenTiersList;
    }

    public Integer getFontSize() {
        return (Integer)this.fontSizeComboBox.getSelectedItem();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void doApply() {
        this.valueChanged = false;
        if (this.currentColumnTypeList != null) {
            this.valueChanged = !this.currentColumnTypeList.equals(this.columnTypeList);
        } else if (this.columnTypeList.size() > 0) {
            this.valueChanged = true;
        }
        if (this.dialog != null) {
            if (this.valueChanged) {
                if (!this.columnTypeList.equals(this.dialog.getColumnTypes())) {
                    this.tierMap = null;
                    this.hiddenTiersList = null;
                }
            } else if (this.dialog.isValueChanged()) {
                this.valueChanged = true;
            } else if (this.tierMap != null && (this.tierMap.size() != this.currentTierMap.size() || this.tierMap.equals(this.currentTierMap))) {
                this.valueChanged = true;
            } else if (this.hiddenTiersList != null && (this.hiddenTiersList.size() != this.currentHiddenTiersList.size() || this.hiddenTiersList.equals(this.currentHiddenTiersList))) {
                this.valueChanged = true;
            }
        }
        this.doClose();
    }

    private void showSelectTiersDialog() {
        if (this.dialog != null) {
            if (!this.columnTypeList.equals(this.dialog.getColumnTypes())) {
                if (this.currentColumnTypeList != null && this.currentColumnTypeList.equals(this.columnTypeList)) {
                    this.dialog = new SelectChildTiersDlg(this.layoutManager, this.currentTierMap, this.currentHiddenTiersList, this.currentColumnTypeList);
                    this.tierMap = new HashMap<TierImpl, List<TierImpl>>();
                    this.tierMap.putAll(this.currentTierMap);
                    this.hiddenTiersList = new ArrayList<String>();
                    this.hiddenTiersList.addAll(this.currentHiddenTiersList);
                    this.columnTypeList.clear();
                    this.columnTypeList.addAll(this.currentColumnTypeList);
                } else {
                    this.tierMap = null;
                    this.hiddenTiersList = null;
                }
            }
            this.dialog = new SelectChildTiersDlg(this.layoutManager, this.tierMap, this.hiddenTiersList, this.columnTypeList);
        } else {
            boolean valueChanged = false;
            if (this.currentColumnTypeList != null) {
                valueChanged = !this.currentColumnTypeList.equals(this.columnTypeList);
            } else if (this.columnTypeList.size() > 0) {
                valueChanged = true;
            }
            if (!valueChanged) {
                this.tierMap.clear();
                this.tierMap.putAll(this.currentTierMap);
                this.hiddenTiersList.clear();
                this.hiddenTiersList.addAll(this.currentHiddenTiersList);
                this.columnTypeList.clear();
                this.columnTypeList.addAll(this.currentColumnTypeList);
            }
            this.dialog = new SelectChildTiersDlg(this.layoutManager, this.tierMap, this.hiddenTiersList, this.columnTypeList);
        }
        this.dialog.setVisible(true);
        if (this.dialog.isValueChanged()) {
            this.tierMap = this.dialog.getTierMap();
            this.hiddenTiersList = this.dialog.getHiddenTiers();
            this.applyButton.setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.doApply();
        } else if (e.getSource() == this.cancelButton) {
            this.columnTypeList = null;
            this.hiddenTiersList = null;
            this.tierMap = null;
            this.valueChanged = false;
            this.doClose();
        } else if (e.getSource() == this.butSelectTiers) {
            this.showSelectTiersDialog();
        } else if (e.getSource() == this.helpButton) {
            this.showHelpDialog();
        } else if (e.getSource() == this.addColButton) {
            int n = (Integer)this.spinner.getValue();
            this.spinner.setValue(++n);
        } else if (e.getSource() == this.deleteColButton) {
            int n = (Integer)this.spinner.getValue();
            this.spinner.setValue(--n);
        }
    }

    private void addRows() {
        int n = (Integer)this.spinner.getValue();
        Object value = null;
        while (this.table.getRowCount() < n) {
            if (n == 1) {
                this.model.addRow(new Object[]{this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
                continue;
            }
            if (this.table.getRowCount() >= 1) {
                value = this.table.getValueAt(this.table.getRowCount() - 1, 1);
            }
            if (value == null || value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING) || value.equals(this.DEFAULT_VALUE)) {
                if (this.table.getRowCount() <= 0) {
                    this.model.addRow(new Object[]{this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
                    continue;
                }
                this.model.addRow(new Object[]{this.table.getRowCount() + 1, null});
                continue;
            }
            this.model.addRow(new Object[]{this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
        }
    }

    private void deleteRows() {
        int n = (Integer)this.spinner.getValue();
        while (this.table.getRowCount() > n) {
            this.model.removeRow(this.table.getRowCount() - 1);
        }
        for (int i = this.columnTypeList.size(); i > this.table.getRowCount(); --i) {
            this.columnTypeList.remove(i - 1);
        }
    }

    private void deleteValuesAfter(int row) {
        for (int i = row + 1; i < this.table.getRowCount(); ++i) {
            if (i == row + 1) {
                this.table.setValueAt(TranscriptionManager.COMBOBOX_DEFAULT_STRING, i, 1);
                continue;
            }
            this.table.setValueAt(null, i, 1);
        }
        while (this.columnTypeList.size() > row) {
            this.columnTypeList.remove(this.columnTypeList.size() - 1);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int n = (Integer)this.spinner.getValue();
        if (n == 0) {
            this.deleteColButton.setEnabled(false);
        } else {
            this.deleteColButton.setEnabled(true);
        }
        if (e.getSource() == this.spinner) {
            if (this.table.getRowCount() < n) {
                this.addRows();
            } else if (this.table.getRowCount() > n) {
                this.deleteRows();
            }
        }
        this.applyButton.setEnabled(true);
    }

    private void showHelpDialog() {
        try {
            HTMLViewer helpViewer = new HTMLViewer("/mpi/eudico/client/annotator/resources/transcriptionModeHelpDoc.html", false, ElanLocale.getString("TranscriptionModeSettingsDlg.Help"));
            JDialog dialog = helpViewer.createHTMLDialog(this);
            dialog.pack();
            dialog.setSize(500, 600);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.LoadHelpFile") + " " + ioe.getMessage(), ElanLocale.getString("Message.Error"), 0, null);
        }
    }

    public boolean isValueChanged() {
        return this.valueChanged;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.fontSizeComboBox && this.fontSize != (Integer)this.fontSizeComboBox.getSelectedItem()) {
            this.fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
            this.applyButton.setEnabled(true);
        }
    }

    private class TableCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private int startEditInOneClick;
        private JComboBox comboBox;
        private int row;
        private String value;

        public TableCellEditor() {
            super(new JComboBox());
            this.startEditInOneClick = 1;
            this.setClickCountToStart(this.startEditInOneClick);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.row = row;
            this.value = value.toString();
            List<String> possibleTypes = TranscriptionModeSettingsDlg.this.computeTypes.getPossibleTypesForColumn(row + 1, TranscriptionModeSettingsDlg.this.columnTypeList);
            this.comboBox = new JComboBox();
            if (possibleTypes.size() == 0) {
                table.setValueAt(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE, row, column);
                return null;
            }
            for (int i = 0; i < possibleTypes.size(); ++i) {
                this.comboBox.addItem(possibleTypes.get(i));
            }
            if (value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                this.comboBox.setSelectedItem(null);
            } else if (possibleTypes.contains(value)) {
                this.comboBox.setSelectedItem(value);
            }
            this.comboBox.addActionListener(this);
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.comboBox) {
                if (this.comboBox.getSelectedItem() != null) {
                    TranscriptionModeSettingsDlg.this.table.editingStopped(new ChangeEvent(this));
                    if (this.value.equals(this.comboBox.getSelectedItem())) {
                        return;
                    }
                    TranscriptionModeSettingsDlg.this.applyButton.setEnabled(true);
                    if (TranscriptionModeSettingsDlg.this.table.getRowCount() - 1 > this.row) {
                        if (TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1) == null || TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1).toString().equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE)) {
                            TranscriptionModeSettingsDlg.this.table.setValueAt(TranscriptionManager.COMBOBOX_DEFAULT_STRING, this.row + 1, 1);
                        } else {
                            Object value = TranscriptionModeSettingsDlg.this.table.getValueAt(this.row + 1, 1);
                            if (!value.equals(TranscriptionModeSettingsDlg.this.DEFAULT_VALUE) && !value.equals(TranscriptionManager.COMBOBOX_DEFAULT_STRING)) {
                                TranscriptionModeSettingsDlg.this.deleteValuesAfter(this.row);
                            }
                        }
                    } else if (this.row == TranscriptionModeSettingsDlg.this.table.getRowCount() - 1) {
                        ((DefaultTableModel)TranscriptionModeSettingsDlg.this.table.getModel()).addRow(new Object[]{TranscriptionModeSettingsDlg.this.table.getRowCount() + 1, TranscriptionManager.COMBOBOX_DEFAULT_STRING});
                        TranscriptionModeSettingsDlg.this.spinner.setValue(TranscriptionModeSettingsDlg.this.table.getRowCount());
                    }
                    if (this.row <= TranscriptionModeSettingsDlg.this.columnTypeList.size() - 1) {
                        TranscriptionModeSettingsDlg.this.columnTypeList.set(this.row, this.comboBox.getSelectedItem().toString());
                    } else {
                        TranscriptionModeSettingsDlg.this.columnTypeList.add(this.comboBox.getSelectedItem().toString());
                    }
                }
                TranscriptionModeSettingsDlg.this.enableOrDisableSeletTierButton();
            }
        }
    }
}

