/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import mpi.eudico.server.corpora.clom.Annotation;

public class TaSAnno {
    private Annotation ann;
    private String participant;
    private long bt;
    private long et;
    private String curValue;

    public TaSAnno(Annotation annotation) {
        this.ann = annotation;
        this.setParticipant(annotation);
    }

    public TaSAnno(long begin, long end) {
        this.bt = begin;
        this.et = end;
        this.setParticipant(null);
    }

    private void setParticipant(Annotation annotation) {
        this.participant = annotation != null ? annotation.getTier().getParticipant() : "";
    }

    public String getParticipant() {
        return this.participant;
    }

    public Annotation getAnnotation() {
        return this.ann;
    }

    public void setAnnotation(Annotation ann) {
        this.ann = ann;
        this.setParticipant(ann);
    }

    public long getBeginTime() {
        if (this.ann != null) {
            return this.ann.getBeginTimeBoundary();
        }
        return this.bt;
    }

    public void setBeginTime(long bt) {
        this.bt = bt;
    }

    public long getEndTime() {
        if (this.ann != null) {
            return this.ann.getEndTimeBoundary();
        }
        return this.et;
    }

    public void setEndTime(long et) {
        this.et = et;
    }

    public String getText() {
        if (this.ann != null) {
            return this.ann.getValue();
        }
        if (this.curValue != null) {
            return this.curValue;
        }
        return "";
    }

    public void setText(String text) {
        this.curValue = text;
    }
}

