/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.turnsandscenemode;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.turnsandscenemode.TaSAnno;
import mpi.eudico.client.annotator.turnsandscenemode.TaSCellPanel;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;

public class TaSCellEditor
extends DefaultCellEditor {
    private TurnsAndSceneViewer viewer;
    private TaSCellPanel editorPanel;
    private Object curValue;

    public TaSCellEditor(TurnsAndSceneViewer viewer, TaSCellPanel editorPanel) {
        super(new JTextField());
        this.setClickCountToStart(1);
        this.viewer = viewer;
        this.editorPanel = editorPanel;
    }

    @Override
    public Component getComponent() {
        return this.editorPanel;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.curValue = value;
        TaSAnno tasAnn = null;
        if (value instanceof TaSAnno) {
            tasAnn = (TaSAnno)value;
            this.editorPanel.setTaSAnnotation(tasAnn);
        }
        this.editorPanel.setFont(table.getFont());
        if (tasAnn != null) {
            this.updateDecoration(tasAnn);
        }
        this.editorPanel.startEditing();
        return this.editorPanel;
    }

    public void startEditing() {
        this.editorPanel.startEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.curValue;
    }

    @Override
    public boolean stopCellEditing() {
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        super.cancelCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    @Override
    protected void fireEditingCanceled() {
        super.fireEditingCanceled();
    }

    private void updateDecoration() {
        if (this.curValue instanceof TaSAnno) {
            this.updateDecoration((TaSAnno)this.curValue);
        }
    }

    private void updateDecoration(TaSAnno tasAnno) {
        boolean inTimeSelection = false;
        if (this.viewer.getSelectionBeginTime() < this.viewer.getSelectionEndTime()) {
            inTimeSelection = this.viewer.getSelectionBeginTime() < tasAnno.getEndTime() && this.viewer.getSelectionEndTime() > tasAnno.getBeginTime();
        }
        this.editorPanel.setDecorations(inTimeSelection, tasAnno.getBeginTime() <= this.viewer.getMediaTime() && this.viewer.getMediaTime() < tasAnno.getEndTime(), this.viewer.getActiveAnnotation() != null && tasAnno.getAnnotation() == this.viewer.getActiveAnnotation(), tasAnno.getAnnotation() == null);
    }

    public void updatMediaTime(long mediaTime) {
        this.editorPanel.updatMediaTime(mediaTime);
    }

    public void repaint() {
        this.updateDecoration();
    }
}

